/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.undertow;

import io.micronaut.context.ApplicationContext;
import io.micronaut.http.server.exceptions.InternalServerException;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.servlet.engine.server.AbstractServletServer;
import io.undertow.Undertow;
import jakarta.inject.Singleton;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.stream.Collectors;

@Singleton
public class UndertowServer
extends AbstractServletServer<Undertow> {
    private Map<String, Undertow.ListenerInfo> listenersByProtocol;

    public UndertowServer(ApplicationContext applicationContext, ApplicationConfiguration applicationConfiguration, Undertow undertow) {
        super(applicationContext, applicationConfiguration, (Object)undertow);
    }

    protected void startServer() throws Exception {
        Undertow server = (Undertow)this.getServer();
        server.start();
        this.listenersByProtocol = server.getListenerInfo().stream().collect(Collectors.toMap(Undertow.ListenerInfo::getProtcol, listenerInfo -> listenerInfo));
    }

    protected void stopServer() throws Exception {
        ((Undertow)this.getServer()).stop();
    }

    public int getPort() {
        Undertow.ListenerInfo https = this.listenersByProtocol.get("https");
        if (https != null) {
            return ((InetSocketAddress)https.getAddress()).getPort();
        }
        Undertow.ListenerInfo http = this.listenersByProtocol.get("http");
        if (http != null) {
            return ((InetSocketAddress)http.getAddress()).getPort();
        }
        return -1;
    }

    public String getHost() {
        Undertow.ListenerInfo https = this.listenersByProtocol.get("https");
        if (https != null) {
            return ((InetSocketAddress)https.getAddress()).getHostName();
        }
        Undertow.ListenerInfo http = this.listenersByProtocol.get("http");
        if (http != null) {
            return ((InetSocketAddress)http.getAddress()).getHostName();
        }
        return "localhost";
    }

    public String getScheme() {
        Undertow.ListenerInfo https = this.listenersByProtocol.get("https");
        if (https != null) {
            return https.getProtcol();
        }
        return "http";
    }

    public URL getURL() {
        try {
            return this.getURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new InternalServerException(e.getMessage(), (Throwable)e);
        }
    }

    public URI getURI() {
        try {
            return new URI(this.getScheme(), null, this.getHost(), this.getPort(), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new InternalServerException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isRunning() {
        return ((Undertow)this.getServer()).getXnio() != null;
    }
}

