/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.undertow;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.core.io.socket.SocketUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.exceptions.ServerStartupException;
import io.micronaut.http.ssl.SslConfiguration;
import io.micronaut.servlet.engine.DefaultMicronautServlet;
import io.micronaut.servlet.engine.MicronautServletConfiguration;
import io.micronaut.servlet.engine.server.ServletServerFactory;
import io.micronaut.servlet.engine.server.ServletStaticResourceConfiguration;
import io.micronaut.servlet.undertow.UndertowConfiguration;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.api.ServletInfo;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.xnio.Option;
import org.xnio.Options;

@Factory
public class UndertowFactory
extends ServletServerFactory {
    private final UndertowConfiguration configuration;

    public UndertowFactory(ResourceResolver resourceResolver, UndertowConfiguration configuration, SslConfiguration sslConfiguration, ApplicationContext applicationContext, List<ServletStaticResourceConfiguration> staticResourceConfigurations) {
        super(resourceResolver, (HttpServerConfiguration)configuration, sslConfiguration, applicationContext, staticResourceConfigurations);
        this.configuration = configuration;
    }

    @Singleton
    @Primary
    protected Undertow.Builder undertowBuilder(DeploymentInfo deploymentInfo, MicronautServletConfiguration servletConfiguration) {
        PathHandler path;
        Undertow.Builder builder = this.configuration.getUndertowBuilder();
        int port = this.getConfiguredPort();
        String host = this.getConfiguredHost();
        builder.addHttpListener(port, host);
        String cp = this.getContextPath();
        DeploymentManager deploymentManager = Servlets.defaultContainer().addDeployment(deploymentInfo);
        deploymentManager.deploy();
        try {
            path = Handlers.path((HttpHandler)Handlers.redirect((String)cp)).addPrefixPath(cp, deploymentManager.start());
        }
        catch (ServletException e) {
            throw new ServerStartupException("Error starting Undertow server: " + e.getMessage(), (Throwable)e);
        }
        builder.setHandler((HttpHandler)path);
        SslConfiguration sslConfiguration = this.getSslConfiguration();
        if (sslConfiguration.isEnabled()) {
            int sslPort = sslConfiguration.getPort();
            if (sslPort == 8443 && this.getEnvironment().getActiveNames().contains("test")) {
                sslPort = SocketUtils.findAvailableTcpPort();
            }
            int finalSslPort = sslPort;
            this.build(sslConfiguration).ifPresent(sslContext -> builder.addHttpsListener(finalSslPort, host, sslContext));
        }
        Map<String, String> serverOptions = this.configuration.getServerOptions();
        serverOptions.forEach((key, value) -> {
            Object opt = ReflectionUtils.findDeclaredField(UndertowOptions.class, (String)key).map(field -> {
                field.setAccessible(true);
                try {
                    return field.get(UndertowOptions.class);
                }
                catch (IllegalAccessException e) {
                    return null;
                }
            }).orElse(null);
            if (opt instanceof Option) {
                builder.setServerOption((Option)opt, value);
            } else {
                builder.setServerOption(Option.simple(UndertowOptions.class, (String)key, String.class), value);
            }
        });
        Map<String, String> workerOptions = this.configuration.getWorkerOptions();
        workerOptions.forEach((key, value) -> {
            Object opt = this.getOptionValue((String)key);
            if (opt instanceof Option) {
                builder.setWorkerOption((Option)opt, value);
            } else {
                builder.setWorkerOption(Option.simple(Options.class, (String)key, String.class), value);
            }
        });
        Map<String, String> socketOptions = this.configuration.getSocketOptions();
        socketOptions.forEach((key, value) -> {
            Object opt = this.getOptionValue((String)key);
            if (opt instanceof Option) {
                builder.setSocketOption((Option)opt, value);
            } else {
                builder.setSocketOption(Option.simple(Options.class, (String)key, String.class), value);
            }
        });
        return builder;
    }

    private Object getOptionValue(String key) {
        return ReflectionUtils.findDeclaredField(Options.class, (String)key).map(field -> {
            field.setAccessible(true);
            try {
                return field.get(Options.class);
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }).orElse(null);
    }

    @Singleton
    @Primary
    protected Undertow undertowServer(Undertow.Builder builder) {
        return builder.build();
    }

    @Singleton
    @Primary
    protected DeploymentInfo deploymentInfo(MicronautServletConfiguration servletConfiguration) {
        String cp = this.getContextPath();
        ServletInfo servletInfo = Servlets.servlet((String)servletConfiguration.getName(), DefaultMicronautServlet.class, () -> new InstanceHandle<Servlet>(){
            private DefaultMicronautServlet instance;

            public Servlet getInstance() {
                this.instance = new DefaultMicronautServlet(UndertowFactory.this.getApplicationContext());
                return this.instance;
            }

            public void release() {
                if (this.instance != null) {
                    this.instance.destroy();
                }
            }
        });
        servletInfo.setAsyncSupported(true);
        servletInfo.addMapping(servletConfiguration.getMapping());
        this.getStaticResourceConfigurations().forEach(config -> servletInfo.addMapping(config.getMapping()));
        DeploymentInfo deploymentInfo = Servlets.deployment().setDeploymentName(servletConfiguration.getName()).setClassLoader(this.getEnvironment().getClassLoader()).setContextPath(cp).addServlet(servletInfo);
        servletConfiguration.getMultipartConfigElement().ifPresent(arg_0 -> ((DeploymentInfo)deploymentInfo).setDefaultMultipartConfig(arg_0));
        return deploymentInfo;
    }
}

