/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.engine;

import io.micronaut.http.MediaType;
import io.micronaut.http.multipart.CompletedFileUpload;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.Part;

public final class ServletCompletedFileUpload
implements CompletedFileUpload {
    private final Part part;

    public ServletCompletedFileUpload(Part part) {
        this.part = Objects.requireNonNull(part, "Part cannot be null");
    }

    public Optional<MediaType> getContentType() {
        return Optional.ofNullable(this.part.getContentType()).map(MediaType::new);
    }

    public String getName() {
        return this.part.getName();
    }

    public String getFilename() {
        return this.part.getSubmittedFileName();
    }

    public long getSize() {
        return this.part.getSize();
    }

    public long getDefinedSize() {
        return this.part.getSize();
    }

    public boolean isComplete() {
        return true;
    }

    public InputStream getInputStream() throws IOException {
        return this.part.getInputStream();
    }

    public byte[] getBytes() throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        InputStream inputStream = this.getInputStream();
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        return buffer.toByteArray();
    }

    public ByteBuffer getByteBuffer() throws IOException {
        return ByteBuffer.wrap(this.getBytes());
    }
}

