/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.engine.bind;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Part;
import io.micronaut.http.bind.DefaultRequestBinderRegistry;
import io.micronaut.http.bind.binders.RequestArgumentBinder;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.multipart.CompletedPart;
import io.micronaut.jackson.codec.JsonMediaTypeCodec;
import io.micronaut.jackson.parser.JacksonProcessor;
import io.micronaut.servlet.engine.bind.CompletedPartRequestArgumentBinder;
import io.micronaut.servlet.engine.bind.ServletPartBinder;
import io.micronaut.servlet.engine.bind.ServletRequestBinder;
import io.micronaut.servlet.engine.bind.ServletResponseBinder;
import io.micronaut.servlet.http.ServletBinderRegistry;
import io.micronaut.servlet.http.ServletBodyBinder;
import io.micronaut.servlet.http.StreamedServletMessage;
import io.reactivex.Flowable;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

@Singleton
@Replaces(value=DefaultRequestBinderRegistry.class)
@Internal
class DefaultServletBinderRegistry
extends ServletBinderRegistry {
    public static final Argument<byte[]> BYTE_ARRAY = Argument.of(byte[].class);

    public DefaultServletBinderRegistry(MediaTypeCodecRegistry mediaTypeCodecRegistry, ConversionService conversionService, List<RequestArgumentBinder> binders) {
        super(mediaTypeCodecRegistry, conversionService, binders);
        this.byType.put(HttpServletRequest.class, new ServletRequestBinder());
        this.byType.put(HttpServletResponse.class, new ServletResponseBinder());
        this.byType.put(CompletedPart.class, new CompletedPartRequestArgumentBinder());
        this.byAnnotation.put(Part.class, new ServletPartBinder(mediaTypeCodecRegistry));
    }

    protected ServletBodyBinder newServletBodyBinder(MediaTypeCodecRegistry mediaTypeCodecRegistry, ConversionService conversionService) {
        return new DefaultServletBodyBinder(conversionService, mediaTypeCodecRegistry);
    }

    private static class DefaultServletBodyBinder
    extends ServletBodyBinder {
        private final MediaTypeCodecRegistry mediaTypeCodecRegistry;

        public DefaultServletBodyBinder(ConversionService conversionService, MediaTypeCodecRegistry mediaTypeCodecRegistry) {
            super(conversionService, mediaTypeCodecRegistry);
            this.mediaTypeCodecRegistry = mediaTypeCodecRegistry;
        }

        public ArgumentBinder.BindingResult bind(ArgumentConversionContext context, HttpRequest source) {
            Argument argument = context.getArgument();
            Class type = argument.getType();
            if (CompletionStage.class.isAssignableFrom(type)) {
                StreamedServletMessage servletHttpRequest = (StreamedServletMessage)source;
                CompletableFuture future = new CompletableFuture();
                Argument<byte[]> typeArgument = argument.getFirstTypeVariable().orElse(BYTE_ARRAY);
                Class javaArgument = typeArgument.getType();
                Charset characterEncoding = servletHttpRequest.getCharacterEncoding();
                if (CharSequence.class.isAssignableFrom(javaArgument)) {
                    Flowable.fromPublisher((Publisher)servletHttpRequest).collect(StringBuilder::new, (stringBuilder, bytes) -> stringBuilder.append(new String((byte[])bytes, characterEncoding))).subscribe((stringBuilder, throwable) -> {
                        if (throwable != null) {
                            future.completeExceptionally((Throwable)throwable);
                        } else {
                            future.complete(stringBuilder.toString());
                        }
                    });
                } else if (BYTE_ARRAY.getType().isAssignableFrom(type)) {
                    Flowable.fromPublisher((Publisher)servletHttpRequest).collect(ByteArrayOutputStream::new, OutputStream::write).subscribe((stream, throwable) -> {
                        if (throwable != null) {
                            future.completeExceptionally((Throwable)throwable);
                        } else {
                            future.complete(stream.toByteArray());
                        }
                    });
                } else {
                    MediaType mediaType = servletHttpRequest.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
                    MediaTypeCodec codec = this.mediaTypeCodecRegistry.findCodec(mediaType, javaArgument).orElse(null);
                    if (codec instanceof JsonMediaTypeCodec) {
                        JsonMediaTypeCodec jsonCodec = (JsonMediaTypeCodec)codec;
                        ObjectMapper objectMapper = jsonCodec.getObjectMapper();
                        JacksonProcessor jacksonProcessor = new JacksonProcessor(objectMapper.getFactory(), false, objectMapper.getDeserializationConfig());
                        Flowable.fromPublisher((Publisher)servletHttpRequest).subscribe((Subscriber)jacksonProcessor);
                        Flowable.fromPublisher((Publisher)jacksonProcessor).firstElement().subscribe(jsonNode -> {
                            try {
                                future.complete(jsonCodec.decode(typeArgument, jsonNode));
                            }
                            catch (Exception e) {
                                future.completeExceptionally(e);
                            }
                        }, future::completeExceptionally);
                    } else {
                        return super.bind(context, source);
                    }
                }
                return () -> Optional.of(future);
            }
            if (CompletedPart.class.isAssignableFrom(type)) {
                return new CompletedPartRequestArgumentBinder().bind((ArgumentConversionContext<CompletedPart>)context, source);
            }
            if (Publishers.isConvertibleToPublisher((Class)type)) {
                Argument<byte[]> typeArgument = argument.getFirstTypeVariable().orElse(BYTE_ARRAY);
                Class javaArgument = typeArgument.getType();
                final StreamedServletMessage servletHttpRequest = (StreamedServletMessage)source;
                Charset characterEncoding = servletHttpRequest.getCharacterEncoding();
                if (CharSequence.class.isAssignableFrom(javaArgument)) {
                    Flowable stringFlowable = Flowable.fromPublisher((Publisher)servletHttpRequest).map(bytes -> new String((byte[])bytes, characterEncoding));
                    if (type.isInstance(stringFlowable)) {
                        return () -> Optional.of(stringFlowable);
                    }
                    Object converted = Publishers.convertPublisher((Object)stringFlowable, (Class)type);
                    return () -> Optional.of(converted);
                }
                if (byte[].class.isAssignableFrom(javaArgument)) {
                    return () -> Optional.of(Flowable.fromPublisher((Publisher)servletHttpRequest));
                }
                MediaType mediaType = servletHttpRequest.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
                MediaTypeCodec codec = this.mediaTypeCodecRegistry.findCodec(mediaType, javaArgument).orElse(null);
                if (codec instanceof JsonMediaTypeCodec) {
                    JsonMediaTypeCodec jsonCodec = (JsonMediaTypeCodec)codec;
                    ObjectMapper objectMapper = jsonCodec.getObjectMapper();
                    JacksonProcessor jacksonProcessor = new JacksonProcessor(objectMapper.getFactory(), false, objectMapper.getDeserializationConfig()){

                        public void subscribe(Subscriber<? super JsonNode> downstreamSubscriber) {
                            servletHttpRequest.subscribe((Subscriber)this);
                            super.subscribe(downstreamSubscriber);
                        }
                    };
                    Flowable jsonDecoder = Flowable.fromPublisher((Publisher)jacksonProcessor).map(jsonNode -> jsonCodec.decode(typeArgument, jsonNode));
                    Object converted = Publishers.convertPublisher((Object)jsonDecoder, (Class)type);
                    return () -> Optional.of(converted);
                }
                return super.bind(context, source);
            }
            return super.bind(context, source);
        }
    }
}

