/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.engine.initializer;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.servlet.engine.DefaultMicronautServlet;
import io.micronaut.servlet.engine.MicronautServletConfiguration;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletSecurityElement;

public class MicronautServletInitializer
implements ServletContainerInitializer {
    public void onStartup(Set<Class<?>> c, ServletContext ctx) {
        ApplicationContext applicationContext = this.buildApplicationContext(ctx).build().start();
        MicronautServletConfiguration configuration = (MicronautServletConfiguration)applicationContext.getBean(MicronautServletConfiguration.class);
        ServletRegistration.Dynamic registration = ctx.addServlet(configuration.getName(), (Servlet)new DefaultMicronautServlet(applicationContext));
        configuration.getMultipartConfigElement().ifPresent(arg_0 -> ((ServletRegistration.Dynamic)registration).setMultipartConfig(arg_0));
        applicationContext.findBean(ServletSecurityElement.class).ifPresent(arg_0 -> ((ServletRegistration.Dynamic)registration).setServletSecurity(arg_0));
        registration.setLoadOnStartup(1);
        registration.setAsyncSupported(true);
        registration.addMapping(new String[]{configuration.getMapping()});
    }

    protected ApplicationContextBuilder buildApplicationContext(ServletContext ctx) {
        return ApplicationContext.build().classLoader(ctx.getClassLoader()).singletons(new Object[]{ctx});
    }
}

