/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.engine;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.servlet.engine.DefaultServletHttpHandler;
import java.util.Objects;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TypeHint(value={DefaultMicronautServlet.class})
public class DefaultMicronautServlet
extends HttpServlet {
    public static final String NAME = "micronaut";
    public static final String CONTEXT_ATTRIBUTE = "io.micronaut.servlet.APPLICATION_CONTEXT";
    private ApplicationContext applicationContext;
    private DefaultServletHttpHandler handler;

    public DefaultMicronautServlet(ApplicationContext applicationContext) {
        this.applicationContext = Objects.requireNonNull(applicationContext, "The application context cannot be null");
    }

    public DefaultMicronautServlet() {
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) {
        if (this.handler != null) {
            this.handler.service(req, resp);
        }
    }

    public void destroy() {
        if (this.applicationContext != null && this.applicationContext.isRunning()) {
            this.applicationContext.stop();
            this.applicationContext = null;
        }
    }

    public void init() {
        Object v;
        ServletContext servletContext = this.getServletContext();
        if (servletContext != null && (v = servletContext.getAttribute(CONTEXT_ATTRIBUTE)) instanceof ApplicationContext) {
            this.applicationContext = (ApplicationContext)v;
        }
        if (this.applicationContext == null) {
            ApplicationContextBuilder builder = Objects.requireNonNull(this.newApplicationContextBuilder(), "builder cannot be null");
            this.applicationContext = Objects.requireNonNull(this.buildApplicationContext(builder), "Context cannot be null");
        }
        if (!this.applicationContext.isRunning()) {
            this.applicationContext.start();
        }
        if (servletContext != null) {
            servletContext.setAttribute(CONTEXT_ATTRIBUTE, (Object)this.applicationContext);
        }
        this.handler = (DefaultServletHttpHandler)((Object)this.applicationContext.getBean(DefaultServletHttpHandler.class));
    }

    protected ApplicationContext buildApplicationContext(ApplicationContextBuilder builder) {
        return builder.build();
    }

    protected ApplicationContextBuilder newApplicationContextBuilder() {
        return ApplicationContext.build();
    }
}

