/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.engine;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.server.exceptions.InternalServerException;
import io.micronaut.servlet.engine.DefaultServletHttpRequest;
import io.micronaut.servlet.engine.ServletCookieAdapter;
import io.micronaut.servlet.http.ServletHttpResponse;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Internal
public class DefaultServletHttpResponse<B>
implements ServletHttpResponse<HttpServletResponse, B> {
    private static final byte[] EMPTY_ARRAY = "[]".getBytes();
    private final HttpServletResponse delegate;
    private final DefaultServletHttpRequest<?> request;
    private final ServletResponseHeaders headers;
    private B body;

    protected DefaultServletHttpResponse(DefaultServletHttpRequest request, HttpServletResponse delegate) {
        this.delegate = delegate;
        this.request = request;
        this.headers = new ServletResponseHeaders();
    }

    public Publisher<MutableHttpResponse<?>> stream(Publisher<?> dataPublisher) {
        MediaType contentType = this.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
        final MediaTypeCodec codec = this.request.getCodecRegistry().findCodec(contentType).orElse(null);
        final boolean isJson = contentType.getSubtype().equals("json");
        return Flowable.create(emitter -> dataPublisher.subscribe((Subscriber)new Subscriber<Object>(){
            ServletOutputStream outputStream;
            Subscription subscription;
            final AtomicBoolean finished = new AtomicBoolean();
            boolean first = true;
            boolean raw = false;

            public void onSubscribe(final Subscription s) {
                block2: {
                    this.subscription = s;
                    DefaultServletHttpResponse.this.delegate.setHeader("Transfer-Encoding", "chunked");
                    try {
                        this.outputStream = DefaultServletHttpResponse.this.delegate.getOutputStream();
                        this.outputStream.setWriteListener(new WriteListener(){

                            public void onWritePossible() {
                                s.request(1L);
                            }

                            public void onError(Throwable t) {
                                emitter.onError(t);
                            }
                        });
                    }
                    catch (IOException e) {
                        if (!this.finished.compareAndSet(false, true)) break block2;
                        emitter.onError((Throwable)e);
                        this.subscription.cancel();
                    }
                }
            }

            public void onNext(Object o) {
                block19: {
                    try {
                        if (this.outputStream.isReady() && !this.finished.get()) {
                            if (o instanceof byte[]) {
                                this.raw = true;
                                this.outputStream.write((byte[])o);
                                this.flushIfReady();
                            } else if (o instanceof ByteBuffer) {
                                ByteBuffer buf = (ByteBuffer)o;
                                try {
                                    this.raw = true;
                                    this.outputStream.write(buf.toByteArray());
                                    this.flushIfReady();
                                }
                                finally {
                                    if (buf instanceof ReferenceCounted) {
                                        ((ReferenceCounted)buf).release();
                                    }
                                }
                            } else if (codec != null) {
                                if (isJson) {
                                    if (this.first) {
                                        this.outputStream.write(91);
                                        this.first = false;
                                    } else {
                                        this.outputStream.write(44);
                                    }
                                }
                                if (this.outputStream.isReady()) {
                                    if (o instanceof CharSequence) {
                                        this.outputStream.write(o.toString().getBytes(DefaultServletHttpResponse.this.getCharacterEncoding()));
                                    } else {
                                        byte[] bytes = codec.encode(o);
                                        this.outputStream.write(bytes);
                                    }
                                    this.flushIfReady();
                                }
                            }
                            if (this.outputStream.isReady()) {
                                this.subscription.request(1L);
                            }
                        }
                    }
                    catch (IOException e) {
                        if (!this.finished.compareAndSet(false, true)) break block19;
                        this.onError(e);
                        this.subscription.cancel();
                    }
                }
            }

            private void flushIfReady() throws IOException {
                if (this.outputStream.isReady()) {
                    this.outputStream.flush();
                }
            }

            public void onError(Throwable t) {
                if (this.finished.compareAndSet(false, true)) {
                    emitter.onError(t);
                    this.subscription.cancel();
                }
            }

            public void onComplete() {
                if (this.finished.compareAndSet(false, true)) {
                    try {
                        if (!this.raw && isJson && this.outputStream.isReady()) {
                            if (this.first) {
                                this.outputStream.write(EMPTY_ARRAY);
                            } else {
                                this.outputStream.write(93);
                            }
                            this.flushIfReady();
                        }
                        emitter.onNext((Object)DefaultServletHttpResponse.this);
                        emitter.onComplete();
                    }
                    catch (IOException e) {
                        emitter.onError((Throwable)e);
                    }
                }
            }
        }), (BackpressureStrategy)BackpressureStrategy.ERROR);
    }

    public MutableHttpResponse<B> contentType(CharSequence contentType) {
        this.delegate.setContentType(Objects.requireNonNull(contentType, "Content type cannot be null").toString());
        return this;
    }

    public MutableHttpResponse<B> contentType(MediaType mediaType) {
        this.delegate.setContentType(Objects.requireNonNull(mediaType, "Content type cannot be null").toString());
        return this;
    }

    public MutableHttpResponse<B> contentLength(long length) {
        this.delegate.setContentLengthLong(length);
        return this;
    }

    public MutableHttpResponse<B> locale(Locale locale) {
        Objects.requireNonNull(locale, "Locale cannot be null");
        this.delegate.setLocale(locale);
        return this;
    }

    public MutableHttpResponse<B> header(CharSequence name, CharSequence value) {
        String headerName = Objects.requireNonNull(name, "Header name cannot be null").toString();
        String headerValue = Objects.requireNonNull(value, "Header value cannot be null").toString();
        this.delegate.addHeader(headerName, headerValue);
        return this;
    }

    public MutableHttpResponse<B> status(int status) {
        this.delegate.setStatus(status);
        return this;
    }

    public MutableHttpResponse<B> status(int status, CharSequence message) {
        if (message == null) {
            return this.status(status);
        }
        this.delegate.setStatus(status);
        return this;
    }

    public MutableHttpResponse<B> status(HttpStatus status) {
        return this.status(Objects.requireNonNull(status, "status cannot be null").getCode());
    }

    public HttpServletResponse getNativeResponse() {
        return this.delegate;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.delegate.getOutputStream();
    }

    public BufferedWriter getWriter() throws IOException {
        return new BufferedWriter(this.delegate.getWriter());
    }

    public MutableHttpResponse<B> cookie(io.micronaut.http.cookie.Cookie cookie) {
        if (cookie instanceof ServletCookieAdapter) {
            this.delegate.addCookie(((ServletCookieAdapter)cookie).getCookie());
        } else {
            String path;
            Cookie c = new Cookie(cookie.getName(), cookie.getValue());
            String domain = cookie.getDomain();
            if (domain != null) {
                c.setDomain(domain);
            }
            if ((path = cookie.getPath()) != null) {
                c.setPath(path);
            }
            c.setSecure(cookie.isSecure());
            c.setHttpOnly(cookie.isHttpOnly());
            c.setMaxAge((int)cookie.getMaxAge());
            this.delegate.addCookie(c);
        }
        return this;
    }

    public MutableHttpHeaders getHeaders() {
        return this.headers;
    }

    @Nonnull
    public MutableConvertibleValues<Object> getAttributes() {
        return this.request;
    }

    @Nonnull
    public Optional<B> getBody() {
        return Optional.ofNullable(this.body);
    }

    public <T> MutableHttpResponse<T> body(@Nullable T body) {
        if (body != null) {
            this.getContentType().orElseGet(() -> {
                Object[] v;
                Produces ann = body.getClass().getAnnotation(Produces.class);
                if (ann != null && ArrayUtils.isNotEmpty((Object[])(v = ann.value()))) {
                    MediaType mediaType = new MediaType((String)v[0]);
                    this.contentType(mediaType);
                    return mediaType;
                }
                return null;
            });
        }
        this.body = body;
        return this;
    }

    public MutableHttpResponse<B> status(HttpStatus status, CharSequence message) {
        Objects.requireNonNull(status, "Status cannot be null");
        if (message != null) {
            try {
                this.delegate.sendError(status.getCode(), message.toString());
            }
            catch (IOException e) {
                throw new InternalServerException("Error sending error code: " + e.getMessage(), (Throwable)e);
            }
        } else {
            this.delegate.setStatus(status.getCode());
        }
        return this;
    }

    public HttpStatus getStatus() {
        return HttpStatus.valueOf((int)this.delegate.getStatus());
    }

    private class ServletResponseHeaders
    implements MutableHttpHeaders {
        private ServletResponseHeaders() {
        }

        public MutableHttpHeaders add(CharSequence header, CharSequence value) {
            String headerName = Objects.requireNonNull(header, "Header name cannot be null").toString();
            String headerValue = Objects.requireNonNull(value, "Header value cannot be null").toString();
            DefaultServletHttpResponse.this.delegate.setHeader(headerName, headerValue);
            return this;
        }

        public MutableHttpHeaders remove(CharSequence header) {
            String headerName = Objects.requireNonNull(header, "Header name cannot be null").toString();
            if (DefaultServletHttpResponse.this.delegate.containsHeader(headerName)) {
                DefaultServletHttpResponse.this.delegate.setHeader(headerName, "");
            }
            return this;
        }

        public List<String> getAll(CharSequence name) {
            Collection values = DefaultServletHttpResponse.this.delegate.getHeaders(Objects.requireNonNull(name, "Header name cannot be null").toString());
            if (values instanceof List) {
                return (List)values;
            }
            return new ArrayList<String>(values);
        }

        @javax.annotation.Nullable
        public String get(CharSequence name) {
            return DefaultServletHttpResponse.this.delegate.getHeader(Objects.requireNonNull(name, "Header name cannot be null").toString());
        }

        public Set<String> names() {
            Collection headerNames = DefaultServletHttpResponse.this.delegate.getHeaderNames();
            if (headerNames instanceof Set) {
                return (Set)headerNames;
            }
            return new HashSet<String>(headerNames);
        }

        public Collection<List<String>> values() {
            return this.names().stream().map(this::getAll).collect(Collectors.toList());
        }

        public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
            String v = this.get(name);
            if (v != null) {
                return ConversionService.SHARED.convert((Object)v, conversionContext);
            }
            return Optional.empty();
        }
    }
}

