/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.engine.bind;

import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.io.IOUtils;
import io.micronaut.core.io.Readable;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.bind.binders.AnnotatedRequestArgumentBinder;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.http.multipart.CompletedFileUpload;
import io.micronaut.http.server.exceptions.InternalServerException;
import io.micronaut.servlet.engine.ServletCompletedFileUpload;
import io.micronaut.servlet.http.ServletExchange;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;

public class ServletPartBinder<T>
implements AnnotatedRequestArgumentBinder<io.micronaut.http.annotation.Part, T> {
    private final MediaTypeCodecRegistry codecRegistry;

    ServletPartBinder(MediaTypeCodecRegistry codecRegistry) {
        this.codecRegistry = codecRegistry;
    }

    public Class<io.micronaut.http.annotation.Part> getAnnotationType() {
        return io.micronaut.http.annotation.Part.class;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArgumentBinder.BindingResult<T> bind(ArgumentConversionContext<T> context, HttpRequest<?> source) {
        Part part;
        if (!(source instanceof ServletExchange)) return ArgumentBinder.BindingResult.UNSATISFIED;
        ServletExchange exchange = (ServletExchange)source;
        HttpServletRequest nativeRequest = (HttpServletRequest)exchange.getRequest().getNativeRequest();
        Argument argument = context.getArgument();
        String partName = context.getAnnotationMetadata().stringValue(io.micronaut.http.annotation.Part.class).orElse(argument.getName());
        try {
            part = nativeRequest.getPart(partName);
        }
        catch (IOException | ServletException e) {
            throw new InternalServerException("Error reading part [" + partName + "]: " + e.getMessage(), e);
        }
        if (part == null) return ArgumentBinder.BindingResult.UNSATISFIED;
        Class type = argument.getType();
        if (Part.class.isAssignableFrom(type)) {
            return () -> Optional.of(part);
        }
        if (Readable.class.isAssignableFrom(type)) {
            return () -> Optional.of(new Readable(){

                @Nonnull
                public String getName() {
                    return part.getName();
                }

                public Reader asReader() throws IOException {
                    Charset charset = Optional.ofNullable(part.getContentType()).map(MediaType::new).flatMap(MediaType::getCharset).orElse(StandardCharsets.UTF_8);
                    return new InputStreamReader(this.asInputStream(), charset);
                }

                @Nonnull
                public InputStream asInputStream() throws IOException {
                    return part.getInputStream();
                }

                public boolean exists() {
                    return true;
                }
            });
        }
        if (String.class.isAssignableFrom(type)) {
            try (BufferedReader reader = this.newReader(part);){
                String content = IOUtils.readText((BufferedReader)reader);
                ArgumentBinder.BindingResult bindingResult = () -> Optional.of(content);
                return bindingResult;
            }
            catch (IOException e) {
                throw new HttpStatusException(HttpStatus.BAD_REQUEST, "Unable to read part [" + partName + "]: " + e.getMessage());
            }
        }
        if (byte[].class.isAssignableFrom(type)) {
            try (InputStream is = part.getInputStream();){
                int nRead;
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] data = new byte[16384];
                while ((nRead = is.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
                byte[] content = buffer.toByteArray();
                ArgumentBinder.BindingResult bindingResult = () -> Optional.of(content);
                return bindingResult;
            }
            catch (IOException e) {
                throw new HttpStatusException(HttpStatus.BAD_REQUEST, "Unable to read part [" + partName + "]: " + e.getMessage());
            }
        }
        if (CompletedFileUpload.class.isAssignableFrom(type)) {
            return () -> Optional.of(new ServletCompletedFileUpload(part));
        }
        MediaType contentType = Optional.ofNullable(part.getContentType()).map(MediaType::new).orElse(null);
        if (contentType == null) return ArgumentBinder.BindingResult.UNSATISFIED;
        MediaTypeCodec codec = this.codecRegistry.findCodec(contentType, type).orElse(null);
        if (codec == null) return ArgumentBinder.BindingResult.UNSATISFIED;
        try (InputStream inputStream = part.getInputStream();){
            Object content = codec.decode(argument, inputStream);
            ArgumentBinder.BindingResult bindingResult = () -> Optional.of(content);
            return bindingResult;
        }
        catch (IOException e) {
            throw new HttpStatusException(HttpStatus.BAD_REQUEST, "Unable to read part [" + partName + "]: " + e.getMessage());
        }
    }

    private BufferedReader newReader(Part part) throws IOException {
        Charset charset = Optional.ofNullable(part.getContentType()).map(MediaType::new).flatMap(MediaType::getCharset).orElse(StandardCharsets.UTF_8);
        InputStreamReader inputStreamReader = new InputStreamReader(part.getInputStream(), charset);
        return new BufferedReader(inputStreamReader);
    }
}

