/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.engine;

import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.Cookies;
import io.micronaut.servlet.engine.ServletCookieAdapter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class DefaultServletCookies
implements Cookies {
    private static final javax.servlet.http.Cookie[] EMPTY_COOKIES = new javax.servlet.http.Cookie[0];
    private final javax.servlet.http.Cookie[] cookies;

    public DefaultServletCookies(javax.servlet.http.Cookie[] cookies) {
        this.cookies = cookies == null ? EMPTY_COOKIES : cookies;
    }

    public Set<Cookie> getAll() {
        return Arrays.stream(this.cookies).map(ServletCookieAdapter::new).collect(Collectors.toSet());
    }

    public Optional<Cookie> findCookie(CharSequence name) {
        String cookieName = Objects.requireNonNull(name, "Cookie name cannot be null").toString();
        for (int i = 0; i < this.cookies.length; ++i) {
            javax.servlet.http.Cookie cookie = this.cookies[i];
            if (!cookie.getName().equals(cookieName)) continue;
            return Optional.of(new ServletCookieAdapter(cookie));
        }
        return Optional.empty();
    }

    public Collection<Cookie> values() {
        return this.getAll();
    }

    public <T> Optional<T> get(CharSequence name, Class<T> requiredType) {
        if (requiredType == Cookie.class || requiredType == Object.class) {
            return this.findCookie(name);
        }
        return this.findCookie(name).flatMap(cookie -> ConversionService.SHARED.convert((Object)cookie.getValue(), requiredType));
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        return this.findCookie(name).flatMap(cookie -> ConversionService.SHARED.convert((Object)cookie.getValue(), conversionContext));
    }
}

