/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.engine;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.io.IOUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.TypeInformation;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpParameters;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.cookie.Cookies;
import io.micronaut.servlet.engine.DefaultServletCookies;
import io.micronaut.servlet.engine.DefaultServletHttpResponse;
import io.micronaut.servlet.http.ServletExchange;
import io.micronaut.servlet.http.ServletHttpRequest;
import io.micronaut.servlet.http.ServletHttpResponse;
import io.micronaut.servlet.http.StreamedServletMessage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.AsyncContext;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Internal
public class DefaultServletHttpRequest<B>
implements ServletHttpRequest<HttpServletRequest, B>,
MutableConvertibleValues<Object>,
ServletExchange<HttpServletRequest, HttpServletResponse>,
StreamedServletMessage<B, byte[]> {
    private final HttpServletRequest delegate;
    private final URI uri;
    private final HttpMethod method;
    private final ServletRequestHeaders headers;
    private final ServletParameters parameters;
    private final DefaultServletHttpResponse<Object> response;
    private final MediaTypeCodecRegistry codecRegistry;
    private DefaultServletCookies cookies;
    private Object body;
    private Scheduler scheduler;

    protected DefaultServletHttpRequest(HttpServletRequest delegate, HttpServletResponse response, MediaTypeCodecRegistry codecRegistry) {
        HttpMethod method;
        String queryString;
        this.delegate = delegate;
        this.codecRegistry = codecRegistry;
        String contextPath = delegate.getContextPath();
        String requestURI = delegate.getRequestURI();
        if (StringUtils.isNotEmpty((CharSequence)contextPath) && requestURI.startsWith(contextPath)) {
            requestURI = requestURI.substring(contextPath.length());
        }
        if (StringUtils.isNotEmpty((CharSequence)(queryString = delegate.getQueryString()))) {
            requestURI = requestURI + "?" + queryString;
        }
        this.uri = URI.create(requestURI);
        try {
            method = HttpMethod.valueOf((String)delegate.getMethod());
        }
        catch (IllegalArgumentException e) {
            method = HttpMethod.CUSTOM;
        }
        this.method = method;
        this.headers = new ServletRequestHeaders();
        this.parameters = new ServletParameters();
        this.response = new DefaultServletHttpResponse(this, response);
    }

    public MediaTypeCodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    public boolean isAsyncSupported() {
        return this.delegate.isAsyncSupported();
    }

    public Publisher<? extends MutableHttpResponse<?>> subscribeOnExecutor(Publisher<? extends MutableHttpResponse<?>> responsePublisher) {
        if (this.scheduler == null) {
            AsyncContext asyncContext = this.delegate.startAsync();
            this.scheduler = Schedulers.fromExecutor(arg_0 -> ((AsyncContext)asyncContext).start(arg_0));
            return Flux.from(responsePublisher).subscribeOn(this.scheduler).doAfterTerminate(() -> ((AsyncContext)asyncContext).complete());
        }
        return responsePublisher;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public <T> Optional<T> getBody(@NonNull Argument<T> arg) {
        if (arg == null) return Optional.empty();
        Class type = arg.getType();
        MediaType contentType = this.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
        long contentLength = this.getContentLength();
        if (this.body == null && contentLength != 0L) {
            boolean isConvertibleValues;
            boolean bl = isConvertibleValues = ConvertibleValues.class == type;
            if (this.isFormSubmission(contentType)) {
                this.body = this.getParameters();
                if (!isConvertibleValues) return Optional.empty();
                return Optional.of(this.body);
            }
            if (CharSequence.class.isAssignableFrom(type)) {
                try (BufferedReader reader = this.delegate.getReader();){
                    String value2 = IOUtils.readText((BufferedReader)reader);
                    this.body = value2;
                    Optional<String> optional3 = Optional.ofNullable(value2);
                    return optional3;
                }
                catch (IOException e) {
                    throw new CodecException("Error decoding request body: " + e.getMessage(), (Throwable)e);
                }
            }
            MediaTypeCodec codec = this.codecRegistry.findCodec(contentType, type).orElse(null);
            if (codec == null) return Optional.empty();
            try (ServletInputStream inputStream = this.delegate.getInputStream();){
                Object value;
                if (isConvertibleValues) {
                    Map map = (Map)codec.decode(Map.class, (InputStream)inputStream);
                    this.body = ConvertibleValues.of((Map)map);
                    Optional<Object> optional2 = Optional.of(this.body);
                    return optional2;
                }
                this.body = value = codec.decode(arg, (InputStream)inputStream);
                Optional<Object> optional = Optional.ofNullable(value);
                return optional;
            }
            catch (CodecException | IOException e) {
                throw new CodecException("Error decoding request body: " + e.getMessage(), e);
            }
        }
        if (type.isInstance(this.body)) {
            return Optional.of(this.body);
        }
        if (this.body == null) return Optional.empty();
        if (this.body == this.parameters) return Optional.empty();
        Object result = ConversionService.SHARED.convertRequired(this.body, arg);
        return Optional.ofNullable(result);
    }

    @NonNull
    public Optional<Principal> getUserPrincipal() {
        return Optional.ofNullable(super.getUserPrincipal().orElse(this.delegate.getUserPrincipal()));
    }

    public boolean isSecure() {
        return this.delegate.isSecure();
    }

    @NonNull
    public Optional<MediaType> getContentType() {
        return Optional.ofNullable(this.delegate.getContentType()).map(MediaType::new);
    }

    public long getContentLength() {
        return this.delegate.getContentLength();
    }

    @NonNull
    public InetSocketAddress getRemoteAddress() {
        return new InetSocketAddress(this.delegate.getRemoteHost(), this.delegate.getRemotePort());
    }

    @NonNull
    public InetSocketAddress getServerAddress() {
        return new InetSocketAddress(this.delegate.getServerPort());
    }

    @Nullable
    public String getServerName() {
        return this.delegate.getServerName();
    }

    @NonNull
    public Optional<Locale> getLocale() {
        return Optional.ofNullable(this.delegate.getLocale());
    }

    @NonNull
    public Charset getCharacterEncoding() {
        return Optional.ofNullable(this.delegate.getCharacterEncoding()).map(Charset::forName).orElse(StandardCharsets.UTF_8);
    }

    public String getContextPath() {
        return this.delegate.getContextPath();
    }

    public InputStream getInputStream() throws IOException {
        return this.delegate.getInputStream();
    }

    public BufferedReader getReader() throws IOException {
        return this.delegate.getReader();
    }

    public HttpServletRequest getNativeRequest() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Cookies getCookies() {
        DefaultServletCookies cookies = this.cookies;
        if (cookies == null) {
            DefaultServletHttpRequest defaultServletHttpRequest = this;
            synchronized (defaultServletHttpRequest) {
                cookies = this.cookies;
                if (cookies == null) {
                    this.cookies = cookies = new DefaultServletCookies(this.delegate.getCookies());
                }
            }
        }
        return cookies;
    }

    @NonNull
    public HttpParameters getParameters() {
        return this.parameters;
    }

    @NonNull
    public HttpMethod getMethod() {
        return this.method;
    }

    @NonNull
    public String getMethodName() {
        return this.delegate.getMethod();
    }

    @NonNull
    public URI getUri() {
        return this.uri;
    }

    @NonNull
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @NonNull
    public MutableConvertibleValues<Object> getAttributes() {
        return this;
    }

    @NonNull
    public Optional<B> getBody() {
        return Optional.empty();
    }

    public MutableConvertibleValues<Object> put(CharSequence key, @Nullable Object value) {
        String name = Objects.requireNonNull(key, "Key cannot be null").toString();
        if (value == null) {
            this.delegate.removeAttribute(name);
        } else {
            this.delegate.setAttribute(name, value);
        }
        return this;
    }

    public MutableConvertibleValues<Object> remove(CharSequence key) {
        String name = Objects.requireNonNull(key, "Key cannot be null").toString();
        this.delegate.removeAttribute(name);
        return this;
    }

    public MutableConvertibleValues<Object> clear() {
        while (this.delegate.getAttributeNames().hasMoreElements()) {
            String attr = (String)this.delegate.getAttributeNames().nextElement();
            this.delegate.removeAttribute(attr);
        }
        return this;
    }

    public Set<String> names() {
        return CollectionUtils.enumerationToSet((Enumeration)this.delegate.getAttributeNames());
    }

    public Collection<Object> values() {
        return this.names().stream().map(arg_0 -> ((HttpServletRequest)this.delegate).getAttribute(arg_0)).collect(Collectors.toList());
    }

    public <T> Optional<T> get(CharSequence key, ArgumentConversionContext<T> conversionContext) {
        String name = Objects.requireNonNull(key, "Key cannot be null").toString();
        Object v = this.delegate.getAttribute(name);
        if (v != null) {
            if (conversionContext.getArgument().getType().isInstance(v)) {
                return Optional.of(v);
            }
            return ConversionService.SHARED.convert(v, conversionContext);
        }
        return Optional.empty();
    }

    public ServletHttpRequest<HttpServletRequest, ? super Object> getRequest() {
        return this;
    }

    public ServletHttpResponse<HttpServletResponse, ? super Object> getResponse() {
        return this.response;
    }

    private boolean isFormSubmission(MediaType contentType) {
        return MediaType.APPLICATION_FORM_URLENCODED_TYPE.equals((Object)contentType) || MediaType.MULTIPART_FORM_DATA_TYPE.equals((Object)contentType);
    }

    private <T> List<T> enumerationToList(Enumeration<T> enumeration) {
        ArrayList<T> set = new ArrayList<T>(10);
        while (enumeration.hasMoreElements()) {
            set.add(enumeration.nextElement());
        }
        return set;
    }

    public void subscribe(Subscriber<? super byte[]> s) {
        Flux.create(emitter -> {
            ServletInputStream inputStream;
            try {
                inputStream = this.delegate.getInputStream();
            }
            catch (IOException e) {
                emitter.error((Throwable)e);
                return;
            }
            final byte[] buffer = new byte[1024];
            inputStream.setReadListener(new ReadListener((FluxSink)emitter){
                boolean complete = false;
                final /* synthetic */ FluxSink val$emitter;
                {
                    this.val$emitter = fluxSink;
                }

                public void onDataAvailable() {
                    if (!this.complete) {
                        try {
                            do {
                                int length;
                                if ((length = inputStream.read(buffer)) == -1) {
                                    this.complete = true;
                                    this.val$emitter.complete();
                                    break;
                                }
                                if (buffer.length == length) {
                                    this.val$emitter.next((Object)buffer);
                                    continue;
                                }
                                this.val$emitter.next((Object)Arrays.copyOf(buffer, length));
                            } while (inputStream.isReady());
                        }
                        catch (IOException e) {
                            this.complete = true;
                            this.val$emitter.error((Throwable)e);
                        }
                    }
                }

                public void onAllDataRead() {
                    if (!this.complete) {
                        this.complete = true;
                        this.val$emitter.complete();
                    }
                }

                public void onError(Throwable t) {
                    if (!this.complete) {
                        this.complete = true;
                        this.val$emitter.error(t);
                    }
                }
            });
        }, (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.BUFFER).subscribe(s);
    }

    private class ServletParameters
    implements HttpParameters {
        private ServletParameters() {
        }

        public List<String> getAll(CharSequence name) {
            String[] values = DefaultServletHttpRequest.this.delegate.getParameterValues(Objects.requireNonNull(name, "Parameter name cannot be null").toString());
            return Arrays.asList(values);
        }

        @Nullable
        public String get(CharSequence name) {
            return DefaultServletHttpRequest.this.delegate.getParameter(Objects.requireNonNull(name, "Parameter name cannot be null").toString());
        }

        public Set<String> names() {
            return CollectionUtils.enumerationToSet((Enumeration)DefaultServletHttpRequest.this.delegate.getParameterNames());
        }

        public Collection<List<String>> values() {
            return this.names().stream().map(this::getAll).collect(Collectors.toList());
        }

        public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
            boolean isOptional;
            Argument argument = conversionContext.getArgument();
            Class rawType = argument.getType();
            boolean bl = isOptional = rawType == Optional.class;
            if (isOptional) {
                rawType = argument.getFirstTypeVariable().map(TypeInformation::getType).orElse(rawType);
            }
            boolean isIterable = Iterable.class.isAssignableFrom(rawType);
            String paramName = Objects.requireNonNull(name, "Parameter name should not be null").toString();
            if (isIterable) {
                Object[] parameterValues = DefaultServletHttpRequest.this.delegate.getParameterValues(paramName);
                if (ArrayUtils.isNotEmpty((Object[])parameterValues)) {
                    if (parameterValues.length == 1) {
                        return ConversionService.SHARED.convert(parameterValues[0], conversionContext);
                    }
                    if (isOptional) {
                        return ConversionService.SHARED.convert((Object)parameterValues, ConversionContext.of((Argument)argument.getFirstTypeVariable().orElse(argument)));
                    }
                    return ConversionService.SHARED.convert((Object)parameterValues, conversionContext);
                }
                return ConversionService.SHARED.convert(Collections.emptyList(), conversionContext);
            }
            String v = this.get(name);
            if (v != null) {
                if (rawType.isInstance(v)) {
                    return Optional.of(v);
                }
                return ConversionService.SHARED.convert((Object)v, conversionContext);
            }
            return Optional.empty();
        }
    }

    private class ServletRequestHeaders
    implements HttpHeaders {
        private ServletRequestHeaders() {
        }

        public List<String> getAll(CharSequence name) {
            Enumeration e = DefaultServletHttpRequest.this.delegate.getHeaders(Objects.requireNonNull(name, "Header name should not be null").toString());
            return DefaultServletHttpRequest.this.enumerationToList(e);
        }

        @Nullable
        public String get(CharSequence name) {
            return DefaultServletHttpRequest.this.delegate.getHeader(Objects.requireNonNull(name, "Header name should not be null").toString());
        }

        public Set<String> names() {
            return CollectionUtils.enumerationToSet((Enumeration)DefaultServletHttpRequest.this.delegate.getHeaderNames());
        }

        public Collection<List<String>> values() {
            return this.names().stream().map(this::getAll).collect(Collectors.toList());
        }

        public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
            String v = this.get(name);
            if (v != null) {
                return ConversionService.SHARED.convert((Object)v, conversionContext);
            }
            return Optional.empty();
        }
    }
}

