/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.engine;

import io.micronaut.context.annotation.ConfigurationInject;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.naming.Named;
import io.micronaut.http.server.HttpServerConfiguration;
import java.io.File;
import java.util.Optional;
import javax.servlet.MultipartConfigElement;

@ConfigurationProperties(value="micronaut.servlet")
public class MicronautServletConfiguration
implements Named {
    public static final String PREFIX = "micronaut.servlet";
    private final String mapping;
    private final MultipartConfigElement multipartConfigElement;
    private final String name;

    @ConfigurationInject
    public MicronautServletConfiguration(@Bindable(defaultValue="micronaut") String name, @Bindable(defaultValue="/*") String mapping, HttpServerConfiguration serverConfiguration) {
        this.mapping = mapping != null ? mapping : "/*";
        this.name = name != null ? name : "micronaut";
        HttpServerConfiguration.MultipartConfiguration multipart = serverConfiguration.getMultipart();
        this.multipartConfigElement = multipart != null && multipart.isEnabled() ? new MultipartConfigElement((String)multipart.getLocation().map(File::getAbsolutePath).orElse(null), multipart.getMaxFileSize(), serverConfiguration.getMaxRequestSize(), (int)multipart.getThreshold()) : null;
    }

    public String getMapping() {
        return this.mapping;
    }

    public Optional<MultipartConfigElement> getMultipartConfigElement() {
        return Optional.ofNullable(this.multipartConfigElement);
    }

    @NonNull
    public String getName() {
        return this.name;
    }
}

