/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.engine;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.cookie.Cookie;
import java.util.Objects;

public final class ServletCookieAdapter
implements Cookie {
    private final javax.servlet.http.Cookie cookie;

    public ServletCookieAdapter(javax.servlet.http.Cookie cookie) {
        this.cookie = cookie;
    }

    public javax.servlet.http.Cookie getCookie() {
        return this.cookie;
    }

    @NonNull
    public String getName() {
        return this.cookie.getName();
    }

    @NonNull
    public String getValue() {
        return this.cookie.getValue();
    }

    @Nullable
    public String getDomain() {
        return this.cookie.getDomain();
    }

    @Nullable
    public String getPath() {
        return this.cookie.getPath();
    }

    public boolean isHttpOnly() {
        return this.cookie.isHttpOnly();
    }

    public boolean isSecure() {
        return this.cookie.getSecure();
    }

    public long getMaxAge() {
        return this.cookie.getMaxAge();
    }

    @NonNull
    public Cookie maxAge(long maxAge) {
        this.cookie.setMaxAge((int)maxAge);
        return this;
    }

    @NonNull
    public Cookie value(@NonNull String value) {
        this.cookie.setValue(Objects.requireNonNull(value, "Value cannot be null"));
        return this;
    }

    @NonNull
    public Cookie domain(@Nullable String domain) {
        if (domain != null) {
            this.cookie.setDomain(domain);
        }
        return this;
    }

    @NonNull
    public Cookie path(@Nullable String path) {
        if (path != null) {
            this.cookie.setPath(path);
        }
        return this;
    }

    @NonNull
    public Cookie secure(boolean secure) {
        this.cookie.setSecure(secure);
        return this;
    }

    @NonNull
    public Cookie httpOnly(boolean httpOnly) {
        this.cookie.setHttpOnly(httpOnly);
        return this;
    }

    public int compareTo(Cookie o) {
        Objects.requireNonNull(o, "Cookie to compare to cannot be null");
        int v = this.getName().compareTo(o.getDomain());
        if (v != 0) {
            return v;
        }
        if (this.getPath() == null) {
            if (o.getPath() != null) {
                return -1;
            }
        } else {
            if (o.getPath() == null) {
                return 1;
            }
            v = this.getPath().compareTo(o.getPath());
            if (v != 0) {
                return v;
            }
        }
        if (this.getDomain() == null) {
            if (o.getDomain() != null) {
                return -1;
            }
        } else {
            if (o.getPath() == null) {
                return 1;
            }
            v = this.getDomain().compareToIgnoreCase(o.getDomain());
            return v;
        }
        return 0;
    }
}

