/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.engine.bind;

import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.annotation.Part;
import io.micronaut.http.bind.binders.TypedRequestArgumentBinder;
import io.micronaut.http.multipart.CompletedPart;
import io.micronaut.http.server.exceptions.InternalServerException;
import io.micronaut.servlet.engine.ServletCompletedFileUpload;
import io.micronaut.servlet.http.ServletExchange;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

class CompletedPartRequestArgumentBinder
implements TypedRequestArgumentBinder<CompletedPart> {
    CompletedPartRequestArgumentBinder() {
    }

    public ArgumentBinder.BindingResult<CompletedPart> bind(ArgumentConversionContext<CompletedPart> context, HttpRequest<?> source) {
        ServletExchange exchange = (ServletExchange)source;
        HttpServletRequest nativeRequest = (HttpServletRequest)exchange.getRequest().getNativeRequest();
        Argument argument = context.getArgument();
        String partName = context.getAnnotationMetadata().stringValue(Part.class).orElse(argument.getName());
        try {
            javax.servlet.http.Part part = nativeRequest.getPart(partName);
            if (part == null) {
                return ArgumentBinder.BindingResult.UNSATISFIED;
            }
            return () -> Optional.of(new ServletCompletedFileUpload(part));
        }
        catch (IOException | ServletException e) {
            context.reject((Exception)new InternalServerException("Error reading part [" + partName + "]: " + e.getMessage(), e));
            return ArgumentBinder.BindingResult.EMPTY;
        }
    }

    public Argument<CompletedPart> argumentType() {
        return Argument.of(CompletedPart.class);
    }
}

