/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.engine.server;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.env.Environment;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.core.io.socket.SocketUtils;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.exceptions.HttpServerException;
import io.micronaut.http.server.exceptions.ServerStartupException;
import io.micronaut.http.ssl.SslBuilder;
import io.micronaut.http.ssl.SslConfiguration;
import io.micronaut.servlet.engine.server.ServletStaticResourceConfiguration;
import java.security.SecureRandom;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public abstract class ServletServerFactory
extends SslBuilder<SSLContext> {
    private final HttpServerConfiguration serverConfiguration;
    private final SslConfiguration sslConfiguration;
    private final ApplicationContext applicationContext;
    private final List<ServletStaticResourceConfiguration> staticResourceConfigurations;

    protected ServletServerFactory(ResourceResolver resourceResolver, HttpServerConfiguration serverConfiguration, SslConfiguration sslConfiguration, ApplicationContext applicationContext, List<ServletStaticResourceConfiguration> staticResourceConfigurations) {
        super(resourceResolver);
        this.serverConfiguration = serverConfiguration;
        this.sslConfiguration = sslConfiguration;
        this.applicationContext = applicationContext;
        this.staticResourceConfigurations = staticResourceConfigurations.stream().filter(ServletStaticResourceConfiguration::isEnabled).peek(config -> {
            List<String> paths = config.getPaths();
            for (String path : paths) {
                if (!"classpath:".equals(path)) continue;
                throw new ConfigurationException("A path value of [classpath:] will allow access to class files!");
            }
        }).collect(Collectors.toList());
    }

    public List<ServletStaticResourceConfiguration> getStaticResourceConfigurations() {
        return this.staticResourceConfigurations;
    }

    public Environment getEnvironment() {
        return this.applicationContext.getEnvironment();
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    protected String getContextPath() {
        String contextPath = this.serverConfiguration.getContextPath();
        return contextPath != null ? contextPath : "/";
    }

    public HttpServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public SslConfiguration getSslConfiguration() {
        return this.sslConfiguration;
    }

    public Optional<SSLContext> build(SslConfiguration ssl) {
        return this.build(ssl, HttpVersion.HTTP_1_1);
    }

    public Optional<SSLContext> build(SslConfiguration ssl, HttpVersion httpVersion) {
        if (this.sslConfiguration.isEnabled()) {
            String protocol = (String)this.sslConfiguration.getProtocol().orElseThrow(() -> new ServerStartupException("No SSL protocol specified"));
            try {
                SSLContext sslContext = SSLContext.getInstance(protocol);
                KeyManagerFactory keyManagerFactory = this.getKeyManagerFactory(ssl);
                KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
                TrustManagerFactory trustManagerFactory = this.getTrustManagerFactory(ssl);
                TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
                sslContext.init(keyManagers, trustManagers, new SecureRandom());
                return Optional.of(sslContext);
            }
            catch (Throwable e) {
                throw new HttpServerException("HTTPS configuration error: " + e.getMessage(), e);
            }
        }
        return Optional.empty();
    }

    protected String getConfiguredHost() {
        return this.serverConfiguration.getHost().orElseGet(() -> Optional.ofNullable(System.getenv("HOST")).orElse("localhost"));
    }

    protected Integer getConfiguredPort() {
        return this.serverConfiguration.getPort().map(p -> p == -1 ? SocketUtils.findAvailableTcpPort() : p).orElseGet(() -> {
            if (this.getEnvironment().getActiveNames().contains("test")) {
                return SocketUtils.findAvailableTcpPort();
            }
            return 8080;
        });
    }
}

