/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.engine;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.TypeInformation;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.http.FullHttpRequest;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpParameters;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.cookie.Cookies;
import io.micronaut.servlet.engine.DefaultMutableServletHttpRequest;
import io.micronaut.servlet.engine.DefaultServletCookies;
import io.micronaut.servlet.engine.DefaultServletHttpResponse;
import io.micronaut.servlet.http.BodyBuilder;
import io.micronaut.servlet.http.ByteArrayByteBuffer;
import io.micronaut.servlet.http.ParsedBodyHolder;
import io.micronaut.servlet.http.ServletExchange;
import io.micronaut.servlet.http.ServletHttpRequest;
import io.micronaut.servlet.http.ServletHttpResponse;
import io.micronaut.servlet.http.StreamedServletMessage;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;

@Internal
public final class DefaultServletHttpRequest<B>
extends MutableConvertibleValuesMap<Object>
implements ServletHttpRequest<HttpServletRequest, B>,
MutableConvertibleValues<Object>,
ServletExchange<HttpServletRequest, HttpServletResponse>,
StreamedServletMessage<B, byte[]>,
FullHttpRequest<B>,
ParsedBodyHolder<B> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultServletHttpRequest.class);
    private final ConversionService conversionService;
    private final HttpServletRequest delegate;
    private final URI uri;
    private final HttpMethod method;
    private final ServletRequestHeaders headers;
    private final ServletParameters parameters;
    private final DefaultServletHttpResponse<B> response;
    private final MediaTypeCodecRegistry codecRegistry;
    private DefaultServletCookies cookies;
    private Supplier<Optional<B>> body;
    private boolean bodyIsReadAsync;
    private ByteArrayByteBuffer<B> servletByteBuffer;
    private B parsedBody;

    protected DefaultServletHttpRequest(ConversionService conversionService, HttpServletRequest delegate, HttpServletResponse response, MediaTypeCodecRegistry codecRegistry, BodyBuilder bodyBuilder) {
        super(new ConcurrentHashMap(), conversionService);
        HttpMethod method;
        this.conversionService = conversionService;
        this.delegate = delegate;
        this.codecRegistry = codecRegistry;
        Object requestURI = delegate.getRequestURI();
        String queryString = delegate.getQueryString();
        if (StringUtils.isNotEmpty((CharSequence)queryString)) {
            requestURI = (String)requestURI + "?" + queryString;
        }
        this.uri = URI.create((String)requestURI);
        try {
            method = HttpMethod.valueOf((String)delegate.getMethod());
        }
        catch (IllegalArgumentException e) {
            method = HttpMethod.CUSTOM;
        }
        this.method = method;
        this.headers = new ServletRequestHeaders();
        this.parameters = new ServletParameters();
        this.response = new DefaultServletHttpResponse(conversionService, this, response);
        this.body = SupplierUtil.memoizedNonEmpty(() -> {
            B built = this.parsedBody != null ? this.parsedBody : bodyBuilder.buildBody(this::getInputStream, (HttpRequest)this);
            return Optional.ofNullable(built);
        });
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public MediaTypeCodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    public boolean isAsyncSupported() {
        return this.delegate.isAsyncSupported();
    }

    public void executeAsync(ServletHttpRequest.AsyncExecutionCallback asyncExecutionCallback) {
        AsyncContext asyncContext = this.delegate.startAsync();
        asyncContext.start(() -> asyncExecutionCallback.run(() -> ((AsyncContext)asyncContext).complete()));
    }

    @NonNull
    public <T> Optional<T> getBody(@NonNull Argument<T> arg) {
        if (this.bodyIsReadAsync) {
            throw new IllegalStateException("Body is being read asynchronously!");
        }
        return this.getBody().map(t -> this.conversionService.convertRequired(t, arg));
    }

    @NonNull
    public Optional<Principal> getUserPrincipal() {
        return Optional.ofNullable(super.getUserPrincipal().orElse(this.delegate.getUserPrincipal()));
    }

    public boolean isSecure() {
        return this.delegate.isSecure();
    }

    @NonNull
    public Optional<MediaType> getContentType() {
        return Optional.ofNullable(this.delegate.getContentType()).map(MediaType::new);
    }

    public long getContentLength() {
        return this.delegate.getContentLength();
    }

    @NonNull
    public InetSocketAddress getRemoteAddress() {
        return new InetSocketAddress(this.delegate.getRemoteHost(), this.delegate.getRemotePort());
    }

    @NonNull
    public InetSocketAddress getServerAddress() {
        return new InetSocketAddress(this.delegate.getServerPort());
    }

    @Nullable
    public String getServerName() {
        return this.delegate.getServerName();
    }

    @NonNull
    public Optional<Locale> getLocale() {
        return Optional.ofNullable(this.delegate.getLocale());
    }

    @NonNull
    public Charset getCharacterEncoding() {
        return Optional.ofNullable(this.delegate.getCharacterEncoding()).map(Charset::forName).orElse(StandardCharsets.UTF_8);
    }

    public String getContextPath() {
        return this.delegate.getContextPath();
    }

    public InputStream getInputStream() throws IOException {
        return this.servletByteBuffer != null ? this.servletByteBuffer.toInputStream() : this.delegate.getInputStream();
    }

    public BufferedReader getReader() throws IOException {
        return this.delegate.getReader();
    }

    public HttpServletRequest getNativeRequest() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Cookies getCookies() {
        DefaultServletCookies cookies = this.cookies;
        if (cookies == null) {
            DefaultServletHttpRequest defaultServletHttpRequest = this;
            synchronized (defaultServletHttpRequest) {
                cookies = this.cookies;
                if (cookies == null) {
                    this.cookies = cookies = new DefaultServletCookies(this.delegate.getCookies());
                }
            }
        }
        return cookies;
    }

    @NonNull
    public HttpParameters getParameters() {
        return this.parameters;
    }

    public MutableHttpRequest<B> mutate() {
        return new DefaultMutableServletHttpRequest(this);
    }

    @NonNull
    public HttpMethod getMethod() {
        return this.method;
    }

    @NonNull
    public String getMethodName() {
        return Objects.requireNonNullElseGet(this.delegate.getMethod(), () -> this.getMethod().name());
    }

    @NonNull
    public URI getUri() {
        return this.uri;
    }

    @NonNull
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @NonNull
    public MutableConvertibleValues<Object> getAttributes() {
        return this;
    }

    public void setParsedBody(B body) {
        this.parsedBody = body;
    }

    @NonNull
    public Optional<B> getBody() {
        return this.body.get();
    }

    public MutableConvertibleValues<Object> put(CharSequence key, @Nullable Object value) {
        String name = Objects.requireNonNull(key, "Key cannot be null").toString();
        if (value == null) {
            super.remove((CharSequence)name);
        } else {
            super.put((CharSequence)name, value);
        }
        return this;
    }

    public ServletHttpRequest<HttpServletRequest, ? super Object> getRequest() {
        return this;
    }

    public ServletHttpResponse<HttpServletResponse, ?> getResponse() {
        return this.response;
    }

    private boolean isFormSubmission(MediaType contentType) {
        return MediaType.APPLICATION_FORM_URLENCODED_TYPE.equals((Object)contentType) || MediaType.MULTIPART_FORM_DATA_TYPE.equals((Object)contentType);
    }

    private <T> List<T> enumerationToList(Enumeration<T> enumeration) {
        ArrayList<T> set = new ArrayList<T>(10);
        while (enumeration.hasMoreElements()) {
            set.add(enumeration.nextElement());
        }
        return set;
    }

    public void subscribe(Subscriber<? super byte[]> s) {
        this.bodyIsReadAsync = true;
        final Sinks.Many emitter = Sinks.many().replay().all();
        final byte[] buffer = new byte[1024];
        try {
            final ServletInputStream inputStream = this.delegate.getInputStream();
            inputStream.setReadListener(new ReadListener(){
                boolean complete = false;

                public void onDataAvailable() {
                    if (!this.complete) {
                        try {
                            do {
                                if (!inputStream.isReady()) continue;
                                int length = inputStream.read(buffer);
                                if (length == -1) {
                                    this.complete = true;
                                    emitter.emitComplete(Sinks.EmitFailureHandler.FAIL_FAST);
                                    break;
                                }
                                if (buffer.length == length) {
                                    emitter.emitNext((Object)buffer, Sinks.EmitFailureHandler.FAIL_FAST);
                                    continue;
                                }
                                emitter.emitNext((Object)Arrays.copyOf(buffer, length), Sinks.EmitFailureHandler.FAIL_FAST);
                            } while (inputStream.isReady());
                        }
                        catch (IOException e) {
                            this.complete = true;
                            emitter.emitError((Throwable)e, Sinks.EmitFailureHandler.FAIL_FAST);
                        }
                    }
                }

                public void onAllDataRead() {
                    if (!this.complete) {
                        this.complete = true;
                        emitter.emitComplete(Sinks.EmitFailureHandler.FAIL_FAST);
                    }
                }

                public void onError(Throwable t) {
                    if (!this.complete) {
                        this.complete = true;
                        emitter.emitError(t, Sinks.EmitFailureHandler.FAIL_FAST);
                    }
                }
            });
        }
        catch (Exception e) {
            emitter.emitError((Throwable)e, Sinks.EmitFailureHandler.FAIL_FAST);
        }
        Flux bodyContent = emitter.asFlux();
        bodyContent.subscribe(s);
    }

    public boolean isFull() {
        return !this.bodyIsReadAsync;
    }

    public ByteBuffer<?> contents() {
        if (this.bodyIsReadAsync) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Body is read asynchronously, cannot get contents");
            }
            return null;
        }
        try {
            if (this.servletByteBuffer == null) {
                this.servletByteBuffer = new ByteArrayByteBuffer(this.delegate.getInputStream().readAllBytes());
            }
            return this.servletByteBuffer;
        }
        catch (IOException e) {
            throw new IllegalStateException("Error getting all body contents", e);
        }
    }

    public ExecutionFlow<ByteBuffer<?>> bufferContents() {
        ByteBuffer<?> contents = this.contents();
        if (contents == null) {
            return null;
        }
        return ExecutionFlow.just(contents);
    }

    private class ServletRequestHeaders
    implements HttpHeaders {
        private ServletRequestHeaders() {
        }

        public List<String> getAll(CharSequence name) {
            Enumeration e = DefaultServletHttpRequest.this.delegate.getHeaders(Objects.requireNonNull(name, "Header name should not be null").toString());
            return DefaultServletHttpRequest.this.enumerationToList(e);
        }

        @Nullable
        public String get(CharSequence name) {
            return DefaultServletHttpRequest.this.delegate.getHeader(Objects.requireNonNull(name, "Header name should not be null").toString());
        }

        public Set<String> names() {
            return CollectionUtils.enumerationToSet((Enumeration)DefaultServletHttpRequest.this.delegate.getHeaderNames());
        }

        public Collection<List<String>> values() {
            return this.names().stream().map(this::getAll).toList();
        }

        public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
            String v = this.get(name);
            if (v != null) {
                return DefaultServletHttpRequest.this.conversionService.convert((Object)v, conversionContext);
            }
            return Optional.empty();
        }
    }

    private class ServletParameters
    implements HttpParameters {
        private ServletParameters() {
        }

        public List<String> getAll(CharSequence name) {
            String[] values = DefaultServletHttpRequest.this.delegate.getParameterValues(Objects.requireNonNull(name, "Parameter name cannot be null").toString());
            return Arrays.asList(values);
        }

        @Nullable
        public String get(CharSequence name) {
            return DefaultServletHttpRequest.this.delegate.getParameter(Objects.requireNonNull(name, "Parameter name cannot be null").toString());
        }

        public Set<String> names() {
            return CollectionUtils.enumerationToSet((Enumeration)DefaultServletHttpRequest.this.delegate.getParameterNames());
        }

        public Collection<List<String>> values() {
            return this.names().stream().map(this::getAll).toList();
        }

        public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
            boolean isOptional;
            Argument argument = conversionContext.getArgument();
            Class rawType = argument.getType();
            boolean bl = isOptional = rawType == Optional.class;
            if (isOptional) {
                rawType = argument.getFirstTypeVariable().map(TypeInformation::getType).orElse(rawType);
            }
            boolean isIterable = Iterable.class.isAssignableFrom(rawType);
            String paramName = Objects.requireNonNull(name, "Parameter name should not be null").toString();
            if (isIterable) {
                Object[] parameterValues = DefaultServletHttpRequest.this.delegate.getParameterValues(paramName);
                if (ArrayUtils.isNotEmpty((Object[])parameterValues)) {
                    if (parameterValues.length == 1) {
                        return DefaultServletHttpRequest.this.conversionService.convert(parameterValues[0], conversionContext);
                    }
                    if (isOptional) {
                        return DefaultServletHttpRequest.this.conversionService.convert((Object)parameterValues, ConversionContext.of((Argument)argument.getFirstTypeVariable().orElse(argument)));
                    }
                    return DefaultServletHttpRequest.this.conversionService.convert((Object)parameterValues, conversionContext);
                }
                return DefaultServletHttpRequest.this.conversionService.convert(Collections.emptyList(), conversionContext);
            }
            String v = this.get(name);
            if (v != null) {
                if (rawType.isInstance(v)) {
                    return Optional.of(v);
                }
                return DefaultServletHttpRequest.this.conversionService.convert((Object)v, conversionContext);
            }
            return Optional.empty();
        }
    }
}

