/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.engine;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.servlet.engine.DefaultServletHttpRequest;
import io.micronaut.servlet.engine.ServletCookieAdapter;
import io.micronaut.servlet.http.ServletHttpResponse;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

@Internal
public class DefaultServletHttpResponse<B>
implements ServletHttpResponse<HttpServletResponse, B> {
    private static final byte[] EMPTY_ARRAY = "[]".getBytes();
    private final ConversionService conversionService;
    private final HttpServletResponse delegate;
    private final DefaultServletHttpRequest<?> request;
    private final ServletResponseHeaders headers;
    private B body;
    private int status = HttpStatus.OK.getCode();
    private String reason = HttpStatus.OK.getReason();

    protected DefaultServletHttpResponse(ConversionService conversionService, DefaultServletHttpRequest<B> request, HttpServletResponse delegate) {
        this.conversionService = conversionService;
        this.delegate = delegate;
        this.request = request;
        this.headers = new ServletResponseHeaders();
    }

    public Publisher<MutableHttpResponse<?>> stream(Publisher<?> dataPublisher) {
        return Flux.create(emitter -> dataPublisher.subscribe((Subscriber)new Subscriber<Object>(){
            ServletOutputStream outputStream;
            Subscription subscription;
            final AtomicBoolean finished = new AtomicBoolean();
            MediaType contentType = DefaultServletHttpResponse.this.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
            MediaTypeCodec codec;
            boolean isJson;
            boolean first;
            boolean raw;
            boolean written;
            {
                this.codec = DefaultServletHttpResponse.this.request.getCodecRegistry().findCodec(this.contentType).orElse(null);
                this.isJson = this.contentType.getSubtype().equals("json");
                this.first = true;
                this.raw = false;
                this.written = false;
            }

            public void onSubscribe(final Subscription s) {
                block2: {
                    this.subscription = s;
                    DefaultServletHttpResponse.this.delegate.setHeader("Transfer-Encoding", "chunked");
                    try {
                        this.outputStream = DefaultServletHttpResponse.this.delegate.getOutputStream();
                        this.outputStream.setWriteListener(new WriteListener(){

                            public void onWritePossible() {
                                s.request(1L);
                            }

                            public void onError(Throwable t) {
                                emitter.error(t);
                            }
                        });
                    }
                    catch (IOException e) {
                        if (!this.finished.compareAndSet(false, true)) break block2;
                        emitter.error((Throwable)e);
                        this.subscription.cancel();
                    }
                }
            }

            public void onNext(Object o) {
                block4: {
                    try {
                        if (this.outputStream.isReady() && !this.finished.get()) {
                            this.writeToOutputStream(o);
                            if (this.outputStream.isReady()) {
                                this.subscription.request(1L);
                            }
                        }
                    }
                    catch (IOException e) {
                        if (!this.finished.compareAndSet(false, true)) break block4;
                        this.onError(e);
                        this.subscription.cancel();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeToOutputStream(Object o) throws IOException {
                this.written = true;
                if (o instanceof byte[]) {
                    byte[] byteArray = (byte[])o;
                    this.raw = true;
                    this.outputStream.write(byteArray);
                    this.flushIfReady();
                } else if (o instanceof ByteBuffer) {
                    ByteBuffer buf = (ByteBuffer)o;
                    try {
                        this.raw = true;
                        this.outputStream.write(buf.toByteArray());
                        this.flushIfReady();
                    }
                    finally {
                        if (buf instanceof ReferenceCounted) {
                            ReferenceCounted referenceCounted = (ReferenceCounted)buf;
                            referenceCounted.release();
                        }
                    }
                } else if (this.codec != null) {
                    if (this.isJson) {
                        if (this.first) {
                            this.outputStream.write(91);
                            this.first = false;
                        } else {
                            this.outputStream.write(44);
                        }
                    }
                    if (this.outputStream.isReady()) {
                        if (o instanceof CharSequence) {
                            this.outputStream.write(o.toString().getBytes(DefaultServletHttpResponse.this.getCharacterEncoding()));
                        } else {
                            byte[] bytes = this.codec.encode(o);
                            this.outputStream.write(bytes);
                        }
                        this.flushIfReady();
                    }
                }
            }

            private void flushIfReady() throws IOException {
                if (this.outputStream.isReady()) {
                    this.outputStream.flush();
                }
            }

            public void onError(Throwable t) {
                if (this.finished.compareAndSet(false, true)) {
                    if (t instanceof HttpStatusException) {
                        this.maybeReportErrorDownstream(t);
                    } else {
                        emitter.error(t);
                    }
                    this.subscription.cancel();
                }
            }

            private void maybeReportErrorDownstream(Throwable t) {
                HttpStatusException httpStatusException = (HttpStatusException)t;
                DefaultServletHttpResponse.this.delegate.setStatus(httpStatusException.getStatus().getCode());
                if (!this.written) {
                    try {
                        String message = httpStatusException.getBody().orElse(httpStatusException.getMessage());
                        if (this.outputStream.isReady() && message instanceof CharSequence) {
                            this.outputStream.write(message.toString().getBytes(DefaultServletHttpResponse.this.getCharacterEncoding()));
                            this.flushIfReady();
                        } else if (this.outputStream.isReady()) {
                            this.writeToOutputStream(message);
                        }
                        this.finish();
                    }
                    catch (IOException e) {
                        emitter.error((Throwable)e);
                    }
                } else {
                    emitter.error(t);
                }
            }

            public void onComplete() {
                if (this.finished.compareAndSet(false, true)) {
                    try {
                        if (!this.raw && this.isJson && this.outputStream.isReady()) {
                            if (this.first) {
                                this.outputStream.write(EMPTY_ARRAY);
                            } else {
                                this.outputStream.write(93);
                            }
                            this.flushIfReady();
                        }
                        this.finish();
                    }
                    catch (IOException e) {
                        emitter.error((Throwable)e);
                    }
                }
            }

            private void finish() {
                emitter.next((Object)DefaultServletHttpResponse.this);
                emitter.complete();
            }
        }), (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.ERROR);
    }

    @NonNull
    public Optional<MediaType> getContentType() {
        return this.conversionService.convert((Object)this.delegate.getContentType(), Argument.of(MediaType.class));
    }

    public MutableHttpResponse<B> contentType(CharSequence contentType) {
        this.delegate.setContentType(Objects.requireNonNull(contentType, "Content type cannot be null").toString());
        return this;
    }

    public MutableHttpResponse<B> contentType(MediaType mediaType) {
        this.delegate.setContentType(Objects.requireNonNull(mediaType, "Content type cannot be null").toString());
        return this;
    }

    public MutableHttpResponse<B> contentLength(long length) {
        this.delegate.setContentLengthLong(length);
        return this;
    }

    public MutableHttpResponse<B> locale(Locale locale) {
        Objects.requireNonNull(locale, "Locale cannot be null");
        this.delegate.setLocale(locale);
        return this;
    }

    public MutableHttpResponse<B> header(CharSequence name, CharSequence value) {
        String headerName = Objects.requireNonNull(name, "Header name cannot be null").toString();
        String headerValue = Objects.requireNonNull(value, "Header value cannot be null").toString();
        this.delegate.addHeader(headerName, headerValue);
        return this;
    }

    public MutableHttpResponse<B> status(int status) {
        this.status = status;
        this.delegate.setStatus(status);
        return this;
    }

    public MutableHttpResponse<B> status(HttpStatus status) {
        return this.status(Objects.requireNonNull(status, "status cannot be null").getCode());
    }

    public HttpServletResponse getNativeResponse() {
        return this.delegate;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.delegate.getOutputStream();
    }

    public BufferedWriter getWriter() throws IOException {
        return new BufferedWriter(this.delegate.getWriter());
    }

    public MutableHttpResponse<B> cookie(Cookie cookie) {
        if (cookie instanceof ServletCookieAdapter) {
            ServletCookieAdapter servletCookieAdapter = (ServletCookieAdapter)cookie;
            this.delegate.addCookie(servletCookieAdapter.getCookie());
        } else {
            String path;
            jakarta.servlet.http.Cookie c = new jakarta.servlet.http.Cookie(cookie.getName(), cookie.getValue());
            String domain = cookie.getDomain();
            if (domain != null) {
                c.setDomain(domain);
            }
            if ((path = cookie.getPath()) != null) {
                c.setPath(path);
            }
            c.setSecure(cookie.isSecure());
            c.setHttpOnly(cookie.isHttpOnly());
            c.setMaxAge((int)cookie.getMaxAge());
            this.delegate.addCookie(c);
        }
        return this;
    }

    @NonNull
    public MutableHttpHeaders getHeaders() {
        return this.headers;
    }

    @NonNull
    public MutableConvertibleValues<Object> getAttributes() {
        return this.request;
    }

    @NonNull
    public Optional<B> getBody() {
        return Optional.ofNullable(this.body);
    }

    public <T> MutableHttpResponse<T> body(@Nullable T body) {
        if (body != null) {
            this.getContentType().orElseGet(() -> {
                Object[] v;
                Produces ann = body.getClass().getAnnotation(Produces.class);
                if (ann != null && ArrayUtils.isNotEmpty((Object[])(v = ann.value()))) {
                    MediaType mediaType = new MediaType((String)v[0]);
                    this.contentType(mediaType);
                    return mediaType;
                }
                return null;
            });
        }
        this.body = body;
        return this;
    }

    public MutableHttpResponse<B> status(int status, CharSequence message) {
        this.status = status;
        this.reason = message == null ? HttpStatus.getDefaultReason((int)status) : message.toString();
        if (!this.delegate.isCommitted()) {
            this.delegate.setStatus(status);
        }
        return this;
    }

    public int code() {
        return this.delegate.getStatus();
    }

    public String reason() {
        if (this.reason != null) {
            return this.reason;
        }
        try {
            return HttpStatus.valueOf((int)this.delegate.getStatus()).getReason();
        }
        catch (Exception e) {
            return "";
        }
    }

    private class ServletResponseHeaders
    implements MutableHttpHeaders {
        private ServletResponseHeaders() {
        }

        public MutableHttpHeaders add(CharSequence header, CharSequence value) {
            String headerName = Objects.requireNonNull(header, "Header name cannot be null").toString();
            String headerValue = Objects.requireNonNull(value, "Header value cannot be null").toString();
            DefaultServletHttpResponse.this.delegate.setHeader(headerName, headerValue);
            return this;
        }

        public MutableHttpHeaders remove(CharSequence header) {
            String headerName = Objects.requireNonNull(header, "Header name cannot be null").toString();
            if (DefaultServletHttpResponse.this.delegate.containsHeader(headerName)) {
                DefaultServletHttpResponse.this.delegate.setHeader(headerName, "");
            }
            return this;
        }

        public List<String> getAll(CharSequence name) {
            Collection values = DefaultServletHttpResponse.this.delegate.getHeaders(Objects.requireNonNull(name, "Header name cannot be null").toString());
            if (values instanceof List) {
                return (List)values;
            }
            return new ArrayList<String>(values);
        }

        @Nullable
        public String get(CharSequence name) {
            return DefaultServletHttpResponse.this.delegate.getHeader(Objects.requireNonNull(name, "Header name cannot be null").toString());
        }

        public Set<String> names() {
            Collection headerNames = DefaultServletHttpResponse.this.delegate.getHeaderNames();
            if (headerNames instanceof Set) {
                return (Set)headerNames;
            }
            return new HashSet<String>(headerNames);
        }

        public Collection<List<String>> values() {
            return this.names().stream().map(this::getAll).collect(Collectors.toList());
        }

        public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
            String v = this.get(name);
            if (v != null) {
                return DefaultServletHttpResponse.this.conversionService.convert((Object)v, conversionContext);
            }
            return Optional.empty();
        }

        public void setConversionService(ConversionService conversionService) {
        }
    }
}

