/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.engine.bind;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.io.IOUtils;
import io.micronaut.core.io.Readable;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.bind.binders.AnnotatedRequestArgumentBinder;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.http.multipart.CompletedFileUpload;
import io.micronaut.http.server.exceptions.InternalServerException;
import io.micronaut.servlet.engine.ServletCompletedFileUpload;
import io.micronaut.servlet.http.ServletExchange;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

public class ServletPartBinder<T>
implements AnnotatedRequestArgumentBinder<io.micronaut.http.annotation.Part, T> {
    private final MediaTypeCodecRegistry codecRegistry;

    ServletPartBinder(MediaTypeCodecRegistry codecRegistry) {
        this.codecRegistry = codecRegistry;
    }

    public Class<io.micronaut.http.annotation.Part> getAnnotationType() {
        return io.micronaut.http.annotation.Part.class;
    }

    public ArgumentBinder.BindingResult<T> bind(ArgumentConversionContext<T> context, HttpRequest<?> source) {
        if (source instanceof ServletExchange) {
            Part part;
            ServletExchange exchange = (ServletExchange)source;
            HttpServletRequest nativeRequest = (HttpServletRequest)exchange.getRequest().getNativeRequest();
            Argument argument = context.getArgument();
            String partName = context.getAnnotationMetadata().stringValue(io.micronaut.http.annotation.Part.class).orElse(argument.getName());
            try {
                part = nativeRequest.getPart(partName);
            }
            catch (ServletException | IOException e) {
                throw new InternalServerException("Error reading part [" + partName + "]: " + e.getMessage(), e);
            }
            if (part != null) {
                MediaTypeCodec codec;
                Class type = argument.getType();
                if (Part.class.isAssignableFrom(type)) {
                    return () -> Optional.of(part);
                }
                if (Readable.class.isAssignableFrom(type)) {
                    return () -> Optional.of(new Readable(){

                        @NonNull
                        public String getName() {
                            return part.getName();
                        }

                        public Reader asReader() throws IOException {
                            Charset charset = Optional.ofNullable(part.getContentType()).map(MediaType::new).flatMap(MediaType::getCharset).orElse(StandardCharsets.UTF_8);
                            return new InputStreamReader(this.asInputStream(), charset);
                        }

                        @NonNull
                        public InputStream asInputStream() throws IOException {
                            return part.getInputStream();
                        }

                        public boolean exists() {
                            return true;
                        }
                    });
                }
                if (String.class.isAssignableFrom(type)) {
                    ArgumentBinder.BindingResult bindingResult;
                    block35: {
                        BufferedReader reader = this.newReader(part);
                        try {
                            String content = IOUtils.readText((BufferedReader)reader);
                            bindingResult = () -> Optional.of(content);
                            if (reader == null) break block35;
                        }
                        catch (Throwable content) {
                            try {
                                if (reader != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Throwable throwable) {
                                        content.addSuppressed(throwable);
                                    }
                                }
                                throw content;
                            }
                            catch (IOException e) {
                                throw new HttpStatusException(HttpStatus.BAD_REQUEST, "Unable to read part [" + partName + "]: " + e.getMessage());
                            }
                        }
                        reader.close();
                    }
                    return bindingResult;
                }
                if (byte[].class.isAssignableFrom(type)) {
                    ArgumentBinder.BindingResult bindingResult;
                    block36: {
                        InputStream is = part.getInputStream();
                        try {
                            int nRead;
                            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                            byte[] data = new byte[16384];
                            while ((nRead = is.read(data, 0, data.length)) != -1) {
                                buffer.write(data, 0, nRead);
                            }
                            byte[] content = buffer.toByteArray();
                            bindingResult = () -> Optional.of(content);
                            if (is == null) break block36;
                        }
                        catch (Throwable buffer) {
                            try {
                                if (is != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable nRead) {
                                        buffer.addSuppressed(nRead);
                                    }
                                }
                                throw buffer;
                            }
                            catch (IOException e) {
                                throw new HttpStatusException(HttpStatus.BAD_REQUEST, "Unable to read part [" + partName + "]: " + e.getMessage());
                            }
                        }
                        is.close();
                    }
                    return bindingResult;
                }
                if (CompletedFileUpload.class.isAssignableFrom(type)) {
                    return () -> Optional.of(new ServletCompletedFileUpload(part));
                }
                MediaType contentType = Optional.ofNullable(part.getContentType()).map(MediaType::new).orElse(null);
                if (contentType != null && (codec = (MediaTypeCodec)this.codecRegistry.findCodec(contentType, type).orElse(null)) != null) {
                    ArgumentBinder.BindingResult bindingResult;
                    block37: {
                        InputStream inputStream = part.getInputStream();
                        try {
                            Object content = codec.decode(argument, inputStream);
                            bindingResult = () -> Optional.of(content);
                            if (inputStream == null) break block37;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (inputStream != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException e) {
                                throw new HttpStatusException(HttpStatus.BAD_REQUEST, "Unable to read part [" + partName + "]: " + e.getMessage());
                            }
                        }
                        inputStream.close();
                    }
                    return bindingResult;
                }
            }
        }
        return ArgumentBinder.BindingResult.UNSATISFIED;
    }

    private BufferedReader newReader(Part part) throws IOException {
        Charset charset = Optional.ofNullable(part.getContentType()).map(MediaType::new).flatMap(MediaType::getCharset).orElse(StandardCharsets.UTF_8);
        InputStreamReader inputStreamReader = new InputStreamReader(part.getInputStream(), charset);
        return new BufferedReader(inputStreamReader);
    }
}

