/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.engine;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleMultiValues;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpParameters;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.Cookies;
import io.micronaut.http.simple.SimpleHttpHeaders;
import io.micronaut.http.simple.SimpleHttpParameters;
import io.micronaut.servlet.engine.DefaultServletHttpRequest;
import io.micronaut.servlet.http.MutableServletHttpRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Internal
final class DefaultMutableServletHttpRequest<B>
implements MutableServletHttpRequest<HttpServletRequest, B> {
    private final DefaultServletHttpRequest<B> servletHttpRequest;
    private URI uri;
    private ConversionService conversionService;
    private B body;
    private final MutableHttpParameters parameters;
    private final MutableHttpHeaders headers;

    DefaultMutableServletHttpRequest(DefaultServletHttpRequest<B> servletHttpRequest) {
        this.servletHttpRequest = servletHttpRequest;
        this.conversionService = servletHttpRequest.getConversionService();
        this.parameters = new SimpleHttpParameters(DefaultMutableServletHttpRequest.copyValues((ConvertibleMultiValues<String>)servletHttpRequest.getParameters()), servletHttpRequest.getConversionService());
        this.parameters.setConversionService(this.conversionService);
        SimpleHttpHeaders newHeaders = new SimpleHttpHeaders(new LinkedHashMap(), servletHttpRequest.getConversionService());
        newHeaders.setConversionService(this.conversionService);
        servletHttpRequest.getHeaders().forEach((name, values) -> {
            for (String value : values) {
                newHeaders.add((CharSequence)name, (CharSequence)value);
            }
        });
        this.headers = newHeaders;
    }

    private static Map<CharSequence, List<String>> copyValues(ConvertibleMultiValues<String> params) {
        LinkedHashMap<CharSequence, List<String>> values = new LinkedHashMap<CharSequence, List<String>>(params.names().size());
        params.forEach(entry -> values.put((CharSequence)entry.getKey(), (List)entry.getValue()));
        return values;
    }

    ConversionService getConversionService() {
        return this.conversionService;
    }

    public MutableHttpRequest<B> cookie(Cookie cookie) {
        return this;
    }

    public MutableHttpRequest<B> uri(URI uri) {
        this.uri = uri;
        return this;
    }

    public <T> MutableHttpRequest<T> body(T body) {
        this.body = body;
        return this;
    }

    public MutableHttpHeaders getHeaders() {
        return this.headers;
    }

    public MutableConvertibleValues<Object> getAttributes() {
        return this.servletHttpRequest.getAttributes();
    }

    public Optional<B> getBody() {
        if (this.body != null) {
            return Optional.ofNullable(this.body);
        }
        return this.servletHttpRequest.getBody();
    }

    public Cookies getCookies() {
        return this.servletHttpRequest.getCookies();
    }

    public MutableHttpParameters getParameters() {
        return this.parameters;
    }

    public HttpMethod getMethod() {
        return this.servletHttpRequest.getMethod();
    }

    public URI getUri() {
        if (this.uri != null) {
            return this.uri;
        }
        return this.servletHttpRequest.getUri();
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public InputStream getInputStream() throws IOException {
        B b = this.body;
        if (b instanceof InputStream) {
            InputStream in = (InputStream)b;
            return in;
        }
        return this.servletHttpRequest.getInputStream();
    }

    public BufferedReader getReader() throws IOException {
        B b = this.body;
        if (b instanceof InputStream) {
            InputStream in = (InputStream)b;
            return new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        }
        b = this.body;
        if (b instanceof BufferedReader) {
            BufferedReader reader = (BufferedReader)b;
            return reader;
        }
        b = this.body;
        if (b instanceof Reader) {
            Reader r = (Reader)b;
            return new BufferedReader(r);
        }
        return this.servletHttpRequest.getReader();
    }

    public HttpServletRequest getNativeRequest() {
        return this.servletHttpRequest.getNativeRequest();
    }
}

