/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.engine;

import io.micronaut.context.annotation.ConfigurationInject;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Property;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.naming.Named;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.servlet.http.ServletConfiguration;
import jakarta.servlet.MultipartConfigElement;
import java.io.File;
import java.util.Optional;

@ConfigurationProperties(value="micronaut.servlet")
public class MicronautServletConfiguration
implements Named,
ServletConfiguration {
    public static final String PREFIX = "micronaut.servlet";
    private final String mapping;
    private final MultipartConfigElement multipartConfigElement;
    private final String name;
    private boolean asyncFileServingEnabled = true;
    private boolean asyncSupported = true;
    private boolean enableVirtualThreads = true;

    @ConfigurationInject
    public MicronautServletConfiguration(@Bindable(defaultValue="micronaut") String name, @Bindable(defaultValue="/*") String mapping, HttpServerConfiguration serverConfiguration) {
        this.mapping = mapping != null ? mapping : "/*";
        this.name = name != null ? name : "micronaut";
        HttpServerConfiguration.MultipartConfiguration multipart = serverConfiguration.getMultipart();
        this.multipartConfigElement = multipart != null && multipart.isEnabled() ? new MultipartConfigElement((String)multipart.getLocation().map(File::getAbsolutePath).orElse(null), multipart.getMaxFileSize(), serverConfiguration.getMaxRequestSize(), (int)multipart.getThreshold()) : null;
    }

    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    public void setAsyncSupported(boolean asyncSupported) {
        this.asyncSupported = asyncSupported;
    }

    @Deprecated(forRemoval=true, since="4.8.0")
    @Property(name="micronaut.server.testing.async")
    public void setTestAsyncSupported(@Nullable Boolean asyncSupported) {
        if (asyncSupported != null) {
            this.asyncSupported = asyncSupported;
        }
    }

    public boolean isEnableVirtualThreads() {
        return this.enableVirtualThreads;
    }

    public void setEnableVirtualThreads(boolean enableVirtualThreads) {
        this.enableVirtualThreads = enableVirtualThreads;
    }

    public String getMapping() {
        return this.mapping;
    }

    public Optional<MultipartConfigElement> getMultipartConfigElement() {
        return Optional.ofNullable(this.multipartConfigElement);
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public void setAsyncFileServingEnabled(boolean enabled) {
        this.asyncFileServingEnabled = enabled;
    }

    public boolean isAsyncFileServingEnabled() {
        return this.asyncSupported && this.asyncFileServingEnabled;
    }
}

