/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.engine;

import io.micronaut.core.annotation.Internal;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;

@Internal
final class LazyDelegateInputStream
extends InputStream {
    private HttpServletRequest request;
    private InputStream delegate;

    LazyDelegateInputStream(HttpServletRequest request) {
        this.request = request;
    }

    private InputStream delegate() throws IOException {
        if (this.delegate == null) {
            this.delegate = this.request.getInputStream();
            this.request = null;
        }
        return this.delegate;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.delegate().read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.delegate().skip(n);
    }

    @Override
    public int read() throws IOException {
        return this.delegate().read();
    }

    @Override
    public int available() throws IOException {
        return this.delegate().available();
    }

    @Override
    public void close() throws IOException {
        this.delegate().close();
    }
}

