/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.engine.bind;

import io.micronaut.context.annotation.Replaces;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.ServerHttpRequest;
import io.micronaut.http.annotation.Part;
import io.micronaut.http.bind.DefaultRequestBinderRegistry;
import io.micronaut.http.bind.binders.DefaultBodyAnnotationBinder;
import io.micronaut.http.bind.binders.RequestArgumentBinder;
import io.micronaut.http.body.AvailableByteBody;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.multipart.CompletedPart;
import io.micronaut.json.codec.MapperMediaTypeCodec;
import io.micronaut.servlet.engine.bind.CompletedPartRequestArgumentBinder;
import io.micronaut.servlet.engine.bind.ServletConfigBinder;
import io.micronaut.servlet.engine.bind.ServletContextBinder;
import io.micronaut.servlet.engine.bind.ServletPartBinder;
import io.micronaut.servlet.engine.bind.ServletRequestBinder;
import io.micronaut.servlet.engine.bind.ServletResponseBinder;
import io.micronaut.servlet.http.ServletBinderRegistry;
import io.micronaut.servlet.http.ServletBodyBinder;
import jakarta.inject.Singleton;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Flux;

@Singleton
@Replaces(value=DefaultRequestBinderRegistry.class)
@Internal
class DefaultServletBinderRegistry<T>
extends ServletBinderRegistry<T> {
    public static final Argument<byte[]> BYTE_ARRAY = Argument.of(byte[].class);

    public DefaultServletBinderRegistry(MediaTypeCodecRegistry mediaTypeCodecRegistry, ConversionService conversionService, List<RequestArgumentBinder> binders, DefaultBodyAnnotationBinder<T> defaultBodyAnnotationBinder) {
        super(mediaTypeCodecRegistry, conversionService, binders, defaultBodyAnnotationBinder);
        this.byType.put(HttpServletRequest.class, new ServletRequestBinder());
        this.byType.put(HttpServletResponse.class, new ServletResponseBinder());
        this.byType.put(ServletConfig.class, new ServletConfigBinder());
        this.byType.put(ServletContext.class, new ServletContextBinder());
        this.byType.put(CompletedPart.class, new CompletedPartRequestArgumentBinder());
        this.byAnnotation.put(Part.class, new ServletPartBinder(mediaTypeCodecRegistry));
    }

    protected ServletBodyBinder<T> newServletBodyBinder(MediaTypeCodecRegistry mediaTypeCodecRegistry, ConversionService conversionService, DefaultBodyAnnotationBinder<T> defaultBodyAnnotationBinder) {
        return new DefaultServletBodyBinder<T>(conversionService, mediaTypeCodecRegistry, defaultBodyAnnotationBinder);
    }

    private static class DefaultServletBodyBinder<T>
    extends ServletBodyBinder<T> {
        private final MediaTypeCodecRegistry mediaTypeCodecRegistry;

        public DefaultServletBodyBinder(ConversionService conversionService, MediaTypeCodecRegistry mediaTypeCodecRegistry, DefaultBodyAnnotationBinder<T> defaultBodyAnnotationBinder) {
            super(conversionService, mediaTypeCodecRegistry, defaultBodyAnnotationBinder);
            this.mediaTypeCodecRegistry = mediaTypeCodecRegistry;
        }

        public ArgumentBinder.BindingResult bind(ArgumentConversionContext context, HttpRequest source) {
            Argument argument = context.getArgument();
            Class type = argument.getType();
            if (CompletionStage.class.isAssignableFrom(type)) {
                CompletionStage future;
                ServerHttpRequest serverRequest = (ServerHttpRequest)source;
                Argument<byte[]> typeArgument = argument.getFirstTypeVariable().orElse(BYTE_ARRAY);
                Class javaArgument = typeArgument.getType();
                Charset characterEncoding = source.getCharacterEncoding();
                if (CharSequence.class.isAssignableFrom(javaArgument)) {
                    future = serverRequest.byteBody().buffer().thenApply(bb -> bb.toString(characterEncoding));
                } else if (BYTE_ARRAY.getType().isAssignableFrom(type)) {
                    future = serverRequest.byteBody().buffer().thenApply(AvailableByteBody::toByteArray);
                } else {
                    MediaType mediaType = serverRequest.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
                    MapperMediaTypeCodec codec = this.mediaTypeCodecRegistry.findCodec(mediaType, javaArgument).orElse(null);
                    if (codec == null) {
                        return super.bind(context, source);
                    }
                    Processor jsonProcessor = codec.getJsonMapper().createReactiveParser(p -> serverRequest.byteBody().toByteArrayPublisher().subscribe((Subscriber)p), false);
                    future = Flux.from((Publisher)jsonProcessor).next().map(node -> codec.decode(typeArgument, node)).toFuture();
                }
                return () -> DefaultServletBodyBinder.lambda$bind$3((CompletableFuture)future);
            }
            if (CompletedPart.class.isAssignableFrom(type)) {
                return new CompletedPartRequestArgumentBinder().bind((ArgumentConversionContext<CompletedPart>)context, source);
            }
            if (Publishers.isConvertibleToPublisher((Class)type)) {
                Argument<byte[]> typeArgument = argument.getFirstTypeVariable().orElse(BYTE_ARRAY);
                Class javaArgument = typeArgument.getType();
                ServerHttpRequest serverRequest = (ServerHttpRequest)source;
                Charset characterEncoding = serverRequest.getCharacterEncoding();
                if (CharSequence.class.isAssignableFrom(javaArgument)) {
                    Flux stringFlux = Flux.from((Publisher)serverRequest.byteBody().toByteArrayPublisher()).map(bytes -> new String((byte[])bytes, characterEncoding));
                    if (type.isInstance(stringFlux)) {
                        return () -> Optional.of(stringFlux);
                    }
                    Object converted = Publishers.convertPublisher((ConversionService)this.conversionService, (Object)stringFlux, (Class)type);
                    return () -> Optional.of(converted);
                }
                if (byte[].class.isAssignableFrom(javaArgument)) {
                    Object converted = Publishers.convertPublisher((ConversionService)this.conversionService, (Object)Flux.from((Publisher)serverRequest.byteBody().toByteArrayPublisher()), (Class)type);
                    return () -> Optional.of(converted);
                }
                MediaType mediaType = serverRequest.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
                MapperMediaTypeCodec codec = this.mediaTypeCodecRegistry.findCodec(mediaType, javaArgument).orElse(null);
                if (codec != null) {
                    Processor jsonProcessor = codec.getJsonMapper().createReactiveParser(p -> serverRequest.byteBody().toByteArrayPublisher().subscribe((Subscriber)p), true);
                    Object converted = Publishers.convertPublisher((ConversionService)this.conversionService, (Object)Flux.from((Publisher)jsonProcessor).map(jsonNode -> codec.decode(typeArgument, jsonNode)), (Class)type);
                    return () -> Optional.of(converted);
                }
            }
            return super.bind(context, source);
        }

        private static /* synthetic */ Optional lambda$bind$3(CompletableFuture future) {
            return Optional.of(future);
        }
    }
}

