/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.engine;

import io.micronaut.context.ApplicationContext;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.servlet.engine.DefaultServletHttpRequest;
import io.micronaut.servlet.http.BodyBuilder;
import io.micronaut.servlet.http.SSLSessionProvider;
import io.micronaut.servlet.http.ServletExchange;
import io.micronaut.servlet.http.ServletHttpHandler;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;

@Singleton
public class DefaultServletHttpHandler
extends ServletHttpHandler<HttpServletRequest, HttpServletResponse> {
    private final Executor ioExecutor;
    private final SSLSessionProvider sslSessionProvider;

    @Inject
    public DefaultServletHttpHandler(ApplicationContext applicationContext, ConversionService conversionService, @Named(value="blocking") Executor ioExecutor, @Nullable SSLSessionProvider sslSessionProvider) {
        super(applicationContext, conversionService);
        this.ioExecutor = ioExecutor;
        this.sslSessionProvider = sslSessionProvider;
    }

    @Deprecated
    public DefaultServletHttpHandler(ApplicationContext applicationContext, ConversionService conversionService, @Named(value="blocking") Executor ioExecutor) {
        this(applicationContext, conversionService, ioExecutor, null);
    }

    @Deprecated
    public DefaultServletHttpHandler(ApplicationContext applicationContext, ConversionService conversionService) {
        this(applicationContext, conversionService, ForkJoinPool.commonPool());
    }

    @Deprecated
    public DefaultServletHttpHandler(ApplicationContext applicationContext) {
        this(applicationContext, ConversionService.SHARED);
    }

    protected ServletExchange<HttpServletRequest, HttpServletResponse> createExchange(HttpServletRequest request, HttpServletResponse response) {
        return new DefaultServletHttpRequest(this.applicationContext.getConversionService(), request, response, this.getMediaTypeCodecRegistry(), (BodyBuilder)this.applicationContext.getBean(BodyBuilder.class), this.ioExecutor, this.sslSessionProvider);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) {
        ServletExchange<HttpServletRequest, HttpServletResponse> exchange = this.createExchange(request, response);
        this.service(exchange);
    }

    public boolean isRunning() {
        return this.getApplicationContext().isRunning();
    }
}

