/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.engine;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.attr.AttributeHolder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.io.buffer.ByteArrayBufferFactory;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.TypeInformation;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.core.util.functional.ThrowingSupplier;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpParameters;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.ServerHttpRequest;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.body.ByteBodyFactory;
import io.micronaut.http.body.ByteBufferBodyAdapter;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.stream.InputStreamByteBody;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.cookie.Cookies;
import io.micronaut.servlet.engine.DefaultMutableServletHttpRequest;
import io.micronaut.servlet.engine.DefaultServletCookies;
import io.micronaut.servlet.engine.DefaultServletHttpResponse;
import io.micronaut.servlet.engine.LazyDelegateInputStream;
import io.micronaut.servlet.engine.ServletStreamPublisher;
import io.micronaut.servlet.http.BodyBuilder;
import io.micronaut.servlet.http.ParsedBodyHolder;
import io.micronaut.servlet.http.SSLSessionProvider;
import io.micronaut.servlet.http.ServletExchange;
import io.micronaut.servlet.http.ServletHttpRequest;
import io.micronaut.servlet.http.ServletHttpResponse;
import io.micronaut.servlet.http.StreamedServletMessage;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.net.ssl.SSLSession;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

@Internal
public final class DefaultServletHttpRequest<B>
implements ServletHttpRequest<HttpServletRequest, B>,
ServletExchange<HttpServletRequest, HttpServletResponse>,
StreamedServletMessage<B, byte[]>,
ServerHttpRequest<B>,
ParsedBodyHolder<B> {
    private static final String NULL_KEY = "Attribute key cannot be null";
    private final ConversionService conversionService;
    private final HttpServletRequest delegate;
    private final URI uri;
    private final HttpMethod method;
    private final ServletRequestHeaders headers;
    private final ServletParameters parameters;
    private DefaultServletHttpResponse<B> primaryResponse;
    private final MediaTypeCodecRegistry codecRegistry;
    private final MutableConvertibleValues<Object> attributes;
    private final CloseableByteBody byteBody;
    private final SSLSessionProvider sslSessionProvider;
    private DefaultServletCookies cookies;
    private Supplier<Optional<B>> body;
    private boolean bodyIsReadAsync;
    private B parsedBody;
    private AsyncContext asyncContext;

    private DefaultServletHttpRequest(ConversionService conversionService, HttpServletRequest delegate, HttpServletResponse response, MediaTypeCodecRegistry codecRegistry, BodyBuilder bodyBuilder, Executor ioExecutor) {
        this(conversionService, delegate, response, codecRegistry, bodyBuilder, ioExecutor, null);
    }

    DefaultServletHttpRequest(final ConversionService conversionService, HttpServletRequest delegate, HttpServletResponse response, MediaTypeCodecRegistry codecRegistry, BodyBuilder bodyBuilder, Executor ioExecutor, @Nullable SSLSessionProvider sslSessionProvider) {
        HttpMethod method;
        OptionalLong length;
        this.conversionService = conversionService;
        this.delegate = delegate;
        this.codecRegistry = codecRegistry;
        this.sslSessionProvider = sslSessionProvider;
        long contentLengthLong = delegate.getContentLengthLong();
        OptionalLong optionalLong = length = contentLengthLong < 0L ? OptionalLong.empty() : OptionalLong.of(contentLengthLong);
        this.byteBody = delegate.isAsyncSupported() ? ByteBufferBodyAdapter.adapt((Publisher)new ServletStreamPublisher((ThrowingSupplier<ServletInputStream, IOException>)((ThrowingSupplier)() -> ((HttpServletRequest)delegate).getInputStream())), (OptionalLong)length) : InputStreamByteBody.create((InputStream)new LazyDelegateInputStream(delegate), (OptionalLong)length, (Executor)ioExecutor, (ByteBodyFactory)ByteBodyFactory.createDefault((ByteBufferFactory)ByteArrayBufferFactory.INSTANCE));
        Object requestURI = delegate.getRequestURI();
        String queryString = delegate.getQueryString();
        if (StringUtils.isNotEmpty((CharSequence)queryString)) {
            requestURI = (String)requestURI + "?" + queryString;
        }
        this.uri = URI.create((String)requestURI);
        try {
            method = HttpMethod.valueOf((String)delegate.getMethod());
        }
        catch (IllegalArgumentException e) {
            method = HttpMethod.CUSTOM;
        }
        this.method = method;
        this.headers = new ServletRequestHeaders();
        this.parameters = new ServletParameters();
        this.primaryResponse = new DefaultServletHttpResponse(conversionService, this, response);
        this.body = SupplierUtil.memoizedNonEmpty(() -> {
            B built = this.parsedBody != null ? this.parsedBody : bodyBuilder.buildBody(this::getInputStream, (HttpRequest)this);
            return Optional.ofNullable(built);
        });
        this.attributes = new MutableConvertibleValues<Object>(){

            public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
                Objects.requireNonNull(conversionContext, "Conversion context cannot be null");
                Objects.requireNonNull(name, DefaultServletHttpRequest.NULL_KEY);
                Object attribute = null;
                try {
                    attribute = DefaultServletHttpRequest.this.delegate().getAttribute(name.toString());
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                return Optional.ofNullable(attribute).flatMap(v -> conversionService.convert(v, conversionContext));
            }

            public Set<String> names() {
                try {
                    Enumeration attributeNames = DefaultServletHttpRequest.this.delegate().getAttributeNames();
                    return CollectionUtils.enumerationToSet((Enumeration)attributeNames);
                }
                catch (IllegalStateException e) {
                    return Set.of();
                }
            }

            public Collection<Object> values() {
                try {
                    ServletRequest request = DefaultServletHttpRequest.this.delegate();
                    return this.names().stream().map(arg_0 -> ((ServletRequest)request).getAttribute(arg_0)).toList();
                }
                catch (IllegalStateException e) {
                    return Collections.emptyList();
                }
            }

            public MutableConvertibleValues<Object> put(CharSequence key, @Nullable Object value) {
                Objects.requireNonNull(key, DefaultServletHttpRequest.NULL_KEY);
                DefaultServletHttpRequest.this.delegate().setAttribute(key.toString(), value);
                return this;
            }

            public MutableConvertibleValues<Object> remove(CharSequence key) {
                Objects.requireNonNull(key, DefaultServletHttpRequest.NULL_KEY);
                DefaultServletHttpRequest.this.delegate().removeAttribute(key.toString());
                return this;
            }

            public MutableConvertibleValues<Object> clear() {
                ServletRequest request = DefaultServletHttpRequest.this.delegate();
                this.names().forEach(arg_0 -> ((ServletRequest)request).removeAttribute(arg_0));
                return this;
            }
        };
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public HttpVersion getHttpVersion() {
        String protocol;
        return switch (protocol = this.getNativeRequest().getProtocol()) {
            case "HTTP/2.0" -> HttpVersion.HTTP_2_0;
            default -> super.getHttpVersion();
        };
    }

    MediaTypeCodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    public boolean isAsyncSupported() {
        return this.asyncContext != null || this.delegate.isAsyncSupported();
    }

    public void executeAsync(ServletHttpRequest.AsyncExecutionCallback asyncExecutionCallback) {
        if (this.asyncContext != null) {
            throw new IllegalStateException("Async execution has already been started");
        }
        this.asyncContext = this.delegate.startAsync();
        this.asyncContext.start(() -> asyncExecutionCallback.run(() -> ((AsyncContext)this.asyncContext).complete()));
    }

    @NonNull
    public <T> Optional<T> getBody(@NonNull Argument<T> arg) {
        if (this.bodyIsReadAsync) {
            throw new IllegalStateException("Body is being read asynchronously!");
        }
        return this.getBody().map(t -> this.conversionService.convertRequired(t, arg));
    }

    @NonNull
    public Optional<Principal> getUserPrincipal() {
        return Optional.ofNullable(super.getUserPrincipal().orElse(this.delegate.getUserPrincipal()));
    }

    public boolean isSecure() {
        return this.delegate().isSecure();
    }

    @NonNull
    public Optional<MediaType> getContentType() {
        String contentType = this.delegate().getContentType();
        return Optional.ofNullable(contentType).map(MediaType::new);
    }

    public long getContentLength() {
        return this.delegate().getContentLength();
    }

    @NonNull
    public InetSocketAddress getRemoteAddress() {
        ServletRequest servletRequest = this.delegate();
        return new InetSocketAddress(servletRequest.getRemoteHost(), servletRequest.getRemotePort());
    }

    private ServletRequest delegate() {
        return this.asyncContext != null ? this.asyncContext.getRequest() : this.delegate;
    }

    @NonNull
    public InetSocketAddress getServerAddress() {
        return new InetSocketAddress(this.delegate().getLocalPort());
    }

    @Nullable
    public String getServerName() {
        return this.delegate().getServerName();
    }

    @NonNull
    public Optional<Locale> getLocale() {
        return Optional.ofNullable(this.delegate().getLocale());
    }

    @NonNull
    public Charset getCharacterEncoding() {
        String characterEncoding = this.delegate().getCharacterEncoding();
        return Optional.ofNullable(characterEncoding).map(Charset::forName).orElse(StandardCharsets.UTF_8);
    }

    public String getContextPath() {
        return this.delegate.getContextPath();
    }

    public InputStream getInputStream() throws IOException {
        return this.byteBody().split(ByteBody.SplitBackpressureMode.FASTEST).toInputStream();
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader(this.getInputStream(), this.getCharacterEncoding()));
    }

    public HttpServletRequest getNativeRequest() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Cookies getCookies() {
        DefaultServletCookies cookies = this.cookies;
        if (cookies == null) {
            DefaultServletHttpRequest defaultServletHttpRequest = this;
            synchronized (defaultServletHttpRequest) {
                cookies = this.cookies;
                if (cookies == null) {
                    this.cookies = cookies = new DefaultServletCookies(this.delegate.getCookies());
                }
            }
        }
        return cookies;
    }

    @NonNull
    public HttpParameters getParameters() {
        return this.parameters;
    }

    public MutableHttpRequest<B> mutate() {
        return new DefaultMutableServletHttpRequest(this);
    }

    @NonNull
    public HttpMethod getMethod() {
        return this.method;
    }

    @NonNull
    public String getMethodName() {
        return Objects.requireNonNullElseGet(this.delegate.getMethod(), () -> this.getMethod().name());
    }

    @NonNull
    public URI getUri() {
        return this.uri;
    }

    @NonNull
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @NonNull
    public MutableConvertibleValues<Object> getAttributes() {
        return this.attributes;
    }

    public void setParsedBody(B body) {
        this.parsedBody = body;
    }

    @NonNull
    public Optional<B> getBody() {
        return this.body.get();
    }

    public ServletHttpRequest<HttpServletRequest, ? super Object> getRequest() {
        return this;
    }

    public ServletHttpResponse<HttpServletResponse, ?> getResponse() {
        return this.primaryResponse;
    }

    public ServletHttpResponse<HttpServletResponse, ?> createResponse() {
        DefaultServletHttpResponse<?> r = this.primaryResponse.createNewPrimaryResponse();
        this.primaryResponse = r;
        return r;
    }

    private <T> List<T> enumerationToList(Enumeration<T> enumeration) {
        ArrayList<T> set = new ArrayList<T>(10);
        while (enumeration.hasMoreElements()) {
            set.add(enumeration.nextElement());
        }
        return set;
    }

    public void subscribe(Subscriber<? super byte[]> s) {
        this.bodyIsReadAsync = true;
        this.byteBody().toByteArrayPublisher().subscribe(s);
    }

    @NonNull
    public ByteBody byteBody() {
        return this.byteBody;
    }

    public void close() {
        this.byteBody.close();
    }

    public Optional<SSLSession> getSslSession() {
        if (this.sslSessionProvider != null) {
            return this.sslSessionProvider.getSSLSession((AttributeHolder)this);
        }
        return super.getSslSession();
    }

    private class ServletRequestHeaders
    implements HttpHeaders {
        private ServletRequestHeaders() {
        }

        public List<String> getAll(CharSequence name) {
            Enumeration e = DefaultServletHttpRequest.this.delegate.getHeaders(Objects.requireNonNull(name, "Header name should not be null").toString());
            return DefaultServletHttpRequest.this.enumerationToList(e);
        }

        @Nullable
        public String get(CharSequence name) {
            return DefaultServletHttpRequest.this.delegate.getHeader(Objects.requireNonNull(name, "Header name should not be null").toString());
        }

        public Set<String> names() {
            return CollectionUtils.enumerationToSet((Enumeration)DefaultServletHttpRequest.this.delegate.getHeaderNames());
        }

        public Collection<List<String>> values() {
            return this.names().stream().map(this::getAll).toList();
        }

        public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
            String v = this.get(name);
            if (v != null) {
                return DefaultServletHttpRequest.this.conversionService.convert((Object)v, conversionContext);
            }
            return Optional.empty();
        }
    }

    private class ServletParameters
    implements HttpParameters {
        private ServletParameters() {
        }

        public List<String> getAll(CharSequence name) {
            String[] values = DefaultServletHttpRequest.this.delegate.getParameterValues(Objects.requireNonNull(name, "Parameter name cannot be null").toString());
            return Arrays.asList(values);
        }

        @Nullable
        public String get(CharSequence name) {
            return DefaultServletHttpRequest.this.delegate.getParameter(Objects.requireNonNull(name, "Parameter name cannot be null").toString());
        }

        public Set<String> names() {
            return CollectionUtils.enumerationToSet((Enumeration)DefaultServletHttpRequest.this.delegate.getParameterNames());
        }

        public Collection<List<String>> values() {
            return this.names().stream().map(this::getAll).toList();
        }

        public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
            boolean isOptional;
            Argument argument = conversionContext.getArgument();
            Class rawType = argument.getType();
            boolean bl = isOptional = rawType == Optional.class;
            if (isOptional) {
                rawType = argument.getFirstTypeVariable().map(TypeInformation::getType).orElse(rawType);
            }
            boolean isIterable = Iterable.class.isAssignableFrom(rawType);
            String paramName = Objects.requireNonNull(name, "Parameter name should not be null").toString();
            if (isIterable) {
                Object[] parameterValues = DefaultServletHttpRequest.this.delegate.getParameterValues(paramName);
                if (ArrayUtils.isNotEmpty((Object[])parameterValues)) {
                    if (parameterValues.length == 1) {
                        return DefaultServletHttpRequest.this.conversionService.convert(parameterValues[0], conversionContext);
                    }
                    if (isOptional) {
                        return DefaultServletHttpRequest.this.conversionService.convert((Object)parameterValues, ConversionContext.of((Argument)argument.getFirstTypeVariable().orElse(argument)));
                    }
                    return DefaultServletHttpRequest.this.conversionService.convert((Object)parameterValues, conversionContext);
                }
                return DefaultServletHttpRequest.this.conversionService.convert(Collections.emptyList(), conversionContext);
            }
            String v = this.get(name);
            if (v != null) {
                if (rawType.isInstance(v)) {
                    return Optional.of(v);
                }
                return DefaultServletHttpRequest.this.conversionService.convert((Object)v, conversionContext);
            }
            return Optional.empty();
        }
    }
}

