/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.engine;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpResponseProvider;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.http.simple.SimpleHttpHeaders;
import io.micronaut.servlet.engine.DefaultServletHttpRequest;
import io.micronaut.servlet.engine.ServletCookieAdapter;
import io.micronaut.servlet.http.ServletHttpResponse;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

@Internal
public final class DefaultServletHttpResponse<B>
implements ServletHttpResponse<HttpServletResponse, B> {
    private static volatile boolean writeBufferAvailable = true;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultServletHttpResponse.class);
    private static final byte[] EMPTY_ARRAY = "[]".getBytes();
    private final ConversionService conversionService;
    private ResponseMetadata delegate;
    private final DefaultServletHttpRequest<?> request;
    private final ServletResponseHeaders headers;
    private final MutableConvertibleValues<Object> attributes;
    private B body;
    private String reason = HttpStatus.OK.getReason();

    DefaultServletHttpResponse(ConversionService conversionService, DefaultServletHttpRequest<B> request, HttpServletResponse delegate) {
        this(conversionService, request, delegate, new ServletResponseHeaders(delegate, conversionService));
    }

    DefaultServletHttpResponse(ConversionService conversionService, DefaultServletHttpRequest<B> request, HttpServletResponse delegate, ServletResponseHeaders headers) {
        this.conversionService = conversionService;
        this.delegate = new DelegateResponseMetadata(delegate);
        this.attributes = new MutableConvertibleValuesMap(new LinkedHashMap(), conversionService);
        this.request = request;
        this.headers = headers;
    }

    DefaultServletHttpResponse<?> createNewPrimaryResponse() {
        HttpServletResponse nativeResponse = ((DelegateResponseMetadata)this.delegate).delegate;
        DefaultServletHttpResponse newPrimary = new DefaultServletHttpResponse(this.conversionService, this.request, nativeResponse, this.headers);
        this.delegate = new LocalResponseMetadata();
        nativeResponse.reset();
        return newPrimary;
    }

    public boolean isCommitted() {
        return this.delegate.isCommitted();
    }

    public Publisher<MutableHttpResponse<?>> stream(Publisher<?> dataPublisher) {
        return Flux.create(emitter -> dataPublisher.subscribe((Subscriber)new Subscriber<Object>(){
            ServletOutputStream outputStream;
            Subscription subscription;
            final AtomicBoolean finished = new AtomicBoolean();
            MediaType contentType = DefaultServletHttpResponse.this.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
            MediaTypeCodec codec;
            boolean isJson;
            boolean first;
            boolean raw;
            boolean written;
            {
                this.codec = DefaultServletHttpResponse.this.request.getCodecRegistry().findCodec(this.contentType).orElse(null);
                this.isJson = this.contentType.getSubtype().equals("json");
                this.first = true;
                this.raw = false;
                this.written = false;
            }

            public void onSubscribe(final Subscription s) {
                block2: {
                    this.subscription = s;
                    DefaultServletHttpResponse.this.delegate.setHeader("Transfer-Encoding", "chunked");
                    try {
                        this.outputStream = DefaultServletHttpResponse.this.delegate.getOutputStream();
                        this.outputStream.setWriteListener(new WriteListener(){

                            public void onWritePossible() {
                                s.request(1L);
                            }

                            public void onError(Throwable t) {
                                emitter.error(t);
                            }
                        });
                    }
                    catch (IOException e) {
                        if (!this.finished.compareAndSet(false, true)) break block2;
                        emitter.error((Throwable)e);
                        this.subscription.cancel();
                    }
                }
            }

            public void onNext(Object o) {
                block4: {
                    try {
                        if (this.outputStream.isReady() && !this.finished.get()) {
                            this.writeToOutputStream(o);
                            if (this.outputStream.isReady()) {
                                this.subscription.request(1L);
                            }
                        }
                    }
                    catch (IOException e) {
                        if (!this.finished.compareAndSet(false, true)) break block4;
                        this.onError(e);
                        this.subscription.cancel();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeToOutputStream(Object o) throws IOException {
                this.written = true;
                if (o instanceof byte[]) {
                    byte[] byteArray = (byte[])o;
                    this.raw = true;
                    this.outputStream.write(byteArray);
                    this.flushIfReady();
                } else if (o instanceof ByteBuffer) {
                    ByteBuffer buf = (ByteBuffer)o;
                    try {
                        this.raw = true;
                        this.outputStream.write(buf.toByteArray());
                        this.flushIfReady();
                    }
                    finally {
                        if (buf instanceof ReferenceCounted) {
                            ReferenceCounted referenceCounted = (ReferenceCounted)buf;
                            referenceCounted.release();
                        }
                    }
                } else if (this.codec != null) {
                    if (this.isJson) {
                        if (this.first) {
                            this.outputStream.write(91);
                            this.first = false;
                        } else {
                            this.outputStream.write(44);
                        }
                    }
                    if (this.outputStream.isReady()) {
                        if (o instanceof CharSequence) {
                            this.outputStream.write(o.toString().getBytes(DefaultServletHttpResponse.this.getCharacterEncoding()));
                        } else {
                            byte[] bytes = this.codec.encode(o);
                            this.outputStream.write(bytes);
                        }
                        this.flushIfReady();
                    }
                }
            }

            private void flushIfReady() throws IOException {
                if (this.outputStream.isReady()) {
                    this.outputStream.flush();
                }
            }

            public void onError(Throwable t) {
                if (this.finished.compareAndSet(false, true)) {
                    if (t instanceof HttpStatusException) {
                        this.maybeReportErrorDownstream(t);
                    } else {
                        if (LOG.isWarnEnabled()) {
                            LOG.warn("Reactive response received an error after some data has already been written. This error cannot be forwarded to the client.", t);
                        }
                        this.maybeReportErrorDownstream((Throwable)new HttpStatusException(HttpStatus.INTERNAL_SERVER_ERROR, HttpStatus.INTERNAL_SERVER_ERROR.getReason() + ": " + t.getMessage()));
                    }
                    this.subscription.cancel();
                }
            }

            private void maybeReportErrorDownstream(Throwable t) {
                HttpStatusException httpStatusException = (HttpStatusException)t;
                DefaultServletHttpResponse.this.delegate.setStatus(httpStatusException.getStatus().getCode());
                if (!this.written) {
                    try {
                        String message = httpStatusException.getBody().orElse(httpStatusException.getMessage());
                        if (this.outputStream.isReady() && message instanceof CharSequence) {
                            this.outputStream.write(message.toString().getBytes(DefaultServletHttpResponse.this.getCharacterEncoding()));
                            this.flushIfReady();
                        } else if (this.outputStream.isReady()) {
                            this.writeToOutputStream(message);
                        }
                        this.finish();
                    }
                    catch (IOException e) {
                        emitter.error((Throwable)e);
                    }
                } else {
                    emitter.error(t);
                }
            }

            public void onComplete() {
                if (this.finished.compareAndSet(false, true)) {
                    try {
                        if (!this.raw && this.isJson && this.outputStream.isReady()) {
                            if (this.first) {
                                this.outputStream.write(EMPTY_ARRAY);
                            } else {
                                this.outputStream.write(93);
                            }
                            this.flushIfReady();
                        }
                        this.finish();
                    }
                    catch (IOException e) {
                        emitter.error((Throwable)e);
                    }
                }
            }

            private void finish() {
                emitter.next((Object)DefaultServletHttpResponse.this);
                emitter.complete();
            }
        }), (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.ERROR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<?> stream(CloseableByteBody body) {
        final CompletableFuture completion = new CompletableFuture();
        Subscriber<byte[]> subscriber = null;
        try {
            body.expectedLength().ifPresent(this.delegate::setContentLengthLong);
            subscriber = new Subscriber<byte[]>(){
                final ServletOutputStream outputStream;
                Subscription subscription;
                java.nio.ByteBuffer internalBuffer;
                {
                    this.outputStream = DefaultServletHttpResponse.this.delegate.getOutputStream();
                }

                public void onSubscribe(final Subscription s) {
                    this.subscription = s;
                    this.outputStream.setWriteListener(new WriteListener(){

                        public void onWritePossible() throws IOException {
                            if (internalBuffer == null) {
                                s.request(1L);
                            } else {
                                this.writeSome();
                            }
                        }

                        public void onError(Throwable t) {
                            this.handleError(t);
                        }
                    });
                }

                private void writeSome() throws IOException {
                    boolean outputReady;
                    boolean inputReady;
                    assert (this.internalBuffer != null);
                    do {
                        boolean writeBuffer;
                        if (writeBuffer = writeBufferAvailable) {
                            try {
                                this.outputStream.write(this.internalBuffer);
                            }
                            catch (NoSuchMethodError e) {
                                writeBuffer = false;
                                writeBufferAvailable = false;
                            }
                        }
                        if (!writeBuffer) {
                            this.outputStream.write(this.internalBuffer.array(), this.internalBuffer.arrayOffset() + this.internalBuffer.position(), this.internalBuffer.remaining());
                            this.internalBuffer.position(this.internalBuffer.limit());
                        }
                        inputReady = this.internalBuffer.hasRemaining();
                        outputReady = this.outputStream.isReady();
                    } while (inputReady && outputReady);
                    if (!inputReady) {
                        this.internalBuffer = null;
                        if (outputReady) {
                            this.subscription.request(1L);
                        }
                    }
                }

                public void onNext(byte[] bytes) {
                    if (this.internalBuffer != null) {
                        throw new IllegalStateException("Still have buffered data");
                    }
                    this.internalBuffer = java.nio.ByteBuffer.wrap(bytes);
                    try {
                        this.writeSome();
                    }
                    catch (IOException e) {
                        this.handleError(e);
                    }
                }

                public void onError(Throwable t) {
                    this.handleError(t);
                }

                private void handleError(Throwable t) {
                    completion.completeExceptionally(t);
                }

                public void onComplete() {
                    completion.complete(null);
                }
            };
        }
        catch (IOException e) {
            CompletableFuture completableFuture = CompletableFuture.failedFuture(e);
            return completableFuture;
        }
        finally {
            if (subscriber == null) {
                body.close();
            }
        }
        body.toByteArrayPublisher().subscribe((Subscriber)subscriber);
        return completion;
    }

    @NonNull
    public Optional<MediaType> getContentType() {
        return this.conversionService.convert((Object)this.delegate.getContentType(), Argument.of(MediaType.class));
    }

    public MutableHttpResponse<B> contentType(CharSequence contentType) {
        this.delegate.setContentType(Objects.requireNonNull(contentType, "Content type cannot be null").toString());
        return this;
    }

    public MutableHttpResponse<B> contentType(MediaType mediaType) {
        this.delegate.setContentType(Objects.requireNonNull(mediaType, "Content type cannot be null").toString());
        return this;
    }

    public MutableHttpResponse<B> contentLength(long length) {
        this.delegate.setContentLengthLong(length);
        return this;
    }

    public MutableHttpResponse<B> locale(Locale locale) {
        Objects.requireNonNull(locale, "Locale cannot be null");
        this.delegate.setLocale(locale);
        return this;
    }

    public MutableHttpResponse<B> header(CharSequence name, CharSequence value) {
        String headerName = Objects.requireNonNull(name, "Header name cannot be null").toString();
        String headerValue = Objects.requireNonNull(value, "Header value cannot be null").toString();
        this.delegate.addHeader(headerName, headerValue);
        return this;
    }

    public MutableHttpResponse<B> status(int status) {
        this.delegate.setStatus(status);
        return this;
    }

    public MutableHttpResponse<B> status(HttpStatus status) {
        return this.status(Objects.requireNonNull(status, "status cannot be null").getCode());
    }

    public HttpServletResponse getNativeResponse() {
        return this.delegate.getNativeResponse();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.delegate.getOutputStream();
    }

    public BufferedWriter getWriter() throws IOException {
        return new BufferedWriter(this.delegate.getWriter());
    }

    public MutableHttpResponse<B> cookie(Cookie cookie) {
        if (cookie instanceof ServletCookieAdapter) {
            ServletCookieAdapter servletCookieAdapter = (ServletCookieAdapter)cookie;
            this.delegate.addCookie(servletCookieAdapter.getCookie());
        } else {
            String path;
            jakarta.servlet.http.Cookie c = new jakarta.servlet.http.Cookie(cookie.getName(), cookie.getValue());
            String domain = cookie.getDomain();
            if (domain != null) {
                c.setDomain(domain);
            }
            if ((path = cookie.getPath()) != null) {
                c.setPath(path);
            }
            c.setSecure(cookie.isSecure());
            c.setHttpOnly(cookie.isHttpOnly());
            c.setMaxAge((int)cookie.getMaxAge());
            this.delegate.addCookie(c);
        }
        return this;
    }

    @NonNull
    public MutableHttpHeaders getHeaders() {
        return this.headers;
    }

    @NonNull
    public MutableConvertibleValues<Object> getAttributes() {
        return this.attributes;
    }

    @NonNull
    public Optional<B> getBody() {
        return Optional.ofNullable(this.body);
    }

    public <T> MutableHttpResponse<T> body(@Nullable T body) {
        if (body instanceof HttpResponseProvider) {
            HttpResponseProvider responseProvider = (HttpResponseProvider)body;
            HttpResponse response = responseProvider.getResponse();
            if (response != this && response.body() != null) {
                this.body((T)response.body());
            }
        } else {
            if (body != null) {
                this.getContentType().orElseGet(() -> {
                    Object[] v;
                    Produces ann = body.getClass().getAnnotation(Produces.class);
                    if (ann != null && ArrayUtils.isNotEmpty((Object[])(v = ann.value()))) {
                        MediaType mediaType = new MediaType((String)v[0]);
                        this.contentType(mediaType);
                        return mediaType;
                    }
                    return null;
                });
            }
            this.body = body;
        }
        return this;
    }

    public MutableHttpResponse<B> status(int status, CharSequence message) {
        this.reason = message == null ? HttpStatus.getDefaultReason((int)status) : message.toString();
        if (!this.delegate.isCommitted()) {
            this.delegate.setStatus(status);
        }
        return this;
    }

    public int code() {
        return this.delegate.getStatus();
    }

    public String reason() {
        if (this.reason != null) {
            return this.reason;
        }
        try {
            return HttpStatus.valueOf((int)this.delegate.getStatus()).getReason();
        }
        catch (Exception e) {
            return "";
        }
    }

    private static final class ServletResponseHeaders
    implements MutableHttpHeaders {
        private final HttpServletResponse delegate;
        private final ConversionService conversionService;

        private ServletResponseHeaders(HttpServletResponse delegate, ConversionService conversionService) {
            this.delegate = delegate;
            this.conversionService = conversionService;
        }

        private static boolean isBanned(String name) {
            return name.equalsIgnoreCase("Transfer-Encoding") || name.equalsIgnoreCase("Content-Length");
        }

        public MutableHeaders set(CharSequence header, CharSequence value) {
            String headerName = Objects.requireNonNull(header, "Header name cannot be null").toString();
            String headerValue = Objects.requireNonNull(value, "Header value cannot be null").toString();
            if (ServletResponseHeaders.isBanned(headerName)) {
                return this;
            }
            this.delegate.setHeader(headerName, headerValue);
            return this;
        }

        public MutableHttpHeaders add(CharSequence header, CharSequence value) {
            String headerName = Objects.requireNonNull(header, "Header name cannot be null").toString();
            String headerValue = Objects.requireNonNull(value, "Header value cannot be null").toString();
            if (ServletResponseHeaders.isBanned(headerName)) {
                return this;
            }
            this.delegate.addHeader(headerName, headerValue);
            return this;
        }

        public MutableHttpHeaders remove(CharSequence header) {
            String headerName = Objects.requireNonNull(header, "Header name cannot be null").toString();
            if (this.delegate.containsHeader(headerName)) {
                this.delegate.setHeader(headerName, "");
            }
            return this;
        }

        public List<String> getAll(CharSequence name) {
            Collection values = this.delegate.getHeaders(Objects.requireNonNull(name, "Header name cannot be null").toString());
            if (values instanceof List) {
                return (List)values;
            }
            return new ArrayList<String>(values);
        }

        @Nullable
        public String get(CharSequence name) {
            return this.delegate.getHeader(Objects.requireNonNull(name, "Header name cannot be null").toString());
        }

        public Set<String> names() {
            Collection headerNames = this.delegate.getHeaderNames();
            if (headerNames instanceof Set) {
                return (Set)headerNames;
            }
            return new HashSet<String>(headerNames);
        }

        public Collection<List<String>> values() {
            return this.names().stream().map(this::getAll).collect(Collectors.toList());
        }

        public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
            String v = this.get(name);
            if (v != null) {
                return this.conversionService.convert((Object)v, conversionContext);
            }
            return Optional.empty();
        }

        public void setConversionService(ConversionService conversionService) {
        }
    }

    private record DelegateResponseMetadata(HttpServletResponse delegate) implements ResponseMetadata
    {
        @Override
        public HttpServletResponse getNativeResponse() {
            return this.delegate;
        }

        @Override
        public ServletOutputStream getOutputStream() throws IOException {
            return this.delegate.getOutputStream();
        }

        @Override
        public Writer getWriter() throws IOException {
            return this.delegate.getWriter();
        }

        @Override
        public boolean containsHeader(String k) {
            return this.delegate.containsHeader(k);
        }

        @Override
        public String getHeader(String k) {
            return this.delegate.getHeader(k);
        }

        @Override
        public Collection<String> getHeaderNames() {
            return this.delegate.getHeaderNames();
        }

        @Override
        public Collection<String> getHeaders(String k) {
            return this.delegate.getHeaders(k);
        }

        @Override
        public void setHeader(String k, String v) {
            this.delegate.setHeader(k, v);
        }

        @Override
        public void addHeader(String k, String v) {
            this.delegate.addHeader(k, v);
        }

        @Override
        public boolean isCommitted() {
            return this.delegate.isCommitted();
        }

        @Override
        public int getStatus() {
            return this.delegate.getStatus();
        }

        @Override
        public void setStatus(int code) {
            this.delegate.setStatus(code);
        }

        @Override
        public void setContentLengthLong(long l) {
            this.delegate.setContentLengthLong(l);
        }

        @Override
        public String getContentType() {
            return this.delegate.getContentType();
        }

        @Override
        public void setContentType(String contentType) {
            this.delegate.setContentType(contentType);
        }

        @Override
        public void setLocale(Locale locale) {
            this.delegate.setLocale(locale);
        }

        @Override
        public void addCookie(jakarta.servlet.http.Cookie cookie) {
            this.delegate.addCookie(cookie);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static interface ResponseMetadata {
        public HttpServletResponse getNativeResponse();

        public ServletOutputStream getOutputStream() throws IOException;

        public Writer getWriter() throws IOException;

        public Collection<String> getHeaders(String var1);

        public Collection<String> getHeaderNames();

        @Nullable
        public String getHeader(String var1);

        public void setHeader(String var1, String var2);

        public void addHeader(String var1, String var2);

        public boolean containsHeader(String var1);

        public boolean isCommitted();

        public int getStatus();

        public void setStatus(int var1);

        public void setContentLengthLong(long var1);

        public String getContentType();

        public void setContentType(String var1);

        public void setLocale(Locale var1);

        public void addCookie(jakarta.servlet.http.Cookie var1);
    }

    private final class LocalResponseMetadata
    implements ResponseMetadata {
        private int code;
        private final MutableHttpHeaders headers;

        LocalResponseMetadata() {
            this.headers = new SimpleHttpHeaders(DefaultServletHttpResponse.this.conversionService);
            for (String k : this.getHeaderNames()) {
                for (String v : this.getHeaders(k)) {
                    this.headers.add((CharSequence)k, (CharSequence)v);
                }
            }
            this.code = DefaultServletHttpResponse.this.delegate.getStatus();
        }

        private static IllegalStateException unsupported() {
            return new IllegalStateException("Another response was created for this request");
        }

        @Override
        public HttpServletResponse getNativeResponse() {
            throw LocalResponseMetadata.unsupported();
        }

        @Override
        public ServletOutputStream getOutputStream() throws IOException {
            throw LocalResponseMetadata.unsupported();
        }

        @Override
        public Writer getWriter() throws IOException {
            throw LocalResponseMetadata.unsupported();
        }

        @Override
        public Collection<String> getHeaders(String k) {
            return this.headers.getAll((CharSequence)k);
        }

        @Override
        public Collection<String> getHeaderNames() {
            return this.headers.names();
        }

        @Override
        public String getHeader(String k) {
            return (String)this.headers.get((CharSequence)k);
        }

        @Override
        public void setHeader(String k, String v) {
            this.headers.set((CharSequence)k, (CharSequence)v);
        }

        @Override
        public void addHeader(String k, String v) {
            this.headers.add((CharSequence)k, (CharSequence)v);
        }

        @Override
        public boolean containsHeader(String k) {
            return this.headers.contains(k);
        }

        @Override
        public boolean isCommitted() {
            return false;
        }

        @Override
        public int getStatus() {
            return this.code;
        }

        @Override
        public void setStatus(int code) {
            this.code = code;
        }

        @Override
        public void setContentLengthLong(long l) {
            this.setHeader("Content-Length", String.valueOf(l));
        }

        @Override
        public String getContentType() {
            return this.headers.getContentType().orElse(null);
        }

        @Override
        public void setContentType(String contentType) {
            this.setHeader("Content-Type", contentType);
        }

        @Override
        public void setLocale(Locale locale) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addCookie(jakarta.servlet.http.Cookie cookie) {
            throw new UnsupportedOperationException();
        }
    }
}

