/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.engine;

import io.micronaut.core.util.functional.ThrowingSupplier;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ServletStreamPublisher
implements Publisher<ByteBuffer>,
Subscription,
ReadListener {
    private static final Logger LOG = LoggerFactory.getLogger(ServletStreamPublisher.class);
    private final Queue<Runnable> tasks = new ConcurrentLinkedQueue<Runnable>();
    private final AtomicReference<WorkState> state = new AtomicReference<WorkState>(WorkState.IDLE);
    private final ThrowingSupplier<ServletInputStream, IOException> upstreamSupplier;
    private ServletInputStream upstream;
    private long demand;
    private boolean upstreamListenerRegistered;
    private boolean upstreamReady;
    private boolean upstreamDone;
    private boolean downstreamDone;
    private Throwable error;
    private Subscriber<? super ByteBuffer> downstream;

    ServletStreamPublisher(ThrowingSupplier<ServletInputStream, IOException> upstreamSupplier) {
        this.upstreamSupplier = upstreamSupplier;
    }

    private void submit(Runnable r) {
        this.tasks.add(r);
        WorkState oldState = this.state.getAndUpdate(w -> w == WorkState.IDLE ? WorkState.WORKING : WorkState.WORKING_PENDING_TASKS);
        if (oldState != WorkState.IDLE) {
            return;
        }
        while (true) {
            Runnable task;
            if ((task = this.tasks.poll()) != null) {
                task.run();
                continue;
            }
            if (this.state.updateAndGet(w -> w == WorkState.WORKING ? WorkState.IDLE : WorkState.WORKING) == WorkState.IDLE) break;
        }
    }

    public void subscribe(Subscriber<? super ByteBuffer> s) {
        this.downstream = s;
        this.submit(() -> s.onSubscribe((Subscription)this));
    }

    public void request(long n) {
        this.submit(() -> {
            long oldDemand = this.demand;
            long l = this.demand = oldDemand + n < oldDemand ? Long.MAX_VALUE : oldDemand + n;
            if (!this.upstreamListenerRegistered) {
                this.upstreamListenerRegistered = true;
                try {
                    this.upstream = (ServletInputStream)this.upstreamSupplier.get();
                    this.upstream.setReadListener((ReadListener)this);
                }
                catch (IOException e) {
                    this.onError(e);
                }
            } else {
                this.forwardSome();
            }
        });
    }

    private void forwardSome() {
        while (!this.downstreamDone && this.demand > 0L && (this.upstreamReady || this.upstreamDone)) {
            if (!this.upstreamDone) {
                try {
                    byte[] arr = new byte[4096];
                    int n = this.upstream.read(arr);
                    if (n == -1) {
                        this.upstreamDone = true;
                    } else {
                        --this.demand;
                        this.downstream.onNext((Object)ByteBuffer.wrap(arr, 0, n));
                        this.upstreamReady = this.upstream.isReady();
                    }
                }
                catch (IOException e) {
                    this.error = e;
                    this.upstreamDone = true;
                }
            }
            if (!this.upstreamDone) continue;
            this.downstreamDone = true;
            if (this.error != null) {
                this.downstream.onError(this.error);
                continue;
            }
            this.downstream.onComplete();
        }
    }

    public void cancel() {
        this.submit(() -> {
            if (this.upstream != null) {
                try {
                    this.upstream.close();
                }
                catch (IOException e) {
                    LOG.debug("Failed to close request body for cancellation", (Throwable)e);
                }
            }
            this.downstreamDone = true;
        });
    }

    public void onDataAvailable() {
        this.submit(() -> {
            this.upstreamReady = this.upstream.isReady();
            this.forwardSome();
        });
    }

    public void onAllDataRead() {
        this.submit(() -> {
            this.upstreamDone = true;
            this.forwardSome();
        });
    }

    public void onError(Throwable t) {
        this.submit(() -> {
            this.error = t;
            this.upstreamDone = true;
            this.forwardSome();
        });
    }

    private static enum WorkState {
        IDLE,
        WORKING,
        WORKING_PENDING_TASKS;

    }
}

