/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.engine.initializer;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanIdentifier;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.servlet.engine.MicronautServletConfiguration;
import jakarta.inject.Inject;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.ServletSecurityElement;
import jakarta.servlet.annotation.MultipartConfig;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.annotation.WebInitParam;
import jakarta.servlet.annotation.WebListener;
import jakarta.servlet.annotation.WebServlet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Prototype
public class MicronautServletInitializer
implements ServletContainerInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(MicronautServletInitializer.class);
    private static final AnnotationValue<WebServlet> EMPTY_WEB_SERVLET = new AnnotationValue(WebServlet.class.getName());
    private static final String MEMBER_URL_PATTERNS = "urlPatterns";
    private static final String MEMBER_LOAD_ON_STARTUP = "loadOnStartup";
    private static final String MEMBER_ASYNC_SUPPORTED = "asyncSupported";
    private static final String MEMBER_INIT_PARAMS = "initParams";
    private static final DispatcherType[] DEFAULT_DISPATCHER_TYPES = new DispatcherType[]{DispatcherType.REQUEST};
    private ApplicationContext applicationContext;
    private List<String> micronautServletMappings = new ArrayList<String>();

    @Inject
    public MicronautServletInitializer(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public MicronautServletInitializer() {
    }

    public void onStartup(Set<Class<?>> c, ServletContext ctx) {
        ApplicationContext applicationContext = this.applicationContext != null ? this.applicationContext : this.buildApplicationContext(ctx).build().start();
        MicronautServletConfiguration configuration = (MicronautServletConfiguration)applicationContext.getBean(MicronautServletConfiguration.class);
        Collection servlets = applicationContext.getBeanRegistrations(Servlet.class);
        Collection filters = applicationContext.getBeanRegistrations(Filter.class);
        Collection servletListeners = applicationContext.getBeansOfType(EventListener.class, Qualifiers.byStereotype(WebListener.class));
        int servletOrder = 0;
        for (BeanRegistration servlet : servlets) {
            Servlet servletBean = (Servlet)servlet.getBean();
            String servletName = MicronautServletInitializer.resolveName(servlet.getIdentifier(), servlet.getBeanDefinition());
            ServletRegistration.Dynamic registration = ctx.addServlet(servletName, servletBean);
            servletOrder = this.configureServletBean((BeanRegistration<Servlet>)servlet, servletName, configuration, servletOrder, registration, applicationContext);
        }
        for (BeanRegistration beanRegistration : filters) {
            MicronautServletInitializer.handleFilterRegistration(ctx, (BeanRegistration<Filter>)beanRegistration);
        }
        for (EventListener servletListener : servletListeners) {
            ctx.addListener(servletListener);
        }
    }

    private static void handleFilterRegistration(ServletContext ctx, BeanRegistration<Filter> beanRegistration) {
        Filter filter = (Filter)beanRegistration.getBean();
        BeanIdentifier identifier = beanRegistration.getIdentifier();
        BeanDefinition beanDefinition = beanRegistration.getBeanDefinition();
        String filterName = MicronautServletInitializer.resolveName(identifier, beanDefinition);
        FilterRegistration.Dynamic registration = ctx.addFilter(filterName, filter);
        AnnotationValue webFilterAnn = beanDefinition.findAnnotation(WebFilter.class).orElse(new AnnotationValue(WebFilter.class.getName()));
        Object[] dispatcherTypes = (DispatcherType[])webFilterAnn.enumValues("dispatcherTypes", DispatcherType.class);
        if (ArrayUtils.isEmpty((Object[])dispatcherTypes)) {
            dispatcherTypes = DEFAULT_DISPATCHER_TYPES;
        }
        @NonNull Object[] urlPatterns = (String[])ArrayUtils.concat((Object[])webFilterAnn.stringValues(), (Object[])webFilterAnn.stringValues(MEMBER_URL_PATTERNS));
        @NonNull Object[] servletNames = webFilterAnn.stringValues("servletNames");
        EnumSet<Object> enumSet = dispatcherTypes.length > 1 ? EnumSet.of(dispatcherTypes[0], (DispatcherType[])Arrays.copyOfRange(dispatcherTypes, 1, dispatcherTypes.length)) : EnumSet.of(dispatcherTypes[0]);
        if (ArrayUtils.isNotEmpty((Object[])urlPatterns)) {
            registration.addMappingForUrlPatterns(enumSet, true, (String[])urlPatterns);
        }
        if (ArrayUtils.isNotEmpty((Object[])servletNames)) {
            registration.addMappingForUrlPatterns(enumSet, true, (String[])servletNames);
        }
        MicronautServletInitializer.setInitParams((AnnotationValue<WebFilter>)webFilterAnn, registration);
        registration.setAsyncSupported(webFilterAnn.booleanValue(MEMBER_ASYNC_SUPPORTED).orElse(false).booleanValue());
    }

    private static String resolveName(BeanIdentifier identifier, BeanDefinition<?> definition) {
        String name = identifier.getName();
        return name.equals("Primary") ? definition.getBeanType().getName() : name;
    }

    private int configureServletBean(BeanRegistration<Servlet> servlet, String servletName, MicronautServletConfiguration configuration, int order, ServletRegistration.Dynamic registration, ApplicationContext applicationContext) {
        ServletSecurity servletSecurity;
        BeanDefinition beanDefinition = servlet.getBeanDefinition();
        AnnotationValue<WebServlet> webServletAnnotationValue = beanDefinition.findAnnotation(WebServlet.class).orElse(EMPTY_WEB_SERVLET);
        boolean isMicronautServlet = "micronaut".equals(servletName);
        @NonNull String[] urlPatterns = this.getUrlPatterns(webServletAnnotationValue, (BeanDefinition<Servlet>)beanDefinition, isMicronautServlet, configuration);
        int loadOnStartup = webServletAnnotationValue.intValue(MEMBER_LOAD_ON_STARTUP).orElse(order++);
        boolean isAsyncSupported = webServletAnnotationValue.booleanValue(MEMBER_ASYNC_SUPPORTED).orElse(configuration.isAsyncSupported());
        registration.addMapping(urlPatterns);
        registration.setLoadOnStartup(loadOnStartup);
        registration.setAsyncSupported(isAsyncSupported);
        MicronautServletInitializer.setInitParams(webServletAnnotationValue, registration);
        MultipartConfigElement multipartConfigElement = this.getMultipartConfig((BeanDefinition<Servlet>)beanDefinition, isMicronautServlet, configuration);
        if (multipartConfigElement != null) {
            registration.setMultipartConfig(multipartConfigElement);
        }
        if ((servletSecurity = (ServletSecurity)beanDefinition.synthesizeDeclared(ServletSecurity.class)) != null) {
            registration.setServletSecurity(new ServletSecurityElement(servletSecurity));
        } else if (isMicronautServlet) {
            applicationContext.findBean(ServletSecurityElement.class).ifPresent(arg_0 -> ((ServletRegistration.Dynamic)registration).setServletSecurity(arg_0));
        }
        return order;
    }

    @NonNull
    private String[] getUrlPatterns(AnnotationValue<WebServlet> webServletAnnotationValue, BeanDefinition<Servlet> beanDefinition, boolean isMicronautServlet, MicronautServletConfiguration configuration) {
        @NonNull Object[] urlPatterns = (String[])ArrayUtils.concat((Object[])webServletAnnotationValue.stringValues(), (Object[])beanDefinition.stringValues(MEMBER_URL_PATTERNS));
        if (ArrayUtils.isEmpty((Object[])urlPatterns) && isMicronautServlet) {
            urlPatterns = (String[])ArrayUtils.concat((Object[])((String[])this.micronautServletMappings.toArray(String[]::new)), (Object[])new String[]{configuration.getMapping()});
        }
        return urlPatterns;
    }

    private static void setInitParams(AnnotationValue<WebServlet> webServletAnnotationValue, ServletRegistration.Dynamic registration) {
        webServletAnnotationValue.getAnnotations(MEMBER_INIT_PARAMS, WebInitParam.class).forEach(av -> av.stringValue("name").ifPresent(name -> av.stringValue().ifPresent(value -> registration.setInitParameter(name, value))));
    }

    private static void setInitParams(AnnotationValue<WebFilter> webFilter, FilterRegistration.Dynamic registration) {
        webFilter.getAnnotations(MEMBER_INIT_PARAMS, WebInitParam.class).forEach(av -> av.stringValue("name").ifPresent(name -> av.stringValue().ifPresent(value -> registration.setInitParameter(name, value))));
    }

    private MultipartConfigElement getMultipartConfig(BeanDefinition<Servlet> beanDefinition, boolean isMicronautServlet, MicronautServletConfiguration configuration) {
        return beanDefinition.findAnnotation(MultipartConfig.class).map(this::toMultipartElement).orElse(isMicronautServlet ? (MultipartConfigElement)configuration.getMultipartConfigElement().orElse(null) : null);
    }

    private MultipartConfigElement toMultipartElement(AnnotationValue<MultipartConfig> annotation) {
        String location = annotation.stringValue("location").orElse("");
        long maxFileSize = annotation.longValue("maxFileSize").orElse(-1L);
        long maxRequestSize = annotation.longValue("maxRequestSize").orElse(-1L);
        int fileSizeThreshold = annotation.intValue("fileSizeThreshold").orElse(-1);
        return new MultipartConfigElement(location, maxFileSize, maxRequestSize, fileSizeThreshold);
    }

    protected ApplicationContextBuilder buildApplicationContext(ServletContext ctx) {
        ApplicationContextBuilder contextBuilder = ApplicationContext.builder().classLoader(ctx.getClassLoader()).singletons(new Object[]{ctx});
        String servletContextPath = ctx.getContextPath();
        if (StringUtils.isNotEmpty((CharSequence)servletContextPath)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting micronaut context-path to match servlet context path: '{}'", (Object)servletContextPath);
            }
            contextBuilder.properties(Map.of("micronaut.server.context-path", servletContextPath));
        }
        return contextBuilder;
    }

    public void addMicronautServletMapping(String mapping) {
        if (StringUtils.isNotEmpty((CharSequence)mapping)) {
            this.micronautServletMappings.add(mapping);
        }
    }
}

