/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.annotation.processor;

import io.micronaut.core.util.ArrayUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.processing.ProcessingException;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.annotation.WebListener;
import jakarta.servlet.annotation.WebServlet;
import java.util.EventListener;
import java.util.Set;

public class ServletAnnotationVisitor
implements TypeElementVisitor<Object, Object> {
    public TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    public Set<String> getSupportedAnnotationNames() {
        return Set.of("jakarta.servlet.*");
    }

    public void visitClass(ClassElement element, VisitorContext context) {
        String[] patterns;
        if (element.hasDeclaredAnnotation(WebFilter.class) && !element.isAssignable(Filter.class)) {
            throw new ProcessingException((Element)element, "Types annotated with @WebFilter must implement jakarta.servlet.Filter");
        }
        if (element.hasDeclaredAnnotation(WebServlet.class) && !element.isAssignable(Servlet.class)) {
            throw new ProcessingException((Element)element, "Types annotated with @WebServlet must implement jakarta.servlet.Servlet");
        }
        if (element.hasDeclaredAnnotation(WebListener.class) && !element.isAssignable(EventListener.class)) {
            throw new ProcessingException((Element)element, "Types annotated with @WebListener must implement java.util.EventListener");
        }
        for (String pattern : patterns = (String[])ArrayUtils.concat((Object[])((String[])ArrayUtils.concat((Object[])element.stringValues(WebFilter.class), (Object[])element.stringValues(WebServlet.class, "urlPatterns"))), (Object[])((String[])ArrayUtils.concat((Object[])element.stringValues(WebServlet.class), (Object[])element.stringValues(WebServlet.class, "urlPatterns"))))) {
            if (!pattern.endsWith("/**") || pattern.length() <= 3) continue;
            throw new ProcessingException((Element)element, "Servlet Spec 12.2 violation: glob '*' can only exist at end of prefix based matches: bad spec \"" + pattern + "\"");
        }
    }

    public void visitMethod(MethodElement element, VisitorContext context) {
        if (element.hasDeclaredAnnotation(WebFilter.class) && !element.getGenericReturnType().isAssignable(Filter.class)) {
            throw new ProcessingException((Element)element, "Methods annotated with @ServletFilterBean must implement jakarta.servlet.Filter");
        }
        if (element.hasDeclaredAnnotation(WebServlet.class) && !element.getGenericReturnType().isAssignable(Servlet.class)) {
            throw new ProcessingException((Element)element, "Methods annotated with @ServletBean must implement jakarta.servlet.Servlet");
        }
    }
}

