/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.annotation.processor;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.annotation.TypedAnnotationMapper;
import io.micronaut.inject.visitor.VisitorContext;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import jakarta.servlet.annotation.WebServlet;
import java.util.List;

public class WebServletMapper
implements TypedAnnotationMapper<WebServlet> {
    public Class<WebServlet> annotationType() {
        return WebServlet.class;
    }

    public List<AnnotationValue<?>> map(AnnotationValue<WebServlet> annotation, VisitorContext visitorContext) {
        String name = annotation.stringValue("name").orElse(null);
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            return List.of(AnnotationValue.builder(Named.class).value(name).build(), AnnotationValue.builder(Singleton.class).build());
        }
        return List.of(AnnotationValue.builder(Singleton.class).build());
    }
}

