/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.session.http;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.http.filter.FilterPatternStyle;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.filter.ServerFilterPhase;
import io.micronaut.http.server.exceptions.InternalServerException;
import io.micronaut.inject.MethodExecutionHandle;
import io.micronaut.session.Session;
import io.micronaut.session.SessionStore;
import io.micronaut.session.annotation.SessionValue;
import io.micronaut.session.http.HttpSessionIdEncoder;
import io.micronaut.session.http.HttpSessionIdResolver;
import java.util.List;
import java.util.Optional;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Requires(property="micronaut.session.filter.enabled", notEquals="false", defaultValue="true")
@Filter(patternStyle=FilterPatternStyle.REGEX, value={"${micronaut.session.filter.regex-pattern:^.*$}"})
public class HttpSessionFilter
implements HttpServerFilter {
    public static final Integer ORDER = ServerFilterPhase.SESSION.order();
    public static final CharSequence SESSION_ATTRIBUTE = "micronaut.SESSION";
    private final SessionStore<Session> sessionStore;
    private final HttpSessionIdResolver[] resolvers;
    private final HttpSessionIdEncoder[] encoders;

    public HttpSessionFilter(SessionStore<Session> sessionStore, HttpSessionIdResolver[] resolvers, HttpSessionIdEncoder[] encoders) {
        this.sessionStore = sessionStore;
        this.resolvers = resolvers;
        this.encoders = encoders;
    }

    public int getOrder() {
        return ORDER;
    }

    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        request.setAttribute((CharSequence)HttpSessionFilter.class.getName(), (Object)true);
        try {
            for (HttpSessionIdResolver resolver : this.resolvers) {
                List<String> ids = resolver.resolveIds(request);
                if (!CollectionUtils.isNotEmpty(ids)) continue;
                String id = ids.get(0);
                Publisher sessionLookup = Publishers.fromCompletableFuture(() -> this.sessionStore.findSession(id));
                Flux storeSessionInAttributes = Flux.from((Publisher)sessionLookup).switchMap(session -> {
                    session.ifPresent(entries -> request.getAttributes().put(SESSION_ATTRIBUTE, entries));
                    return chain.proceed(request);
                });
                return this.encodeSessionId(request, (Publisher<MutableHttpResponse<?>>)storeSessionInAttributes);
            }
        }
        catch (IllegalArgumentException e) {
            return Flux.error((Throwable)new HttpStatusException(HttpStatus.BAD_REQUEST, e.getMessage()));
        }
        return this.encodeSessionId(request, chain.proceed(request));
    }

    private Publisher<MutableHttpResponse<?>> encodeSessionId(HttpRequest<?> request, Publisher<MutableHttpResponse<?>> responsePublisher) {
        Flux responseFlowable = Flux.from(responsePublisher).switchMap(response -> {
            Optional routeMatch = request.getAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, MethodExecutionHandle.class);
            Optional body = response.getBody();
            String sessionAttr = body.isPresent() ? (String)routeMatch.flatMap(m -> {
                if (!m.hasAnnotation(SessionValue.class)) {
                    return Optional.empty();
                }
                String attributeName = m.stringValue(SessionValue.class).orElse(null);
                if (!StringUtils.isEmpty((CharSequence)attributeName)) {
                    return Optional.of(attributeName);
                }
                throw new InternalServerException("@SessionValue on a return type must specify an attribute name");
            }).orElse(null) : null;
            Optional opt = request.getAttributes().get(SESSION_ATTRIBUTE, Session.class);
            if (opt.isPresent()) {
                Session session = (Session)opt.get();
                if (sessionAttr != null) {
                    session.put(sessionAttr, body.get());
                }
                if (session.isNew() || session.isModified()) {
                    return Flux.from((Publisher)Publishers.fromCompletableFuture(() -> this.sessionStore.save(session))).map(s -> new SessionAndResponse(Optional.of(s), (MutableHttpResponse<?>)response));
                }
            } else if (sessionAttr != null) {
                Session newSession = this.sessionStore.newSession();
                newSession.put(sessionAttr, body.get());
                return Flux.from((Publisher)Publishers.fromCompletableFuture(() -> this.sessionStore.save(newSession))).map(s -> new SessionAndResponse(Optional.of(s), (MutableHttpResponse<?>)response));
            }
            return Flux.just((Object)new SessionAndResponse(opt, (MutableHttpResponse<?>)response));
        });
        return responseFlowable.map(sessionAndResponse -> {
            Optional<Session> session = sessionAndResponse.session;
            MutableHttpResponse<?> response = sessionAndResponse.response;
            if (session.isPresent()) {
                Session s = session.get();
                for (HttpSessionIdEncoder encoder : this.encoders) {
                    encoder.encodeId(request, response, s);
                }
            }
            return response;
        });
    }

    class SessionAndResponse {
        final Optional<Session> session;
        final MutableHttpResponse<?> response;

        SessionAndResponse(Optional<Session> session, MutableHttpResponse<?> response) {
            this.session = session;
            this.response = response;
        }
    }
}

