/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.bytecode.expression;

import io.micronaut.inject.ast.ClassElement;
import io.micronaut.sourcegen.bytecode.MethodContext;
import io.micronaut.sourcegen.bytecode.TypeUtils;
import io.micronaut.sourcegen.bytecode.expression.ExpressionWriter;
import io.micronaut.sourcegen.model.ClassDef;
import io.micronaut.sourcegen.model.ClassTypeDef;
import io.micronaut.sourcegen.model.EnumDef;
import io.micronaut.sourcegen.model.ExpressionDef;
import io.micronaut.sourcegen.model.ObjectDef;
import io.micronaut.sourcegen.model.RecordDef;
import io.micronaut.sourcegen.model.TypeDef;
import org.objectweb.asm.commons.GeneratorAdapter;

final class CastExpressionWriter
implements ExpressionWriter {
    private final ExpressionDef.Cast castExpressionDef;

    public CastExpressionWriter(ExpressionDef.Cast castExpressionDef) {
        this.castExpressionDef = castExpressionDef;
    }

    @Override
    public void write(GeneratorAdapter generatorAdapter, MethodContext context) {
        ExpressionDef.Constant constant;
        ExpressionDef exp = this.castExpressionDef.expressionDef();
        if (!exp.type().isPrimitive()) {
            while (exp instanceof ExpressionDef.Cast) {
                ExpressionDef.Cast cast = (ExpressionDef.Cast)exp;
                exp = cast.expressionDef();
            }
        }
        ExpressionWriter.writeExpression(generatorAdapter, context, exp);
        if (exp instanceof ExpressionDef.Constant && (constant = (ExpressionDef.Constant)exp).value() == null) {
            return;
        }
        CastExpressionWriter.cast(generatorAdapter, context, exp.type(), this.castExpressionDef.type());
    }

    private static void cast(GeneratorAdapter generatorAdapter, MethodContext context, TypeDef from, TypeDef to) {
        from = ObjectDef.getContextualType((ObjectDef)context.objectDef(), (TypeDef)from);
        to = ObjectDef.getContextualType((ObjectDef)context.objectDef(), (TypeDef)to);
        if (from instanceof TypeDef.Primitive) {
            TypeDef.Primitive fromP = (TypeDef.Primitive)from;
            if (to instanceof TypeDef.Primitive) {
                TypeDef.Primitive toP = (TypeDef.Primitive)to;
                if (!from.equals(to)) {
                    generatorAdapter.cast(TypeUtils.getType(fromP), TypeUtils.getType(toP));
                    return;
                }
            }
        }
        if ((from.isPrimitive() || to.isPrimitive()) && !from.equals(to)) {
            if (from instanceof TypeDef.Primitive) {
                TypeDef.Primitive primitive = (TypeDef.Primitive)from;
                if (!to.isPrimitive()) {
                    CastExpressionWriter.box(generatorAdapter, context, from);
                    CastExpressionWriter.checkCast(generatorAdapter, context, (TypeDef)primitive.wrapperType(), to);
                }
            }
            if (!from.isPrimitive() && to.isPrimitive()) {
                CastExpressionWriter.unbox(generatorAdapter, context, to);
            }
        } else if (CastExpressionWriter.needsCast(from, to)) {
            CastExpressionWriter.checkCast(generatorAdapter, context, from, to);
        }
    }

    private static boolean needsCast(TypeDef from, TypeDef to) {
        ClassTypeDef.ClassDefType fromClassDef;
        ClassTypeDef fromSuperclass;
        if (from.makeNullable().equals(to.makeNullable())) {
            return false;
        }
        if (from instanceof ClassTypeDef.Parameterized) {
            ClassTypeDef.Parameterized parameterized = (ClassTypeDef.Parameterized)from;
            return CastExpressionWriter.needsCast((TypeDef)parameterized.rawType(), to);
        }
        if (to instanceof ClassTypeDef.Parameterized) {
            ClassTypeDef.Parameterized parameterized = (ClassTypeDef.Parameterized)to;
            return CastExpressionWriter.needsCast(from, (TypeDef)parameterized.rawType());
        }
        if (from instanceof ClassTypeDef.ClassElementType) {
            ClassTypeDef.ClassElementType fromElement = (ClassTypeDef.ClassElementType)from;
            return CastExpressionWriter.needsCast(fromElement.classElement(), to);
        }
        if (from instanceof ClassTypeDef.JavaClass) {
            ClassTypeDef.JavaClass fromClass = (ClassTypeDef.JavaClass)from;
            if (to instanceof ClassTypeDef.JavaClass) {
                ClassTypeDef.JavaClass toClass = (ClassTypeDef.JavaClass)to;
                return !toClass.type().isAssignableFrom(fromClass.type());
            }
        }
        if (from instanceof ClassTypeDef.ClassDefType && (fromSuperclass = CastExpressionWriter.getSuperclass((fromClassDef = (ClassTypeDef.ClassDefType)from).objectDef())) != null) {
            return CastExpressionWriter.needsCast((TypeDef)fromSuperclass, to);
        }
        return true;
    }

    private static boolean needsCast(ClassElement from, TypeDef to) {
        if (to instanceof ClassTypeDef.ClassElementType) {
            ClassTypeDef.ClassElementType toElement = (ClassTypeDef.ClassElementType)to;
            return !from.isAssignable(toElement.classElement());
        }
        if (to instanceof ClassTypeDef.JavaClass) {
            ClassTypeDef.JavaClass toClass = (ClassTypeDef.JavaClass)to;
            return !from.isAssignable(toClass.type());
        }
        if (to instanceof ClassTypeDef.ClassName) {
            ClassTypeDef.ClassName toClassName = (ClassTypeDef.ClassName)to;
            return !from.isAssignable(toClassName.name());
        }
        if (to instanceof ClassTypeDef.ClassDefType) {
            ClassTypeDef.ClassDefType toClassDefType = (ClassTypeDef.ClassDefType)to;
            if (from.isAssignable(toClassDefType.getName())) {
                return false;
            }
            return !from.isAssignable(toClassDefType.getName());
        }
        return true;
    }

    private static ClassTypeDef getSuperclass(ObjectDef objectDef) {
        if (objectDef instanceof ClassDef) {
            ClassDef classDef = (ClassDef)objectDef;
            return classDef.getSuperclass();
        }
        if (objectDef instanceof EnumDef) {
            return ClassTypeDef.of(Enum.class);
        }
        if (objectDef instanceof RecordDef) {
            return ClassTypeDef.of(Record.class);
        }
        return null;
    }

    private static void checkCast(GeneratorAdapter generatorAdapter, MethodContext context, TypeDef from, TypeDef to) {
        TypeDef toType = ObjectDef.getContextualType((ObjectDef)context.objectDef(), (TypeDef)to);
        if (!toType.makeNullable().equals(from.makeNullable())) {
            generatorAdapter.checkCast(TypeUtils.getType(toType, context.objectDef()));
        }
    }

    private static void unbox(GeneratorAdapter generatorAdapter, MethodContext context, TypeDef to) {
        generatorAdapter.unbox(TypeUtils.getType(to, context.objectDef()));
    }

    private static void box(GeneratorAdapter generatorAdapter, MethodContext context, TypeDef from) {
        generatorAdapter.valueOf(TypeUtils.getType(from, context.objectDef()));
    }
}

