/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.bytecode.expression;

import io.micronaut.sourcegen.bytecode.MethodContext;
import io.micronaut.sourcegen.bytecode.TypeUtils;
import io.micronaut.sourcegen.bytecode.expression.ExpressionWriter;
import io.micronaut.sourcegen.model.ExpressionDef;
import org.objectweb.asm.commons.GeneratorAdapter;

final class MathBinaryExpressionWriter
implements ExpressionWriter {
    private final ExpressionDef.MathBinaryOperation math;

    public MathBinaryExpressionWriter(ExpressionDef.MathBinaryOperation math) {
        this.math = math;
    }

    @Override
    public void write(GeneratorAdapter generatorAdapter, MethodContext context) {
        ExpressionWriter.writeExpression(generatorAdapter, context, this.math.left());
        ExpressionWriter.writeExpression(generatorAdapter, context, this.math.right());
        generatorAdapter.math(MathBinaryExpressionWriter.getMathOp(this.math.opType()), TypeUtils.getType(this.math.left().type(), context.objectDef()));
    }

    private static int getMathOp(ExpressionDef.MathBinaryOperation.OpType opType) {
        return switch (opType) {
            default -> throw new IncompatibleClassChangeError();
            case ExpressionDef.MathBinaryOperation.OpType.ADDITION -> 96;
            case ExpressionDef.MathBinaryOperation.OpType.SUBTRACTION -> 100;
            case ExpressionDef.MathBinaryOperation.OpType.MULTIPLICATION -> 104;
            case ExpressionDef.MathBinaryOperation.OpType.DIVISION -> 108;
            case ExpressionDef.MathBinaryOperation.OpType.MODULUS -> 112;
            case ExpressionDef.MathBinaryOperation.OpType.BITWISE_AND -> 126;
            case ExpressionDef.MathBinaryOperation.OpType.BITWISE_OR -> 128;
            case ExpressionDef.MathBinaryOperation.OpType.BITWISE_XOR -> 130;
            case ExpressionDef.MathBinaryOperation.OpType.BITWISE_LEFT_SHIFT -> 120;
            case ExpressionDef.MathBinaryOperation.OpType.BITWISE_RIGHT_SHIFT -> 122;
            case ExpressionDef.MathBinaryOperation.OpType.BITWISE_UNSIGNED_RIGHT_SHIFT -> 124;
        };
    }
}

