/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.bytecode.expression;

import io.micronaut.sourcegen.bytecode.MethodContext;
import io.micronaut.sourcegen.bytecode.TypeUtils;
import io.micronaut.sourcegen.bytecode.expression.ExpressionWriter;
import io.micronaut.sourcegen.model.TypeDef;
import io.micronaut.sourcegen.model.VariableDef;
import org.objectweb.asm.commons.GeneratorAdapter;

final class VariableExpressionWriter
implements ExpressionWriter {
    private final VariableDef variableDef;

    public VariableExpressionWriter(VariableDef variableDef) {
        this.variableDef = variableDef;
    }

    @Override
    public void write(GeneratorAdapter generatorAdapter, MethodContext context) {
        VariableDef owner;
        VariableDef parameterDef;
        Object localData;
        if (this.variableDef instanceof VariableDef.ExceptionVar) {
            MethodContext.LocalData localData2 = context.locals().get("$exception");
            generatorAdapter.loadLocal(localData2.index(), localData2.type());
            return;
        }
        VariableDef variableDef = this.variableDef;
        if (variableDef instanceof VariableDef.Local) {
            VariableDef.Local localVariableDef = (VariableDef.Local)variableDef;
            localData = context.locals().get(localVariableDef.name());
            generatorAdapter.loadLocal(((MethodContext.LocalData)localData).index(), ((MethodContext.LocalData)localData).type());
            return;
        }
        localData = this.variableDef;
        if (localData instanceof VariableDef.MethodParameter) {
            VariableDef.MethodParameter parameterVariableDef = (VariableDef.MethodParameter)localData;
            if (context.methodDef() == null) {
                throw new IllegalStateException("Accessing method parameters is not available");
            }
            parameterDef = context.methodDef().getParameters().stream().filter(p -> p.getName().equals(parameterVariableDef.name())).findFirst().orElseThrow();
            int parameterIndex = context.methodDef().getParameters().indexOf(parameterDef);
            generatorAdapter.loadArg(parameterIndex);
            return;
        }
        parameterDef = this.variableDef;
        if (parameterDef instanceof VariableDef.StaticField) {
            VariableDef.StaticField field = (VariableDef.StaticField)parameterDef;
            owner = field.ownerType();
            TypeDef fieldType = field.type();
            generatorAdapter.getStatic(TypeUtils.getType((TypeDef)owner, context.objectDef()), field.name(), TypeUtils.getType(fieldType, context.objectDef()));
            return;
        }
        owner = this.variableDef;
        if (owner instanceof VariableDef.Field) {
            VariableDef.Field field = (VariableDef.Field)owner;
            ExpressionWriter.writeExpression(generatorAdapter, context, field.instance());
            TypeDef fieldType = field.type();
            TypeDef owner2 = field.instance().type();
            generatorAdapter.getField(TypeUtils.getType(owner2, context.objectDef()), field.name(), TypeUtils.getType(fieldType, context.objectDef()));
            return;
        }
        if (this.variableDef instanceof VariableDef.This) {
            if (context.objectDef() == null) {
                throw new IllegalStateException("Accessing 'this' is not available");
            }
            generatorAdapter.loadThis();
            return;
        }
        if (this.variableDef instanceof VariableDef.Super) {
            if (context.objectDef() == null) {
                throw new IllegalStateException("Accessing 'super' is not available");
            }
            generatorAdapter.loadThis();
            return;
        }
        throw new UnsupportedOperationException("Unrecognized variable: " + String.valueOf(this.variableDef));
    }
}

