/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.bytecode.expression;

import io.micronaut.sourcegen.bytecode.MethodContext;
import io.micronaut.sourcegen.bytecode.TypeUtils;
import io.micronaut.sourcegen.bytecode.expression.ExpressionWriter;
import io.micronaut.sourcegen.model.ExpressionDef;
import io.micronaut.sourcegen.model.TypeDef;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

final class ConstantExpressionWriter
implements ExpressionWriter {
    private final ExpressionDef.Constant constant;

    public ConstantExpressionWriter(ExpressionDef.Constant constant) {
        this.constant = constant;
    }

    @Override
    public void write(GeneratorAdapter generatorAdapter, MethodContext context) {
        TypeDef type = this.constant.type();
        Object value = this.constant.value();
        if (value == null) {
            generatorAdapter.push((String)null);
            return;
        }
        if (value.getClass().isArray()) {
            ExpressionDef.NewArrayInitialized ex = TypeDef.of(value.getClass().getComponentType()).array().instantiate(Arrays.stream(ConstantExpressionWriter.getArray(value)).map(ExpressionDef::constant).toList());
            ExpressionWriter.writeExpression(generatorAdapter, context, (ExpressionDef)ex);
            return;
        }
        if (type instanceof TypeDef.Primitive) {
            TypeDef.Primitive primitive = (TypeDef.Primitive)type;
            if (value instanceof Number) {
                Number number = (Number)value;
                switch (primitive.name()) {
                    case "long": {
                        generatorAdapter.push(number.longValue());
                        break;
                    }
                    case "float": {
                        generatorAdapter.push(number.floatValue());
                        break;
                    }
                    case "double": {
                        generatorAdapter.push(number.doubleValue());
                        break;
                    }
                    case "byte": {
                        generatorAdapter.push((int)number.byteValue());
                        break;
                    }
                    case "int": {
                        generatorAdapter.push(number.intValue());
                        break;
                    }
                    case "short": {
                        generatorAdapter.push((int)number.shortValue());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unrecognized number primitive type: " + primitive.name());
                    }
                }
                return;
            }
            switch (primitive.name()) {
                case "boolean": {
                    generatorAdapter.push(((Boolean)value).booleanValue());
                    break;
                }
                case "char": {
                    generatorAdapter.push((int)((Character)value).charValue());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized primitive type: " + primitive.name());
                }
            }
            return;
        }
        if (value instanceof String) {
            String string = (String)value;
            generatorAdapter.push(string);
            return;
        }
        if (value instanceof Boolean) {
            Boolean aBoolean = (Boolean)value;
            generatorAdapter.push(aBoolean.booleanValue());
            generatorAdapter.valueOf(Type.getType(Boolean.TYPE));
            return;
        }
        if (value instanceof Enum) {
            Enum enumConstant = (Enum)value;
            Type enumType = Type.getType(enumConstant.getDeclaringClass());
            generatorAdapter.getStatic(enumType, enumConstant.name(), enumType);
            return;
        }
        if (value instanceof TypeDef) {
            TypeDef typeDef = (TypeDef)value;
            generatorAdapter.push(TypeUtils.getType(typeDef, context.objectDef()));
            return;
        }
        if (value instanceof Class) {
            Class aClass = (Class)value;
            generatorAdapter.push(Type.getType((Class)aClass));
            return;
        }
        if (value instanceof Integer) {
            Integer integer = (Integer)value;
            generatorAdapter.push(integer.intValue());
            generatorAdapter.valueOf(Type.getType(Integer.TYPE));
            return;
        }
        if (value instanceof Long) {
            Long aLong = (Long)value;
            generatorAdapter.push(aLong.longValue());
            generatorAdapter.valueOf(Type.getType(Long.TYPE));
            return;
        }
        if (value instanceof Double) {
            Double aDouble = (Double)value;
            generatorAdapter.push(aDouble.doubleValue());
            generatorAdapter.valueOf(Type.getType(Double.TYPE));
            return;
        }
        if (value instanceof Float) {
            Float aFloat = (Float)value;
            generatorAdapter.push(aFloat.floatValue());
            generatorAdapter.valueOf(Type.getType(Float.TYPE));
            return;
        }
        if (value instanceof Character) {
            Character character = (Character)value;
            generatorAdapter.push((int)character.charValue());
            generatorAdapter.valueOf(Type.getType(Character.TYPE));
            return;
        }
        if (value instanceof Short) {
            Short aShort = (Short)value;
            generatorAdapter.push((int)aShort.shortValue());
            generatorAdapter.valueOf(Type.getType(Short.TYPE));
            return;
        }
        if (value instanceof Byte) {
            Byte aByte = (Byte)value;
            generatorAdapter.push((int)aByte.byteValue());
            generatorAdapter.valueOf(Type.getType(Byte.TYPE));
            return;
        }
        throw new UnsupportedOperationException("Unrecognized constant: " + this.constant);
    }

    private static Object[] getArray(Object val) {
        if (val instanceof Object[]) {
            return (Object[])val;
        }
        Object[] outputArray = new Object[Array.getLength(val)];
        for (int i = 0; i < outputArray.length; ++i) {
            outputArray[i] = Array.get(val, i);
        }
        return outputArray;
    }
}

