/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.bytecode;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.processing.JavaModelUtils;
import io.micronaut.sourcegen.bytecode.TypeUtils;
import io.micronaut.sourcegen.model.ClassDef;
import io.micronaut.sourcegen.model.ClassTypeDef;
import io.micronaut.sourcegen.model.FieldDef;
import io.micronaut.sourcegen.model.InterfaceDef;
import io.micronaut.sourcegen.model.MethodDef;
import io.micronaut.sourcegen.model.ObjectDef;
import io.micronaut.sourcegen.model.ParameterDef;
import io.micronaut.sourcegen.model.RecordDef;
import io.micronaut.sourcegen.model.TypeDef;
import java.util.Objects;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.signature.SignatureWriter;

@Internal
final class SignatureWriterUtils {
    SignatureWriterUtils() {
    }

    @Nullable
    static String getFieldSignature(@Nullable ObjectDef objectDef, FieldDef fieldDef) {
        if (!SignatureWriterUtils.needsSignature(fieldDef.getType())) {
            return null;
        }
        SignatureWriter writer = new SignatureWriter();
        SignatureWriterUtils.writeSignature((SignatureVisitor)writer, objectDef, fieldDef.getType(), true);
        return writer.toString();
    }

    @Nullable
    static String getClassSignature(ClassDef classDef) {
        SignatureWriter writer = new SignatureWriter();
        for (TypeDef.TypeVariable typeVariable : classDef.getTypeVariables()) {
            SignatureWriterUtils.writeSignature((SignatureVisitor)writer, (ObjectDef)classDef, (TypeDef)typeVariable, true);
        }
        TypeDef superclass = (TypeDef)Objects.requireNonNullElse(classDef.getSuperclass(), TypeDef.OBJECT);
        SignatureWriterUtils.writeSignature(writer.visitSuperclass(), (ObjectDef)classDef, superclass, false);
        for (TypeDef superinterface : classDef.getSuperinterfaces()) {
            SignatureWriterUtils.writeSignature(writer.visitInterface(), (ObjectDef)classDef, superinterface, false);
        }
        return writer.toString();
    }

    @Nullable
    static String getRecordSignature(RecordDef recordDef) {
        SignatureWriter writer = new SignatureWriter();
        for (TypeDef.TypeVariable typeVariable : recordDef.getTypeVariables()) {
            SignatureWriterUtils.writeSignature((SignatureVisitor)writer, (ObjectDef)recordDef, (TypeDef)typeVariable, true);
        }
        SignatureWriterUtils.writeSignature(writer.visitSuperclass(), (ObjectDef)recordDef, TypeDef.of(Record.class), false);
        for (TypeDef superinterface : recordDef.getSuperinterfaces()) {
            SignatureWriterUtils.writeSignature(writer.visitInterface(), (ObjectDef)recordDef, superinterface, false);
        }
        return writer.toString();
    }

    @Nullable
    static String getInterfaceSignature(InterfaceDef interfaceDef) {
        if (interfaceDef.getTypeVariables().isEmpty() && interfaceDef.getSuperinterfaces().isEmpty()) {
            return null;
        }
        SignatureWriter writer = new SignatureWriter();
        for (TypeDef.TypeVariable typeVariable : interfaceDef.getTypeVariables()) {
            SignatureWriterUtils.writeSignature((SignatureVisitor)writer, (ObjectDef)interfaceDef, (TypeDef)typeVariable, true);
        }
        SignatureVisitor superclassVisitor = writer.visitSuperclass();
        superclassVisitor.visitClassType(TypeUtils.OBJECT_TYPE.getInternalName());
        superclassVisitor.visitEnd();
        for (TypeDef superinterface : interfaceDef.getSuperinterfaces()) {
            SignatureWriterUtils.writeSignature(writer.visitInterface(), (ObjectDef)interfaceDef, superinterface, false);
        }
        return writer.toString();
    }

    @Nullable
    static String getMethodSignature(@Nullable ObjectDef objectDef, MethodDef methodDef) {
        if (!SignatureWriterUtils.needsSignature(methodDef)) {
            return null;
        }
        SignatureWriter signatureWriter = new SignatureWriter();
        for (TypeDef.TypeVariable typeVariable : methodDef.getTypeVariables()) {
            SignatureWriterUtils.writeSignature((SignatureVisitor)signatureWriter, objectDef, methodDef, (TypeDef)typeVariable, true);
        }
        for (ParameterDef parameter : methodDef.getParameters()) {
            SignatureWriterUtils.writeSignature(signatureWriter.visitParameterType(), objectDef, methodDef, parameter.getType(), false);
        }
        SignatureWriterUtils.writeSignature(signatureWriter.visitReturnType(), objectDef, methodDef, methodDef.getReturnType(), false);
        return signatureWriter.toString();
    }

    private static boolean needsSignature(MethodDef methodDef) {
        for (ParameterDef parameter : methodDef.getParameters()) {
            if (!SignatureWriterUtils.needsSignature(parameter.getType())) continue;
            return true;
        }
        return SignatureWriterUtils.needsSignature(methodDef.getReturnType());
    }

    private static boolean needsSignature(TypeDef typeDef) {
        return typeDef instanceof ClassTypeDef.Parameterized || typeDef instanceof TypeDef.TypeVariable;
    }

    private static void writeSignature(SignatureVisitor signatureWriter, ObjectDef objectDef, TypeDef typeDef, boolean isDefinition) {
        SignatureWriterUtils.writeSignature(signatureWriter, objectDef, null, typeDef, isDefinition);
    }

    private static void writeSignature(SignatureVisitor signatureWriter, ObjectDef objectDef, @Nullable MethodDef methodDef, TypeDef typeDef, boolean isDefinition) {
        Objects.requireNonNull(objectDef);
        typeDef = ObjectDef.getContextualType((ObjectDef)objectDef, (TypeDef)typeDef);
        if (typeDef instanceof TypeDef.Primitive) {
            TypeDef.Primitive primitive = (TypeDef.Primitive)typeDef;
            Type type = Type.getType((String)((String)JavaModelUtils.NAME_TO_TYPE_MAP.get(primitive.name())));
            signatureWriter.visitBaseType(type.getDescriptor().charAt(0));
            return;
        }
        if (typeDef instanceof TypeDef.TypeVariable) {
            TypeDef.TypeVariable typeVariable = (TypeDef.TypeVariable)typeDef;
            String name = typeVariable.name();
            if (isDefinition) {
                signatureWriter.visitFormalTypeParameter(name);
                if (typeVariable.bounds().isEmpty()) {
                    signatureWriter.visitClassType(TypeUtils.OBJECT_TYPE.getInternalName());
                    signatureWriter.visitEnd();
                } else {
                    TypeDef bound = (TypeDef)typeVariable.bounds().get(0);
                    signatureWriter.visitClassBound();
                    SignatureWriterUtils.writeSignature(signatureWriter, objectDef, bound, false);
                }
            } else if (SignatureWriterUtils.isVariablePartOfTheDefinition(name, objectDef, methodDef)) {
                signatureWriter.visitTypeVariable(typeVariable.name());
            } else if (typeVariable.bounds().isEmpty()) {
                signatureWriter.visitClassType(TypeUtils.OBJECT_TYPE.getInternalName());
                signatureWriter.visitEnd();
            } else {
                signatureWriter.visitClassType(TypeUtils.getType((TypeDef)typeVariable.bounds().get(0), objectDef).getInternalName());
                signatureWriter.visitEnd();
            }
            return;
        }
        if (typeDef instanceof ClassTypeDef.Parameterized) {
            ClassTypeDef.Parameterized parameterized = (ClassTypeDef.Parameterized)typeDef;
            signatureWriter.visitClassType(TypeUtils.getType(parameterized.rawType()).getInternalName());
            if (!parameterized.typeArguments().isEmpty()) {
                for (TypeDef typeArgument : parameterized.typeArguments()) {
                    SignatureVisitor signatureVisitor = signatureWriter.visitTypeArgument('=');
                    SignatureWriterUtils.writeSignature(signatureVisitor, objectDef, typeArgument, false);
                }
                signatureWriter.visitEnd();
            }
            return;
        }
        if (typeDef instanceof ClassTypeDef) {
            ClassTypeDef classDef = (ClassTypeDef)typeDef;
            signatureWriter.visitClassType(TypeUtils.getType(classDef.getName()).getInternalName());
            signatureWriter.visitEnd();
            return;
        }
        if (typeDef instanceof TypeDef.Wildcard) {
            signatureWriter.visitClassType(TypeUtils.OBJECT_TYPE.getInternalName());
            signatureWriter.visitEnd();
            return;
        }
        if (typeDef instanceof TypeDef.Array) {
            TypeDef.Array array = (TypeDef.Array)typeDef;
            if (array.dimensions() == 1) {
                SignatureWriterUtils.writeSignature(signatureWriter.visitArrayType(), objectDef, array.componentType(), false);
            } else {
                SignatureWriterUtils.writeSignature(signatureWriter.visitArrayType(), objectDef, (TypeDef)new TypeDef.Array(array.componentType(), array.dimensions() - 1, false), false);
            }
            return;
        }
        throw new IllegalStateException("Not recognized typedef: " + typeDef);
    }

    private static boolean isVariablePartOfTheDefinition(String variableName, ObjectDef objectDef, @Nullable MethodDef methodDef) {
        if (methodDef != null && methodDef.getTypeVariables().stream().anyMatch(v -> v.name().equals(variableName))) {
            return true;
        }
        if (objectDef instanceof ClassDef) {
            ClassDef classDef = (ClassDef)objectDef;
            return classDef.getTypeVariables().stream().anyMatch(tv -> tv.name().equals(variableName));
        }
        if (objectDef instanceof InterfaceDef) {
            InterfaceDef interfaceDef = (InterfaceDef)objectDef;
            return interfaceDef.getTypeVariables().stream().anyMatch(tv -> tv.name().equals(variableName));
        }
        return false;
    }
}

