/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.bytecode.expression;

import io.micronaut.sourcegen.bytecode.MethodContext;
import io.micronaut.sourcegen.bytecode.TypeUtils;
import io.micronaut.sourcegen.bytecode.expression.AbstractStatementAwareExpressionWriter;
import io.micronaut.sourcegen.bytecode.expression.ExpressionWriter;
import io.micronaut.sourcegen.model.ExpressionDef;
import io.micronaut.sourcegen.model.TypeDef;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Handle;
import org.objectweb.asm.commons.GeneratorAdapter;

final class StringConcatenationExpressionWriter
extends AbstractStatementAwareExpressionWriter {
    private static final String STRING_CONCAT_FACTORY_TYPE = "java/lang/invoke/StringConcatFactory";
    private static final String MAKE_CONCAT_METHOD = "makeConcatWithConstants";
    private static final String MAKE_CONCAT_DYNAMIC_METHOD = "makeConcatWithConstants";
    private static final String MAKE_CONCAT_METHOD_DESCRIPTOR = "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;";
    private static final char ARG_CODE = '\u0001';
    private final List<ExpressionDef> concatParts;

    public StringConcatenationExpressionWriter(ExpressionDef.StringConcatenation concat) {
        ArrayList<ExpressionDef> concatStrings = new ArrayList<ExpressionDef>();
        StringConcatenationExpressionWriter.flattenConcat(concat, concatStrings);
        this.concatParts = concatStrings;
    }

    @Override
    public void write(GeneratorAdapter generatorAdapter, MethodContext context) {
        StringBuilder stringExpression = new StringBuilder();
        int numDynamicParts = 0;
        for (ExpressionDef value : this.concatParts) {
            if (StringConcatenationExpressionWriter.isCompileTimeConstant(value)) {
                stringExpression.append(((ExpressionDef.Constant)value).value());
                continue;
            }
            ++numDynamicParts;
            stringExpression.append('\u0001');
            ExpressionWriter.writeExpressionCheckCast(generatorAdapter, context, value, (TypeDef)TypeDef.OBJECT);
        }
        if (numDynamicParts == 0) {
            generatorAdapter.push(stringExpression.toString());
            return;
        }
        Handle bootstrapMethodHandle = new Handle(6, STRING_CONCAT_FACTORY_TYPE, "makeConcatWithConstants", MAKE_CONCAT_METHOD_DESCRIPTOR, false);
        generatorAdapter.visitInvokeDynamicInsn("makeConcatWithConstants", this.createDynamicMethodDescriptor(this.concatParts, context), bootstrapMethodHandle, new Object[]{stringExpression.toString()});
        this.popValueIfNeeded(generatorAdapter, (TypeDef)TypeDef.STRING);
    }

    private static boolean isCompileTimeConstant(ExpressionDef expression) {
        return expression instanceof ExpressionDef.Constant && (expression.type().isPrimitive() || expression.type().equals(TypeDef.STRING));
    }

    private static void flattenConcat(ExpressionDef.StringConcatenation concat, List<ExpressionDef> result) {
        ExpressionDef expressionDef = concat.left();
        if (expressionDef instanceof ExpressionDef.StringConcatenation) {
            ExpressionDef.StringConcatenation left = (ExpressionDef.StringConcatenation)expressionDef;
            StringConcatenationExpressionWriter.flattenConcat(left, result);
        } else {
            result.add(concat.left());
        }
        expressionDef = concat.right();
        if (expressionDef instanceof ExpressionDef.StringConcatenation) {
            ExpressionDef.StringConcatenation right = (ExpressionDef.StringConcatenation)expressionDef;
            StringConcatenationExpressionWriter.flattenConcat(right, result);
        } else {
            result.add(concat.right());
        }
    }

    String createDynamicMethodDescriptor(List<ExpressionDef> concatParts, MethodContext context) {
        StringBuilder dynamicDescriptor = new StringBuilder("(");
        for (ExpressionDef part : concatParts) {
            if (StringConcatenationExpressionWriter.isCompileTimeConstant(part)) continue;
            dynamicDescriptor.append(TypeUtils.getType(part.type(), context.objectDef()));
        }
        dynamicDescriptor.append(")");
        dynamicDescriptor.append(TypeUtils.getType(TypeDef.STRING).getDescriptor());
        return dynamicDescriptor.toString();
    }
}

