/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.bytecode.expression;

import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.sourcegen.bytecode.MethodContext;
import io.micronaut.sourcegen.bytecode.expression.ArrayElementExpressionWriter;
import io.micronaut.sourcegen.bytecode.expression.CastExpressionWriter;
import io.micronaut.sourcegen.bytecode.expression.ConditionExpressionWriter;
import io.micronaut.sourcegen.bytecode.expression.ConstantExpressionWriter;
import io.micronaut.sourcegen.bytecode.expression.GetPropertyExpressionWriter;
import io.micronaut.sourcegen.bytecode.expression.IfElseExpressionWriter;
import io.micronaut.sourcegen.bytecode.expression.InstanceOfExpressionWriter;
import io.micronaut.sourcegen.bytecode.expression.InvokeGetClassExpressionWriter;
import io.micronaut.sourcegen.bytecode.expression.InvokeHashCodeMethodExpressionWriter;
import io.micronaut.sourcegen.bytecode.expression.InvokeInstanceMethodExpressionWriter;
import io.micronaut.sourcegen.bytecode.expression.InvokeStaticMethodExpressionWriter;
import io.micronaut.sourcegen.bytecode.expression.LambdaExpressionWriter;
import io.micronaut.sourcegen.bytecode.expression.MathBinaryExpressionWriter;
import io.micronaut.sourcegen.bytecode.expression.MathUnaryExpressionWriter;
import io.micronaut.sourcegen.bytecode.expression.NewArrayInitializedExpressionWriter;
import io.micronaut.sourcegen.bytecode.expression.NewArrayOfSizeExpressionWriter;
import io.micronaut.sourcegen.bytecode.expression.NewInstanceExpressionWriter;
import io.micronaut.sourcegen.bytecode.expression.StringConcatenationExpressionWriter;
import io.micronaut.sourcegen.bytecode.expression.SwitchExpressionWriter;
import io.micronaut.sourcegen.bytecode.expression.SwitchYieldCaseExpressionWriter;
import io.micronaut.sourcegen.bytecode.expression.VariableExpressionWriter;
import io.micronaut.sourcegen.model.ExpressionDef;
import io.micronaut.sourcegen.model.TypeDef;
import io.micronaut.sourcegen.model.VariableDef;
import org.objectweb.asm.commons.GeneratorAdapter;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ExpressionWriter {
    public static ExpressionWriter of(ExpressionDef expressionDef) {
        if (expressionDef instanceof ExpressionDef.ArrayElement) {
            ExpressionDef.ArrayElement arrayElement = (ExpressionDef.ArrayElement)expressionDef;
            return new ArrayElementExpressionWriter(arrayElement);
        }
        if (expressionDef instanceof ExpressionDef.InstanceOf) {
            ExpressionDef.InstanceOf instanceOf = (ExpressionDef.InstanceOf)expressionDef;
            return new InstanceOfExpressionWriter(instanceOf);
        }
        if (expressionDef instanceof ExpressionDef.ConditionExpressionDef) {
            return new ConditionExpressionWriter(expressionDef);
        }
        if (expressionDef instanceof ExpressionDef.MathBinaryOperation) {
            ExpressionDef.MathBinaryOperation math = (ExpressionDef.MathBinaryOperation)expressionDef;
            return new MathBinaryExpressionWriter(math);
        }
        if (expressionDef instanceof ExpressionDef.MathUnaryOperation) {
            ExpressionDef.MathUnaryOperation math = (ExpressionDef.MathUnaryOperation)expressionDef;
            return new MathUnaryExpressionWriter(math);
        }
        if (expressionDef instanceof ExpressionDef.InvokeInstanceMethod) {
            ExpressionDef.InvokeInstanceMethod invokeInstanceMethod = (ExpressionDef.InvokeInstanceMethod)expressionDef;
            return new InvokeInstanceMethodExpressionWriter(invokeInstanceMethod);
        }
        if (expressionDef instanceof ExpressionDef.NewInstance) {
            ExpressionDef.NewInstance newInstance = (ExpressionDef.NewInstance)expressionDef;
            return new NewInstanceExpressionWriter(newInstance);
        }
        if (expressionDef instanceof ExpressionDef.NewArrayOfSize) {
            ExpressionDef.NewArrayOfSize newArray = (ExpressionDef.NewArrayOfSize)expressionDef;
            return new NewArrayOfSizeExpressionWriter(newArray);
        }
        if (expressionDef instanceof ExpressionDef.NewArrayInitialized) {
            ExpressionDef.NewArrayInitialized newArray = (ExpressionDef.NewArrayInitialized)expressionDef;
            return new NewArrayInitializedExpressionWriter(newArray);
        }
        if (expressionDef instanceof ExpressionDef.Cast) {
            ExpressionDef.Cast castExpressionDef = (ExpressionDef.Cast)expressionDef;
            return new CastExpressionWriter(castExpressionDef);
        }
        if (expressionDef instanceof ExpressionDef.Constant) {
            ExpressionDef.Constant constant = (ExpressionDef.Constant)expressionDef;
            return new ConstantExpressionWriter(constant);
        }
        if (expressionDef instanceof ExpressionDef.InvokeStaticMethod) {
            ExpressionDef.InvokeStaticMethod invokeStaticMethod = (ExpressionDef.InvokeStaticMethod)expressionDef;
            return new InvokeStaticMethodExpressionWriter(invokeStaticMethod);
        }
        if (expressionDef instanceof ExpressionDef.GetPropertyValue) {
            ExpressionDef.GetPropertyValue getPropertyValue = (ExpressionDef.GetPropertyValue)expressionDef;
            return new GetPropertyExpressionWriter(getPropertyValue);
        }
        if (expressionDef instanceof ExpressionDef.IfElse) {
            ExpressionDef.IfElse conditionIfElse = (ExpressionDef.IfElse)expressionDef;
            return new IfElseExpressionWriter(conditionIfElse);
        }
        if (expressionDef instanceof ExpressionDef.Switch) {
            ExpressionDef.Switch aSwitch = (ExpressionDef.Switch)expressionDef;
            return new SwitchExpressionWriter(aSwitch);
        }
        if (expressionDef instanceof ExpressionDef.SwitchYieldCase) {
            ExpressionDef.SwitchYieldCase switchYieldCase = (ExpressionDef.SwitchYieldCase)expressionDef;
            return new SwitchYieldCaseExpressionWriter(switchYieldCase);
        }
        if (expressionDef instanceof VariableDef) {
            VariableDef variableDef = (VariableDef)expressionDef;
            return new VariableExpressionWriter(variableDef);
        }
        if (expressionDef instanceof ExpressionDef.InvokeGetClassMethod) {
            ExpressionDef.InvokeGetClassMethod invokeGetClassMethod = (ExpressionDef.InvokeGetClassMethod)expressionDef;
            return new InvokeGetClassExpressionWriter(invokeGetClassMethod);
        }
        if (expressionDef instanceof ExpressionDef.InvokeHashCodeMethod) {
            ExpressionDef.InvokeHashCodeMethod invokeHashCodeMethod = (ExpressionDef.InvokeHashCodeMethod)expressionDef;
            return new InvokeHashCodeMethodExpressionWriter(invokeHashCodeMethod);
        }
        if (expressionDef instanceof ExpressionDef.Lambda) {
            ExpressionDef.Lambda lambda = (ExpressionDef.Lambda)expressionDef;
            return new LambdaExpressionWriter(lambda);
        }
        if (expressionDef instanceof ExpressionDef.StringConcatenation) {
            ExpressionDef.StringConcatenation concat = (ExpressionDef.StringConcatenation)expressionDef;
            return new StringConcatenationExpressionWriter(concat);
        }
        throw new UnsupportedOperationException("Unrecognized expression: " + expressionDef);
    }

    public static void writeExpression(GeneratorAdapter generatorAdapter, MethodContext context, ExpressionDef expressionDef) {
        ExpressionWriter.of(expressionDef).write(generatorAdapter, context);
    }

    public static void writeExpressionCheckCast(GeneratorAdapter generatorAdapter, MethodContext context, ExpressionDef expressionDef, TypeDef expectedType) {
        if (expressionDef instanceof ExpressionDef.Constant) {
            ExpressionDef.Constant constant = (ExpressionDef.Constant)expressionDef;
            expressionDef = ExpressionWriter.adjustConstant(expressionDef, expectedType, constant);
        }
        ExpressionWriter.of((ExpressionDef)new ExpressionDef.Cast(expectedType, expressionDef)).write(generatorAdapter, context);
    }

    private static ExpressionDef adjustConstant(ExpressionDef expressionDef, TypeDef expectedType, ExpressionDef.Constant constant) {
        if (expectedType.isPrimitive() && !constant.type().isPrimitive() && constant.value() != null && ReflectionUtils.getPrimitiveType(constant.value().getClass()).isPrimitive()) {
            expressionDef = ExpressionDef.primitiveConstant((Object)constant.value());
        }
        return expressionDef;
    }

    public void write(GeneratorAdapter var1, MethodContext var2);
}

