/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.javapoet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;

public final class Util {
    private Util() {
    }

    static <K, V> Map<K, List<V>> immutableMultimap(Map<K, List<V>> multimap) {
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry<K, List<V>> entry : multimap.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            result.put(entry.getKey(), Util.immutableList((Collection)entry.getValue()));
        }
        return Collections.unmodifiableMap(result);
    }

    static <K, V> Map<K, V> immutableMap(Map<K, V> map) {
        return Collections.unmodifiableMap(new LinkedHashMap<K, V>(map));
    }

    static void checkArgument(boolean condition, String format, Object ... args) {
        if (!condition) {
            throw new IllegalArgumentException(format.formatted(args));
        }
    }

    static <T> T checkNotNull(T reference, String format, Object ... args) {
        if (reference == null) {
            throw new NullPointerException(format.formatted(args));
        }
        return reference;
    }

    static void checkState(boolean condition, String format, Object ... args) {
        if (!condition) {
            throw new IllegalStateException(format.formatted(args));
        }
    }

    static <T> List<T> immutableList(Collection<T> collection) {
        return Collections.unmodifiableList(new ArrayList<T>(collection));
    }

    static <T> Set<T> immutableSet(Collection<T> set) {
        return Collections.unmodifiableSet(new LinkedHashSet<T>(set));
    }

    static <T> Set<T> union(Set<T> a, Set<T> b) {
        LinkedHashSet<T> result = new LinkedHashSet<T>(a);
        result.addAll(b);
        return result;
    }

    static void requireExactlyOneOf(Set<Modifier> modifiers, Modifier ... mutuallyExclusive) {
        int count = 0;
        for (Modifier modifier : mutuallyExclusive) {
            if (!modifiers.contains((Object)modifier)) continue;
            ++count;
        }
        Util.checkArgument(count == 1, "modifiers %s must contain one of %s", modifiers, Arrays.toString((Object[])mutuallyExclusive));
    }

    public static String characterLiteralWithoutSingleQuotes(char c) {
        return switch (c) {
            case '\b' -> "\\b";
            case '\t' -> "\\t";
            case '\n' -> "\\n";
            case '\f' -> "\\f";
            case '\r' -> "\\r";
            case '\"' -> "\"";
            case '\'' -> "\\'";
            case '\\' -> "\\\\";
            default -> Character.isISOControl(c) ? "\\u%04x".formatted(c) : Character.toString(c);
        };
    }

    static String stringLiteralWithDoubleQuotes(String value, String indent) {
        StringBuilder result = new StringBuilder(value.length() + 2);
        result.append('\"');
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\'') {
                result.append('\'');
                continue;
            }
            if (c == '\"') {
                result.append("\\\"");
                continue;
            }
            result.append(Util.characterLiteralWithoutSingleQuotes(c));
            if (c != '\n' || i + 1 >= value.length()) continue;
            result.append("\"\n").append(indent).append(indent).append("+ \"");
        }
        result.append('\"');
        return result.toString();
    }
}

