/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.sourcegen.generator.SourceGenerator;
import io.micronaut.sourcegen.javapoet.AnnotationSpec;
import io.micronaut.sourcegen.javapoet.ArrayTypeName;
import io.micronaut.sourcegen.javapoet.ClassName;
import io.micronaut.sourcegen.javapoet.CodeBlock;
import io.micronaut.sourcegen.javapoet.FieldSpec;
import io.micronaut.sourcegen.javapoet.JavaFile;
import io.micronaut.sourcegen.javapoet.MethodSpec;
import io.micronaut.sourcegen.javapoet.ParameterSpec;
import io.micronaut.sourcegen.javapoet.ParameterizedTypeName;
import io.micronaut.sourcegen.javapoet.TypeName;
import io.micronaut.sourcegen.javapoet.TypeSpec;
import io.micronaut.sourcegen.javapoet.TypeVariableName;
import io.micronaut.sourcegen.javapoet.Util;
import io.micronaut.sourcegen.javapoet.WildcardTypeName;
import io.micronaut.sourcegen.model.AnnotationDef;
import io.micronaut.sourcegen.model.ClassDef;
import io.micronaut.sourcegen.model.ClassTypeDef;
import io.micronaut.sourcegen.model.EnumDef;
import io.micronaut.sourcegen.model.ExpressionDef;
import io.micronaut.sourcegen.model.FieldDef;
import io.micronaut.sourcegen.model.InterfaceDef;
import io.micronaut.sourcegen.model.JavaIdioms;
import io.micronaut.sourcegen.model.MethodDef;
import io.micronaut.sourcegen.model.ObjectDef;
import io.micronaut.sourcegen.model.PropertyDef;
import io.micronaut.sourcegen.model.RecordDef;
import io.micronaut.sourcegen.model.StatementDef;
import io.micronaut.sourcegen.model.TypeDef;
import io.micronaut.sourcegen.model.VariableDef;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.lang.model.element.Modifier;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Internal
public class JavaPoetSourceGenerator
implements SourceGenerator {
    private static final String EXCEPTION_NAME = "$exception";

    public VisitorContext.Language getLanguage() {
        return VisitorContext.Language.JAVA;
    }

    public void write(ObjectDef objectDef, Writer writer) throws IOException {
        if (objectDef instanceof ClassDef) {
            ClassDef classDef = (ClassDef)objectDef;
            this.writeClass(writer, classDef);
        } else if (objectDef instanceof RecordDef) {
            RecordDef recordDef = (RecordDef)objectDef;
            this.writeRecord(writer, recordDef);
        } else if (objectDef instanceof InterfaceDef) {
            InterfaceDef interfaceDef = (InterfaceDef)objectDef;
            this.writeInterface(writer, interfaceDef);
        } else if (objectDef instanceof EnumDef) {
            EnumDef enumDef = (EnumDef)objectDef;
            this.writeEnum(writer, enumDef);
        } else {
            throw new IllegalStateException("Unknown object definition: " + String.valueOf(objectDef));
        }
    }

    private void writeInterface(Writer writer, InterfaceDef interfaceDef) throws IOException {
        TypeSpec.Builder interfaceBuilder = this.getInterfaceBuilder(interfaceDef);
        JavaFile javaFile = JavaFile.builder(interfaceDef.getPackageName(), interfaceBuilder.build()).build();
        javaFile.writeTo(writer);
    }

    private TypeSpec.Builder getInterfaceBuilder(InterfaceDef interfaceDef) {
        TypeSpec.Builder interfaceBuilder = TypeSpec.interfaceBuilder(interfaceDef.getSimpleName());
        interfaceBuilder.addModifiers(interfaceDef.getModifiersArray());
        interfaceDef.getTypeVariables().stream().map(t -> this.asTypeVariable((TypeDef.TypeVariable)t, (ObjectDef)interfaceDef)).forEach(interfaceBuilder::addTypeVariable);
        interfaceDef.getSuperinterfaces().stream().map(typeDef -> this.asType((TypeDef)typeDef, (ObjectDef)interfaceDef)).forEach(interfaceBuilder::addSuperinterface);
        interfaceDef.getJavadoc().forEach(interfaceBuilder::addJavadoc);
        for (AnnotationDef annotation : interfaceDef.getAnnotations()) {
            interfaceBuilder.addAnnotation(this.asAnnotationSpec(annotation));
        }
        for (PropertyDef property : interfaceDef.getProperties()) {
            TypeName propertyType = this.asType(property.getType(), (ObjectDef)interfaceDef);
            String propertyName = property.getName();
            FieldSpec.Builder fieldBuilder = FieldSpec.builder(propertyType, propertyName, new Modifier[0]).addModifiers(Modifier.PRIVATE);
            property.getJavadoc().forEach(x$0 -> fieldBuilder.addJavadoc((String)x$0, new Object[0]));
            for (AnnotationDef annotation : property.getAnnotations()) {
                fieldBuilder.addAnnotation(this.asAnnotationSpec(annotation));
            }
            interfaceBuilder.addField(fieldBuilder.build());
            String capitalizedPropertyName = NameUtils.capitalize((String)propertyName);
            interfaceBuilder.addMethod(MethodSpec.methodBuilder("get" + capitalizedPropertyName).addModifiers(property.getModifiersArray()).returns(propertyType).build());
            interfaceBuilder.addMethod(MethodSpec.methodBuilder("set" + capitalizedPropertyName).addModifiers(property.getModifiersArray()).addParameter(ParameterSpec.builder(propertyType, propertyName, new Modifier[0]).build()).build());
        }
        this.addInnerTypes(interfaceDef.getInnerTypes(), interfaceBuilder, true);
        for (MethodDef method : interfaceDef.getMethods()) {
            interfaceBuilder.addMethod(this.asMethodSpec((ObjectDef)interfaceDef, method));
        }
        return interfaceBuilder;
    }

    private void writeEnum(Writer writer, EnumDef enumDef) throws IOException {
        TypeSpec.Builder enumBuilder = this.getEnumBuilder(enumDef);
        JavaFile javaFile = JavaFile.builder(enumDef.getPackageName(), enumBuilder.build()).build();
        javaFile.writeTo(writer);
    }

    private TypeSpec.Builder getEnumBuilder(EnumDef enumDef) {
        TypeSpec.Builder enumBuilder = TypeSpec.enumBuilder(enumDef.getSimpleName());
        enumBuilder.addModifiers(enumDef.getModifiersArray());
        enumDef.getSuperinterfaces().stream().map(typeDef -> this.asType((TypeDef)typeDef, (ObjectDef)enumDef)).forEach(enumBuilder::addSuperinterface);
        enumDef.getJavadoc().forEach(enumBuilder::addJavadoc);
        for (AnnotationDef annotation : enumDef.getAnnotations()) {
            enumBuilder.addAnnotation(this.asAnnotationSpec(annotation));
        }
        enumDef.getEnumConstants().forEach(e -> {
            TypeSpec.Builder type = TypeSpec.anonymousClassBuilder("", new Object[0]);
            if (e.constructorArgs() != null) {
                List constructorArgs = e.constructorArgs();
                CodeBlock.Builder expBuilder = CodeBlock.builder();
                for (int i = 0; i < constructorArgs.size(); ++i) {
                    expBuilder.add(this.renderExpression(null, null, Map.of(), (ExpressionDef)constructorArgs.get(i)));
                    if (i >= constructorArgs.size() - 1) continue;
                    expBuilder.add(", ", new Object[0]);
                }
                type = TypeSpec.anonymousClassBuilder(expBuilder.build());
            }
            e.javadoc().forEach(type::addJavadoc);
            enumBuilder.addEnumConstant(e.name(), type.build());
        });
        this.buildProperties((ObjectDef)enumDef, enumBuilder);
        this.buildFields((ObjectDef)enumDef, enumBuilder);
        for (MethodDef method : enumDef.getMethods()) {
            enumBuilder.addMethod(this.asMethodSpec((ObjectDef)enumDef, method));
        }
        this.addInnerTypes(enumDef.getInnerTypes(), enumBuilder, false);
        return enumBuilder;
    }

    private void writeClass(Writer writer, ClassDef classDef) throws IOException {
        TypeSpec.Builder classBuilder = this.getClassBuilder(classDef);
        JavaFile javaFile = JavaFile.builder(classDef.getPackageName(), classBuilder.build()).build();
        javaFile.writeTo(writer);
    }

    private TypeSpec.Builder getClassBuilder(ClassDef classDef) {
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder(classDef.getSimpleName());
        classBuilder.addModifiers(classDef.getModifiersArray());
        classDef.getTypeVariables().stream().map(t -> this.asTypeVariable((TypeDef.TypeVariable)t, (ObjectDef)classDef)).forEach(classBuilder::addTypeVariable);
        classDef.getSuperinterfaces().stream().map(typeDef -> this.asType((TypeDef)typeDef, (ObjectDef)classDef)).forEach(classBuilder::addSuperinterface);
        classDef.getJavadoc().forEach(classBuilder::addJavadoc);
        if (classDef.getSuperclass() != null) {
            classBuilder.superclass(this.asType((TypeDef)classDef.getSuperclass(), (ObjectDef)classDef));
        }
        for (AnnotationDef annotation : classDef.getAnnotations()) {
            classBuilder.addAnnotation(this.asAnnotationSpec(annotation));
        }
        this.buildProperties((ObjectDef)classDef, classBuilder);
        this.buildFields((ObjectDef)classDef, classBuilder);
        this.addInnerTypes(classDef.getInnerTypes(), classBuilder, false);
        for (MethodDef method : classDef.getMethods()) {
            classBuilder.addMethod(this.asMethodSpec((ObjectDef)classDef, method));
        }
        return classBuilder;
    }

    private void writeRecord(Writer writer, RecordDef recordDef) throws IOException {
        TypeSpec.Builder classBuilder = this.getRecordBuilder(recordDef);
        JavaFile javaFile = JavaFile.builder(recordDef.getPackageName(), classBuilder.build()).build();
        javaFile.writeTo(writer);
    }

    private TypeSpec.Builder getRecordBuilder(RecordDef recordDef) {
        TypeSpec.Builder classBuilder = TypeSpec.recordBuilder(recordDef.getSimpleName());
        classBuilder.addModifiers(recordDef.getModifiersArray());
        recordDef.getTypeVariables().stream().map(t -> this.asTypeVariable((TypeDef.TypeVariable)t, (ObjectDef)recordDef)).forEach(classBuilder::addTypeVariable);
        recordDef.getSuperinterfaces().stream().map(typeDef -> this.asType((TypeDef)typeDef, (ObjectDef)recordDef)).forEach(classBuilder::addSuperinterface);
        recordDef.getJavadoc().forEach(classBuilder::addJavadoc);
        for (AnnotationDef annotation : recordDef.getAnnotations()) {
            classBuilder.addAnnotation(this.asAnnotationSpec(annotation));
        }
        for (PropertyDef property : recordDef.getProperties()) {
            TypeName propertyType = this.asType(property.getType(), (ObjectDef)recordDef);
            String propertyName = property.getName();
            ParameterSpec.Builder componentBuilder = ParameterSpec.builder(propertyType, propertyName, new Modifier[0]);
            property.getJavadoc().forEach(componentBuilder::addJavadoc);
            for (AnnotationDef annotation : property.getAnnotations()) {
                componentBuilder.addAnnotation(this.asAnnotationSpec(annotation));
            }
            classBuilder.addRecordComponent(componentBuilder.build());
        }
        this.addInnerTypes(recordDef.getInnerTypes(), classBuilder, false);
        for (MethodDef method : recordDef.getMethods()) {
            classBuilder.addMethod(this.asMethodSpec((ObjectDef)recordDef, method));
        }
        return classBuilder;
    }

    private void addInnerTypes(List<ObjectDef> innerTypes, TypeSpec.Builder classBuilder, boolean isInterface) {
        for (ObjectDef innerType : innerTypes) {
            TypeSpec.Builder innerBuilder;
            if (innerType instanceof ClassDef) {
                ClassDef innerClassDef = (ClassDef)innerType;
                innerBuilder = this.getClassBuilder(innerClassDef);
            } else if (innerType instanceof InterfaceDef) {
                InterfaceDef innerInterfaceDef = (InterfaceDef)innerType;
                innerBuilder = this.getInterfaceBuilder(innerInterfaceDef);
            } else if (innerType instanceof EnumDef) {
                EnumDef innerEnumDef = (EnumDef)innerType;
                innerBuilder = this.getEnumBuilder(innerEnumDef);
            } else if (innerType instanceof RecordDef) {
                RecordDef innerRecordDef = (RecordDef)innerType;
                innerBuilder = this.getRecordBuilder(innerRecordDef);
            } else {
                throw new IllegalStateException("Unknown object definition: " + String.valueOf(innerType));
            }
            if (isInterface) {
                innerBuilder.addModifiers(Modifier.PUBLIC, Modifier.STATIC);
            }
            classBuilder.addType(innerBuilder.build());
        }
    }

    private void buildFields(ObjectDef objectDef, TypeSpec.Builder builder) {
        List fields = objectDef instanceof ClassDef ? ((ClassDef)objectDef).getFields() : ((EnumDef)objectDef).getFields();
        for (FieldDef field : fields) {
            FieldSpec.Builder fieldBuilder = FieldSpec.builder(this.asType(field.getType(), objectDef), field.getName(), new Modifier[0]).addModifiers(field.getModifiersArray());
            field.getInitializer().ifPresent(init -> fieldBuilder.initializer(this.renderExpression(objectDef, null, Map.of(), (ExpressionDef)init)));
            field.getJavadoc().forEach(x$0 -> fieldBuilder.addJavadoc((String)x$0, new Object[0]));
            for (AnnotationDef annotation : field.getAnnotations()) {
                fieldBuilder.addAnnotation(this.asAnnotationSpec(annotation));
            }
            builder.addField(fieldBuilder.build());
        }
    }

    private void buildProperties(ObjectDef objectDef, TypeSpec.Builder builder) {
        for (PropertyDef property : objectDef.getProperties()) {
            TypeName propertyType = this.asType(property.getType(), objectDef);
            String propertyName = property.getName();
            FieldSpec.Builder fieldBuilder = FieldSpec.builder(propertyType, propertyName, new Modifier[0]).addModifiers(Modifier.PRIVATE);
            for (AnnotationDef annotation : property.getAnnotations()) {
                fieldBuilder.addAnnotation(this.asAnnotationSpec(annotation));
            }
            property.getJavadoc().forEach(x$0 -> fieldBuilder.addJavadoc((String)x$0, new Object[0]));
            builder.addField(fieldBuilder.build());
            String capitalizedPropertyName = NameUtils.capitalize((String)propertyName);
            builder.addMethod(MethodSpec.methodBuilder("get" + capitalizedPropertyName).addModifiers(property.getModifiersArray()).returns(propertyType).addStatement("return this." + propertyName, new Object[0]).build());
            if (!(objectDef instanceof ClassDef)) continue;
            builder.addMethod(MethodSpec.methodBuilder("set" + capitalizedPropertyName).addModifiers(property.getModifiersArray()).addParameter(ParameterSpec.builder(propertyType, propertyName, new Modifier[0]).build()).addStatement("this." + propertyName + " = " + propertyName, new Object[0]).build());
        }
    }

    private MethodSpec asMethodSpec(ObjectDef objectDef, MethodDef method) {
        String methodName = method.getName();
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder(methodName).addModifiers(method.getModifiersArray()).addParameters(method.getParameters().stream().map(param -> ParameterSpec.builder(this.asType(param.getType(), objectDef), param.getName(), param.getModifiersArray()).addAnnotations(param.getAnnotations().stream().map(this::asAnnotationSpec).toList()).build()).toList());
        if (!methodName.equals("<init>")) {
            methodBuilder.returns(this.asType(method.getReturnType(), objectDef));
        }
        method.getJavadoc().forEach(x$0 -> methodBuilder.addJavadoc((String)x$0, new Object[0]));
        for (AnnotationDef annotation : method.getAnnotations()) {
            methodBuilder.addAnnotation(this.asAnnotationSpec(annotation));
        }
        for (TypeDef type : method.getThrowTypes()) {
            methodBuilder.addException(this.asType(type, objectDef));
        }
        method.getStatements().stream().map(st -> this.renderStatementCodeBlock(objectDef, method, Map.of(), (StatementDef)st)).forEach(methodBuilder::addCode);
        return methodBuilder.build();
    }

    private TypeVariableName asTypeVariable(TypeDef.TypeVariable tv, ObjectDef objectDef) {
        return TypeVariableName.get(tv.name(), (TypeName[])tv.bounds().stream().map(t -> this.asType((TypeDef)t, objectDef)).toArray(TypeName[]::new));
    }

    private AnnotationSpec asAnnotationSpec(AnnotationDef annotationDef) {
        AnnotationSpec.Builder builder = AnnotationSpec.builder(ClassName.bestGuess(annotationDef.getType().getCanonicalName()));
        for (Map.Entry e : annotationDef.getValues().entrySet()) {
            this.addAnnotationValue(builder, (String)e.getKey(), e.getValue());
        }
        return builder.build();
    }

    private void addAnnotationValue(AnnotationSpec.Builder builder, String memberName, Object value) {
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            collection.forEach(v -> this.addAnnotationValue(builder, memberName, v));
        } else if (value instanceof AnnotationDef) {
            AnnotationDef annotationValue = (AnnotationDef)value;
            builder.addMember(memberName, this.asAnnotationSpec(annotationValue));
        } else if (value instanceof VariableDef) {
            VariableDef variableDef = (VariableDef)value;
            builder.addMember(memberName, this.renderVariable(null, null, Map.of(), variableDef));
        } else if (value instanceof Class) {
            builder.addMember(memberName, "$T.class", value);
        } else if (value instanceof Enum) {
            builder.addMember(memberName, "$T.$L", value.getClass(), ((Enum)value).name());
        } else if (value instanceof String) {
            builder.addMember(memberName, "$S", value);
        } else if (value instanceof Float) {
            builder.addMember(memberName, "$Lf", value);
        } else if (value instanceof Character) {
            builder.addMember(memberName, "'$L'", Util.characterLiteralWithoutSingleQuotes(((Character)value).charValue()));
        } else if (value instanceof ClassTypeDef) {
            ClassTypeDef typeDef = (ClassTypeDef)value;
            builder.addMember(memberName, "$L.class", typeDef.getSimpleName());
        } else {
            builder.addMember(memberName, "$L", value);
        }
    }

    private TypeName asType(TypeDef typeDef, ObjectDef objectDef) {
        if (typeDef.equals(TypeDef.THIS)) {
            if (objectDef == null) {
                throw new IllegalStateException("This type is used outside of the instance scope!");
            }
            return this.asType((TypeDef)objectDef.asTypeDef(), null);
        }
        if (typeDef.equals(TypeDef.SUPER)) {
            if (objectDef == null) {
                throw new IllegalStateException("Super type is used outside of the instance scope!");
            }
            if (objectDef instanceof ClassDef) {
                ClassDef classDef = (ClassDef)objectDef;
                return this.asType((TypeDef)Objects.requireNonNullElse(classDef.getSuperclass(), ClassTypeDef.OBJECT), objectDef);
            }
            if (objectDef instanceof EnumDef) {
                return JavaPoetSourceGenerator.asClassType(ClassTypeDef.of(Enum.class));
            }
            throw new IllegalStateException("Super type is not supported for " + String.valueOf(objectDef));
        }
        if (typeDef instanceof TypeDef.Array) {
            TypeDef.Array array = (TypeDef.Array)typeDef;
            ArrayTypeName arrayTypeName = ArrayTypeName.of(this.asType(array.componentType(), objectDef));
            for (int i = 1; i < array.dimensions(); ++i) {
                arrayTypeName = ArrayTypeName.of(arrayTypeName);
            }
            return arrayTypeName;
        }
        if (typeDef instanceof ClassTypeDef.Parameterized) {
            ClassTypeDef.Parameterized parameterized = (ClassTypeDef.Parameterized)typeDef;
            return ParameterizedTypeName.get(JavaPoetSourceGenerator.asClassType(parameterized.rawType()), (TypeName[])parameterized.typeArguments().stream().map(t -> this.asType((TypeDef)t, objectDef)).toArray(TypeName[]::new));
        }
        if (typeDef instanceof TypeDef.Primitive) {
            TypeDef.Primitive primitive = (TypeDef.Primitive)typeDef;
            return switch (primitive.name()) {
                case "void" -> TypeName.VOID;
                case "byte" -> TypeName.BYTE;
                case "short" -> TypeName.SHORT;
                case "char" -> TypeName.CHAR;
                case "int" -> TypeName.INT;
                case "long" -> TypeName.LONG;
                case "float" -> TypeName.FLOAT;
                case "double" -> TypeName.DOUBLE;
                case "boolean" -> TypeName.BOOLEAN;
                default -> throw new IllegalStateException("Unrecognized primitive name: " + primitive.name());
            };
        }
        if (typeDef instanceof ClassTypeDef.AnnotatedClassTypeDef) {
            ClassTypeDef.AnnotatedClassTypeDef annotatedType = (ClassTypeDef.AnnotatedClassTypeDef)typeDef;
            List<AnnotationSpec> annotationsSpecs = annotatedType.annotations().stream().map(this::asAnnotationSpec).toList();
            return this.asType((TypeDef)annotatedType.typeDef(), objectDef).annotated(annotationsSpecs);
        }
        if (typeDef instanceof ClassTypeDef) {
            ClassTypeDef classType = (ClassTypeDef)typeDef;
            return ClassName.bestGuess(classType.getCanonicalName());
        }
        if (typeDef instanceof TypeDef.Wildcard) {
            TypeDef.Wildcard wildcard = (TypeDef.Wildcard)typeDef;
            if (!wildcard.lowerBounds().isEmpty()) {
                return WildcardTypeName.supertypeOf(this.asType((TypeDef)wildcard.lowerBounds().get(0), objectDef));
            }
            return WildcardTypeName.subtypeOf(this.asType((TypeDef)wildcard.upperBounds().get(0), objectDef));
        }
        if (typeDef instanceof TypeDef.TypeVariable) {
            TypeDef.TypeVariable typeVariable = (TypeDef.TypeVariable)typeDef;
            return this.asTypeVariable(typeVariable, objectDef);
        }
        if (typeDef instanceof TypeDef.AnnotatedTypeDef) {
            TypeDef.AnnotatedTypeDef annotatedType = (TypeDef.AnnotatedTypeDef)typeDef;
            List<AnnotationSpec> annotationsSpecs = annotatedType.annotations().stream().map(this::asAnnotationSpec).toList();
            return this.asType(annotatedType.typeDef(), objectDef).annotated(annotationsSpecs);
        }
        throw new IllegalStateException("Unrecognized type definition " + String.valueOf(typeDef));
    }

    private static ClassName asClassType(ClassTypeDef classTypeDef) {
        return ClassName.bestGuess(classTypeDef.getCanonicalName());
    }

    private CodeBlock renderStatement(@Nullable ObjectDef objectDef, MethodDef methodDef, Map<String, String> remappedLocals, StatementDef statementDef) {
        if (statementDef instanceof StatementDef.Throw) {
            StatementDef.Throw aThrow = (StatementDef.Throw)statementDef;
            return CodeBlock.concat(CodeBlock.of("throw ", new Object[0]), this.renderExpression(objectDef, methodDef, remappedLocals, aThrow.expression()));
        }
        if (statementDef instanceof StatementDef.Return) {
            StatementDef.Return aReturn = (StatementDef.Return)statementDef;
            if (aReturn.expression() == null) {
                return CodeBlock.of("return", new Object[0]);
            }
            return CodeBlock.concat(CodeBlock.of("return ", new Object[0]), this.renderExpression(objectDef, methodDef, remappedLocals, aReturn.expression()));
        }
        if (statementDef instanceof StatementDef.Assign) {
            StatementDef.Assign assign = (StatementDef.Assign)statementDef;
            return CodeBlock.concat(this.renderExpression(objectDef, methodDef, remappedLocals, (ExpressionDef)assign.variable()), CodeBlock.of(" = ", new Object[0]), this.renderExpression(objectDef, methodDef, remappedLocals, assign.expression()));
        }
        if (statementDef instanceof StatementDef.PutField) {
            StatementDef.PutField putField = (StatementDef.PutField)statementDef;
            VariableDef.Field field = putField.field();
            return CodeBlock.concat(this.renderExpression(objectDef, methodDef, remappedLocals, field.instance()), CodeBlock.of(".$L = ", field.name()), this.renderExpression(objectDef, methodDef, remappedLocals, putField.expression()));
        }
        if (statementDef instanceof StatementDef.PutStaticField) {
            StatementDef.PutStaticField putStaticField = (StatementDef.PutStaticField)statementDef;
            VariableDef.StaticField field = putStaticField.field();
            return CodeBlock.concat(CodeBlock.of("$T.$L", this.asType(field.type(), objectDef), field.name()), CodeBlock.of(" = ", new Object[0]), this.renderExpression(objectDef, methodDef, remappedLocals, putStaticField.expression()));
        }
        if (statementDef instanceof StatementDef.DefineAndAssign) {
            StatementDef.DefineAndAssign assign = (StatementDef.DefineAndAssign)statementDef;
            return CodeBlock.concat(CodeBlock.of("$T $L", this.asType(assign.variable().type(), objectDef), assign.variable().name()), CodeBlock.of(" = ", new Object[0]), this.renderExpression(objectDef, methodDef, remappedLocals, assign.expression()));
        }
        if (statementDef instanceof ExpressionDef) {
            ExpressionDef expressionDef = (ExpressionDef)statementDef;
            return this.renderExpression(objectDef, methodDef, remappedLocals, expressionDef);
        }
        throw new IllegalStateException("Unrecognized statement: " + String.valueOf(statementDef));
    }

    private CodeBlock renderStatementCodeBlock(@Nullable ObjectDef objectDef, MethodDef methodDef, Map<String, String> remappedLocals, StatementDef statementDef) {
        if (statementDef instanceof StatementDef.Multi) {
            StatementDef.Multi statements = (StatementDef.Multi)statementDef;
            CodeBlock.Builder builder = CodeBlock.builder();
            for (StatementDef statement : statements.statements()) {
                builder.add(this.renderStatementCodeBlock(objectDef, methodDef, remappedLocals, statement));
            }
            return builder.build();
        }
        if (statementDef instanceof StatementDef.Try) {
            StatementDef.Try tryStatement = (StatementDef.Try)statementDef;
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("try {\n", new Object[0]);
            builder.add(this.renderStatementCodeBlock(objectDef, methodDef, remappedLocals, tryStatement.statement()));
            int i = 0;
            for (StatementDef.Try.Catch aCatch : tryStatement.catches()) {
                String exceptionLocal = "e" + i++;
                builder.add(CodeBlock.of("\n} catch ($T $L) {", this.asType((TypeDef)aCatch.exception(), objectDef), exceptionLocal));
                LinkedHashMap<String, String> newRemappedLocals = new LinkedHashMap<String, String>(remappedLocals);
                newRemappedLocals.put(EXCEPTION_NAME, exceptionLocal);
                builder.add(this.renderStatementCodeBlock(objectDef, methodDef, newRemappedLocals, aCatch.statement()));
            }
            if (tryStatement.finallyStatement() != null) {
                builder.add("\n} finally {", new Object[0]);
                builder.add(this.renderStatementCodeBlock(objectDef, methodDef, remappedLocals, tryStatement.finallyStatement()));
            }
            builder.add("\n}", new Object[0]);
            return builder.build();
        }
        if (statementDef instanceof StatementDef.Synchronized) {
            StatementDef.Synchronized s = (StatementDef.Synchronized)statementDef;
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("synchronized (", new Object[0]);
            builder.add(this.renderExpression(objectDef, methodDef, remappedLocals, s.monitor()));
            builder.add(") {\n", new Object[0]);
            builder.add(this.renderStatementCodeBlock(objectDef, methodDef, remappedLocals, s.statement()));
            builder.add("\n}", new Object[0]);
            return builder.build();
        }
        if (statementDef instanceof StatementDef.If) {
            StatementDef.If ifStatement = (StatementDef.If)statementDef;
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("if (", new Object[0]);
            builder.add(this.renderExpression(objectDef, methodDef, remappedLocals, ifStatement.condition()));
            builder.add(") {\n", new Object[0]);
            builder.indent();
            builder.add(this.renderStatementCodeBlock(objectDef, methodDef, remappedLocals, ifStatement.statement()));
            builder.unindent();
            builder.add("}\n", new Object[0]);
            return builder.build();
        }
        if (statementDef instanceof StatementDef.IfElse) {
            StatementDef.IfElse ifStatement = (StatementDef.IfElse)statementDef;
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("if (", new Object[0]);
            builder.add(this.renderExpression(objectDef, methodDef, remappedLocals, ifStatement.condition()));
            builder.add(") {\n", new Object[0]);
            builder.indent();
            builder.add(this.renderStatementCodeBlock(objectDef, methodDef, remappedLocals, ifStatement.statement()));
            builder.unindent();
            builder.add("} else {\n", new Object[0]);
            builder.indent();
            builder.add(this.renderStatementCodeBlock(objectDef, methodDef, remappedLocals, ifStatement.elseStatement()));
            builder.unindent();
            builder.add("}\n", new Object[0]);
            return builder.build();
        }
        if (statementDef instanceof StatementDef.Switch) {
            StatementDef.Switch aSwitch = (StatementDef.Switch)statementDef;
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("switch (", new Object[0]);
            builder.add(this.renderExpression(objectDef, methodDef, remappedLocals, aSwitch.expression()));
            builder.add(") {\n", new Object[0]);
            builder.indent();
            for (Map.Entry e : aSwitch.cases().entrySet()) {
                builder.add("case ", new Object[0]);
                builder.add(this.renderConstantExpression(remappedLocals, (ExpressionDef.Constant)e.getKey()));
                builder.add(": {\n", new Object[0]);
                builder.indent();
                builder.add(this.renderStatementCodeBlock(objectDef, methodDef, remappedLocals, (StatementDef)e.getValue()));
                builder.unindent();
                builder.add("}\n", new Object[0]);
            }
            if (aSwitch.defaultCase() != null) {
                builder.add("default", new Object[0]);
                builder.add(": {\n", new Object[0]);
                builder.indent();
                builder.add(this.renderStatementCodeBlock(objectDef, methodDef, remappedLocals, aSwitch.defaultCase()));
                builder.unindent();
                builder.add("}\n", new Object[0]);
            }
            builder.unindent();
            builder.add("}\n", new Object[0]);
            return builder.build();
        }
        if (statementDef instanceof StatementDef.While) {
            StatementDef.While aWhile = (StatementDef.While)statementDef;
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("while (", new Object[0]);
            builder.add(this.renderExpression(objectDef, methodDef, remappedLocals, aWhile.expression()));
            builder.add(") {\n", new Object[0]);
            builder.indent();
            builder.add(this.renderStatementCodeBlock(objectDef, methodDef, remappedLocals, aWhile.statement()));
            builder.unindent();
            builder.add("}\n", new Object[0]);
            return builder.build();
        }
        return CodeBlock.builder().addStatement(this.renderStatement(objectDef, methodDef, remappedLocals, statementDef)).build();
    }

    private CodeBlock renderExpression(@Nullable ObjectDef objectDef, MethodDef methodDef, Map<String, String> remappedLocals, ExpressionDef expressionDef) {
        if (expressionDef instanceof ExpressionDef.ConditionExpressionDef) {
            ExpressionDef.ConditionExpressionDef conditionExpressionDef = (ExpressionDef.ConditionExpressionDef)expressionDef;
            return this.renderCondition(objectDef, methodDef, remappedLocals, conditionExpressionDef);
        }
        if (expressionDef instanceof ExpressionDef.NewInstance) {
            ExpressionDef.NewInstance newInstance = (ExpressionDef.NewInstance)expressionDef;
            return CodeBlock.concat(CodeBlock.of("new $L(", this.asType((TypeDef)newInstance.type(), objectDef)), newInstance.values().stream().map(exp -> this.renderExpression(objectDef, methodDef, remappedLocals, (ExpressionDef)exp)).collect(CodeBlock.joining(", ")), CodeBlock.of(")", new Object[0]));
        }
        if (expressionDef instanceof ExpressionDef.NewArrayOfSize) {
            ExpressionDef.NewArrayOfSize newArray = (ExpressionDef.NewArrayOfSize)expressionDef;
            return CodeBlock.of("new $T[$L]", this.asType(newArray.type().componentType(), objectDef), newArray.size());
        }
        if (expressionDef instanceof ExpressionDef.NewArrayInitialized) {
            ExpressionDef.NewArrayInitialized newArray = (ExpressionDef.NewArrayInitialized)expressionDef;
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("new $T[]{", this.asType(newArray.type().componentType(), objectDef));
            Iterator iterator = newArray.expressions().iterator();
            while (iterator.hasNext()) {
                ExpressionDef expression = (ExpressionDef)iterator.next();
                builder.add(this.renderExpression(objectDef, methodDef, remappedLocals, expression));
                if (!iterator.hasNext()) continue;
                builder.add(",", new Object[0]);
            }
            builder.add("}", new Object[0]);
            return builder.build();
        }
        if (expressionDef instanceof ExpressionDef.Cast) {
            ExpressionDef.Cast castExpressionDef = (ExpressionDef.Cast)expressionDef;
            if (castExpressionDef.type().equals(castExpressionDef.expressionDef().type())) {
                return this.renderExpression(objectDef, methodDef, remappedLocals, castExpressionDef.expressionDef());
            }
            ExpressionDef iterator = castExpressionDef.expressionDef();
            if (iterator instanceof VariableDef) {
                VariableDef variableDef = (VariableDef)iterator;
                return CodeBlock.concat(CodeBlock.of("($T) ", this.asType(castExpressionDef.type(), objectDef)), this.renderExpression(objectDef, methodDef, remappedLocals, (ExpressionDef)variableDef));
            }
            return CodeBlock.concat(CodeBlock.of("($T) (", this.asType(castExpressionDef.type(), objectDef)), this.renderExpression(objectDef, methodDef, remappedLocals, castExpressionDef.expressionDef()), CodeBlock.of(")", new Object[0]));
        }
        if (expressionDef instanceof ExpressionDef.Constant) {
            ExpressionDef.Constant constant = (ExpressionDef.Constant)expressionDef;
            return this.renderConstantExpression(remappedLocals, constant);
        }
        if (expressionDef instanceof ExpressionDef.InvokeInstanceMethod) {
            ExpressionDef.InvokeInstanceMethod invokeInstanceMethod = (ExpressionDef.InvokeInstanceMethod)expressionDef;
            MethodDef callMethod = invokeInstanceMethod.method();
            return CodeBlock.concat(CodeBlock.of(String.valueOf(this.renderExpression(objectDef, methodDef, remappedLocals, invokeInstanceMethod.instance())) + (String)(callMethod.isConstructor() ? "" : "." + callMethod.getName()) + "(", new Object[0]), invokeInstanceMethod.values().stream().map(exp -> this.renderExpression(objectDef, methodDef, remappedLocals, (ExpressionDef)exp)).collect(CodeBlock.joining(", ")), CodeBlock.of(")", new Object[0]));
        }
        if (expressionDef instanceof ExpressionDef.InvokeStaticMethod) {
            ExpressionDef.InvokeStaticMethod staticMethod = (ExpressionDef.InvokeStaticMethod)expressionDef;
            return CodeBlock.concat(CodeBlock.of("$T." + staticMethod.method().getName() + "(", this.asType((TypeDef)staticMethod.classDef(), objectDef)), staticMethod.values().stream().map(exp -> this.renderExpression(objectDef, methodDef, remappedLocals, (ExpressionDef)exp)).collect(CodeBlock.joining(", ")), CodeBlock.of(")", new Object[0]));
        }
        if (expressionDef instanceof ExpressionDef.GetPropertyValue) {
            ExpressionDef.GetPropertyValue getPropertyValue = (ExpressionDef.GetPropertyValue)expressionDef;
            return this.renderExpression(objectDef, methodDef, remappedLocals, JavaIdioms.getPropertyValue((ExpressionDef.GetPropertyValue)getPropertyValue));
        }
        if (expressionDef instanceof ExpressionDef.MathBinaryOperation) {
            ExpressionDef.MathBinaryOperation mathOperation = (ExpressionDef.MathBinaryOperation)expressionDef;
            return CodeBlock.concat(this.renderExpressionWithParentheses(objectDef, methodDef, remappedLocals, mathOperation.left()), CodeBlock.of(JavaPoetSourceGenerator.getMathOp(mathOperation), new Object[0]), this.renderExpressionWithParentheses(objectDef, methodDef, remappedLocals, mathOperation.right()));
        }
        if (expressionDef instanceof ExpressionDef.MathUnaryOperation) {
            ExpressionDef.MathUnaryOperation mathOperation = (ExpressionDef.MathUnaryOperation)expressionDef;
            return CodeBlock.concat(CodeBlock.of(JavaPoetSourceGenerator.getMathOp(mathOperation), new Object[0]), this.renderExpressionWithParentheses(objectDef, methodDef, remappedLocals, mathOperation.expression()));
        }
        if (expressionDef instanceof ExpressionDef.IfElse) {
            ExpressionDef.IfElse condition = (ExpressionDef.IfElse)expressionDef;
            return CodeBlock.concat(this.renderExpression(objectDef, methodDef, remappedLocals, condition.condition()), CodeBlock.of(" ? ", new Object[0]), this.renderExpression(objectDef, methodDef, remappedLocals, condition.ifExpression()), CodeBlock.of(" : ", new Object[0]), this.renderExpression(objectDef, methodDef, remappedLocals, condition.elseExpression()));
        }
        if (expressionDef instanceof ExpressionDef.Switch) {
            ExpressionDef.Switch aSwitch = (ExpressionDef.Switch)expressionDef;
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("switch (", new Object[0]);
            builder.add(this.renderExpression(objectDef, methodDef, remappedLocals, aSwitch.expression()));
            builder.add(") {\n", new Object[0]);
            builder.indent();
            for (Map.Entry e : aSwitch.cases().entrySet()) {
                builder.add("case ", new Object[0]);
                builder.add(this.renderConstantExpression(remappedLocals, (ExpressionDef.Constant)e.getKey()));
                builder.add(" -> ", new Object[0]);
                ExpressionDef value = (ExpressionDef)e.getValue();
                builder.add(this.renderExpression(objectDef, methodDef, remappedLocals, value));
                if (value instanceof ExpressionDef.SwitchYieldCase) {
                    builder.add("\n", new Object[0]);
                    continue;
                }
                builder.add(";\n", new Object[0]);
            }
            if (aSwitch.defaultCase() != null) {
                builder.add("default", new Object[0]);
                builder.add(" -> ", new Object[0]);
                builder.add(this.renderExpression(objectDef, methodDef, remappedLocals, aSwitch.defaultCase()));
                if (aSwitch.defaultCase() instanceof ExpressionDef.SwitchYieldCase) {
                    builder.add("\n", new Object[0]);
                } else {
                    builder.add(";\n", new Object[0]);
                }
            }
            builder.unindent();
            builder.add("}", new Object[0]);
            return builder.build();
        }
        if (expressionDef instanceof ExpressionDef.SwitchYieldCase) {
            ExpressionDef.SwitchYieldCase switchYieldCase = (ExpressionDef.SwitchYieldCase)expressionDef;
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("{\n", new Object[0]);
            builder.indent();
            StatementDef statement = switchYieldCase.statement();
            List flatten = statement.flatten();
            if (flatten.isEmpty()) {
                throw new IllegalStateException("SwitchYieldCase did not return any statements");
            }
            StatementDef last = (StatementDef)flatten.get(flatten.size() - 1);
            List rest = flatten.subList(0, flatten.size() - 1);
            for (StatementDef statementDef : rest) {
                builder.add(this.renderStatementCodeBlock(objectDef, methodDef, remappedLocals, statementDef));
            }
            this.renderYield(builder, methodDef, remappedLocals, last, objectDef);
            builder.unindent();
            builder.add("}", new Object[0]);
            String str = builder.build().toString();
            return CodeBlock.ofWithoutFormat(str);
        }
        if (expressionDef instanceof VariableDef) {
            VariableDef variableDef = (VariableDef)expressionDef;
            return this.renderVariable(objectDef, methodDef, remappedLocals, variableDef);
        }
        if (expressionDef instanceof ExpressionDef.InvokeGetClassMethod) {
            ExpressionDef.InvokeGetClassMethod invokeGetClassMethod = (ExpressionDef.InvokeGetClassMethod)expressionDef;
            return this.renderExpression(objectDef, methodDef, remappedLocals, JavaIdioms.getClass((ExpressionDef.InvokeGetClassMethod)invokeGetClassMethod));
        }
        if (expressionDef instanceof ExpressionDef.InvokeHashCodeMethod) {
            ExpressionDef.InvokeHashCodeMethod invokeHashCodeMethod = (ExpressionDef.InvokeHashCodeMethod)expressionDef;
            return this.renderExpression(objectDef, methodDef, remappedLocals, JavaIdioms.hashCode((ExpressionDef.InvokeHashCodeMethod)invokeHashCodeMethod));
        }
        throw new IllegalStateException("Unrecognized expression: " + String.valueOf(expressionDef));
    }

    private static String getMathOp(ExpressionDef.MathBinaryOperation mathOperation) {
        return switch (mathOperation.opType()) {
            default -> throw new IncompatibleClassChangeError();
            case ExpressionDef.MathBinaryOperation.OpType.ADDITION -> " + ";
            case ExpressionDef.MathBinaryOperation.OpType.SUBTRACTION -> " - ";
            case ExpressionDef.MathBinaryOperation.OpType.MULTIPLICATION -> " * ";
            case ExpressionDef.MathBinaryOperation.OpType.DIVISION -> " / ";
            case ExpressionDef.MathBinaryOperation.OpType.MODULUS -> " % ";
            case ExpressionDef.MathBinaryOperation.OpType.BITWISE_AND -> " & ";
            case ExpressionDef.MathBinaryOperation.OpType.BITWISE_OR -> " | ";
            case ExpressionDef.MathBinaryOperation.OpType.BITWISE_XOR -> " ^ ";
            case ExpressionDef.MathBinaryOperation.OpType.BITWISE_LEFT_SHIFT -> " << ";
            case ExpressionDef.MathBinaryOperation.OpType.BITWISE_RIGHT_SHIFT -> " >> ";
            case ExpressionDef.MathBinaryOperation.OpType.BITWISE_UNSIGNED_RIGHT_SHIFT -> " >>> ";
        };
    }

    private static String getMathOp(ExpressionDef.MathUnaryOperation mathOperation) {
        switch (mathOperation.opType()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case NEGATE: 
        }
        return "-";
    }

    private CodeBlock renderExpressionWithParentheses(@Nullable ObjectDef objectDef, MethodDef methodDef, Map<String, String> remappedLocals, ExpressionDef expressionDef) {
        CodeBlock rendered = this.renderExpression(objectDef, methodDef, remappedLocals, expressionDef);
        while (expressionDef instanceof ExpressionDef.Cast) {
            ExpressionDef.Cast cast = (ExpressionDef.Cast)expressionDef;
            expressionDef = cast.expressionDef();
        }
        if (expressionDef instanceof StatementDef || expressionDef instanceof VariableDef || expressionDef instanceof ExpressionDef.And || expressionDef instanceof ExpressionDef.Constant) {
            return rendered;
        }
        return this.addParentheses(rendered);
    }

    private CodeBlock addParentheses(CodeBlock rendered) {
        return CodeBlock.concat(CodeBlock.of("(", new Object[0]), rendered, CodeBlock.of(")", new Object[0]));
    }

    private CodeBlock renderCondition(@Nullable ObjectDef objectDef, MethodDef methodDef, Map<String, String> remappedLocals, ExpressionDef.ConditionExpressionDef expressionDef) {
        if (expressionDef instanceof ExpressionDef.IsNull) {
            ExpressionDef.IsNull isNull = (ExpressionDef.IsNull)expressionDef;
            return this.renderCondition(objectDef, methodDef, remappedLocals, (ExpressionDef.ConditionExpressionDef)new ExpressionDef.ComparisonOperation(ExpressionDef.ComparisonOperation.OpType.EQUAL_TO, isNull.expression(), (ExpressionDef)ExpressionDef.nullValue()));
        }
        if (expressionDef instanceof ExpressionDef.IsNotNull) {
            ExpressionDef.IsNotNull isNotNull = (ExpressionDef.IsNotNull)expressionDef;
            return this.renderCondition(objectDef, methodDef, remappedLocals, (ExpressionDef.ConditionExpressionDef)new ExpressionDef.ComparisonOperation(ExpressionDef.ComparisonOperation.OpType.NOT_EQUAL_TO, isNotNull.expression(), (ExpressionDef)ExpressionDef.nullValue()));
        }
        if (expressionDef instanceof ExpressionDef.IsTrue) {
            ExpressionDef.IsTrue isTrue = (ExpressionDef.IsTrue)expressionDef;
            return this.renderExpressionWithParentheses(objectDef, methodDef, remappedLocals, isTrue.expression());
        }
        if (expressionDef instanceof ExpressionDef.IsFalse) {
            ExpressionDef.IsFalse isFalse = (ExpressionDef.IsFalse)expressionDef;
            return CodeBlock.concat(CodeBlock.of("!", new Object[0]), this.renderExpressionWithParentheses(objectDef, methodDef, remappedLocals, isFalse.expression()));
        }
        if (expressionDef instanceof ExpressionDef.ComparisonOperation) {
            ExpressionDef.ComparisonOperation comparisonOperation = (ExpressionDef.ComparisonOperation)expressionDef;
            return CodeBlock.concat(this.renderExpressionWithParentheses(objectDef, methodDef, remappedLocals, comparisonOperation.left()), CodeBlock.of(JavaPoetSourceGenerator.getOpType(comparisonOperation), new Object[0]), this.renderExpressionWithParentheses(objectDef, methodDef, remappedLocals, comparisonOperation.right()));
        }
        if (expressionDef instanceof ExpressionDef.And) {
            ExpressionDef.And andExpressionDef = (ExpressionDef.And)expressionDef;
            return CodeBlock.concat(this.renderCondition(objectDef, methodDef, remappedLocals, andExpressionDef.left()), CodeBlock.of(" && ", new Object[0]), this.renderCondition(objectDef, methodDef, remappedLocals, andExpressionDef.right()));
        }
        if (expressionDef instanceof ExpressionDef.Or) {
            ExpressionDef.Or orExpressionDef = (ExpressionDef.Or)expressionDef;
            return this.addParentheses(CodeBlock.concat(this.renderCondition(objectDef, methodDef, remappedLocals, orExpressionDef.left()), CodeBlock.of(" || ", new Object[0]), this.renderCondition(objectDef, methodDef, remappedLocals, orExpressionDef.right())));
        }
        if (expressionDef instanceof ExpressionDef.EqualsStructurally) {
            ExpressionDef.EqualsStructurally equalsStructurally = (ExpressionDef.EqualsStructurally)expressionDef;
            ExpressionDef left = equalsStructurally.instance();
            TypeDef leftType = left.type();
            ExpressionDef right = equalsStructurally.other();
            TypeDef rightType = right.type();
            if (leftType.isPrimitive() || rightType.isPrimitive()) {
                return this.renderEqualsReferentially(objectDef, methodDef, remappedLocals, left, right);
            }
            return this.renderExpressionWithParentheses(objectDef, methodDef, remappedLocals, JavaIdioms.equalsStructurally((ExpressionDef.EqualsStructurally)equalsStructurally));
        }
        if (expressionDef instanceof ExpressionDef.NotEqualsStructurally) {
            ExpressionDef.NotEqualsStructurally notEqualsStructurally = (ExpressionDef.NotEqualsStructurally)expressionDef;
            ExpressionDef left = notEqualsStructurally.instance();
            TypeDef leftType = left.type();
            ExpressionDef right = notEqualsStructurally.other();
            TypeDef rightType = right.type();
            if (leftType.isPrimitive() || rightType.isPrimitive()) {
                return this.renderEqualsReferentially(objectDef, methodDef, remappedLocals, left, right);
            }
            return this.renderExpressionWithParentheses(objectDef, methodDef, remappedLocals, (ExpressionDef)JavaIdioms.equalsStructurally((ExpressionDef)notEqualsStructurally.instance(), (ExpressionDef)notEqualsStructurally.other()).isFalse());
        }
        if (expressionDef instanceof ExpressionDef.EqualsReferentially) {
            ExpressionDef.EqualsReferentially equalsReferentially = (ExpressionDef.EqualsReferentially)expressionDef;
            ExpressionDef left = equalsReferentially.instance();
            ExpressionDef right = equalsReferentially.other();
            return this.renderEqualsReferentially(objectDef, methodDef, remappedLocals, left, right);
        }
        if (expressionDef instanceof ExpressionDef.NotEqualsReferentially) {
            ExpressionDef.NotEqualsReferentially notEqualsReferentially = (ExpressionDef.NotEqualsReferentially)expressionDef;
            ExpressionDef left = notEqualsReferentially.instance();
            ExpressionDef right = notEqualsReferentially.other();
            return this.renderNotEqualsReferentially(objectDef, methodDef, remappedLocals, left, right);
        }
        throw new IllegalStateException("Unrecognized condition: " + String.valueOf(expressionDef));
    }

    private static String getOpType(ExpressionDef.ComparisonOperation comparisonOperation) {
        return switch (comparisonOperation.opType()) {
            default -> throw new IncompatibleClassChangeError();
            case ExpressionDef.ComparisonOperation.OpType.EQUAL_TO -> " == ";
            case ExpressionDef.ComparisonOperation.OpType.NOT_EQUAL_TO -> " != ";
            case ExpressionDef.ComparisonOperation.OpType.GREATER_THAN -> " > ";
            case ExpressionDef.ComparisonOperation.OpType.LESS_THAN -> " < ";
            case ExpressionDef.ComparisonOperation.OpType.GREATER_THAN_OR_EQUAL -> " >= ";
            case ExpressionDef.ComparisonOperation.OpType.LESS_THAN_OR_EQUAL -> " <= ";
        };
    }

    private CodeBlock renderEqualsReferentially(ObjectDef objectDef, MethodDef methodDef, Map<String, String> remappedLocals, ExpressionDef left, ExpressionDef right) {
        return CodeBlock.builder().add(this.renderExpressionWithParentheses(objectDef, methodDef, remappedLocals, left)).add(" == ", new Object[0]).add(this.renderExpressionWithParentheses(objectDef, methodDef, remappedLocals, right)).build();
    }

    private CodeBlock renderNotEqualsReferentially(ObjectDef objectDef, MethodDef methodDef, Map<String, String> remappedLocals, ExpressionDef left, ExpressionDef right) {
        return CodeBlock.builder().add(this.renderExpressionWithParentheses(objectDef, methodDef, remappedLocals, left)).add(" != ", new Object[0]).add(this.renderExpressionWithParentheses(objectDef, methodDef, remappedLocals, right)).build();
    }

    private void renderYield(CodeBlock.Builder builder, MethodDef methodDef, Map<String, String> remappedLocals, StatementDef statementDef, ObjectDef objectDef) {
        if (!(statementDef instanceof StatementDef.Return)) {
            throw new IllegalStateException("The last statement of SwitchYieldCase should be a return. Found: " + String.valueOf(statementDef));
        }
        StatementDef.Return aReturn = (StatementDef.Return)statementDef;
        builder.addStatement(CodeBlock.concat(CodeBlock.of("yield ", new Object[0]), this.renderExpression(objectDef, methodDef, remappedLocals, aReturn.expression())));
    }

    private CodeBlock renderConstantExpression(Map<String, String> remappedLocals, ExpressionDef.Constant constant) {
        ClassTypeDef classTypeDef;
        TypeDef type = constant.type();
        Object value = constant.value();
        if (value == null) {
            return CodeBlock.of("null", new Object[0]);
        }
        if (type instanceof ClassTypeDef && (classTypeDef = (ClassTypeDef)type).isEnum()) {
            String string;
            if (value instanceof Enum) {
                Enum anEnum = (Enum)value;
                string = anEnum.name();
            } else {
                string = value.toString();
            }
            return this.renderExpression(null, null, remappedLocals, (ExpressionDef)classTypeDef.getStaticField(string, type));
        }
        if (type instanceof TypeDef.Primitive) {
            TypeDef.Primitive primitive = (TypeDef.Primitive)type;
            return switch (primitive.name()) {
                case "long" -> CodeBlock.of(String.valueOf(value) + "l", new Object[0]);
                case "float" -> CodeBlock.of(String.valueOf(value) + "f", new Object[0]);
                case "double" -> CodeBlock.of(String.valueOf(value) + "d", new Object[0]);
                default -> CodeBlock.of("$L", value);
            };
        }
        if (type instanceof TypeDef.Array) {
            TypeDef.Array arrayDef = (TypeDef.Array)type;
            if (value.getClass().isArray()) {
                String typeName;
                Object array = value;
                CodeBlock values = IntStream.range(0, Array.getLength(array)).mapToObj(i -> this.renderConstantExpression(remappedLocals, new ExpressionDef.Constant(arrayDef.componentType(), Array.get(array, i)))).collect(CodeBlock.joining(", "));
                TypeDef typeDef = arrayDef.componentType();
                if (typeDef instanceof ClassTypeDef) {
                    ClassTypeDef arrayClassTypeDef = (ClassTypeDef)typeDef;
                    typeName = arrayClassTypeDef.getSimpleName();
                } else {
                    typeDef = arrayDef.componentType();
                    if (typeDef instanceof TypeDef.Primitive) {
                        TypeDef.Primitive arrayPrimitive = (TypeDef.Primitive)typeDef;
                        typeName = arrayPrimitive.name();
                    } else {
                        throw new IllegalStateException("Unrecognized expression: " + String.valueOf(constant));
                    }
                }
                return CodeBlock.concat(CodeBlock.of("new $N[] {", typeName), values, CodeBlock.of("}", new Object[0]));
            }
        } else if (type instanceof ClassTypeDef) {
            ClassTypeDef classTypeDef2 = (ClassTypeDef)type;
            String name = classTypeDef2.getName();
            if (ClassUtils.isJavaLangType((String)name)) {
                return switch (name) {
                    case "java.lang.Long" -> CodeBlock.of(String.valueOf(value) + "l", new Object[0]);
                    case "java.lang.Float" -> CodeBlock.of(String.valueOf(value) + "f", new Object[0]);
                    case "java.lang.Double" -> CodeBlock.of(String.valueOf(value) + "d", new Object[0]);
                    case "java.lang.String" -> CodeBlock.of("$S", value);
                    default -> CodeBlock.of("$L", value);
                };
            }
            return CodeBlock.of("$L", value);
        }
        throw new IllegalStateException("Unrecognized expression: " + String.valueOf(constant));
    }

    private CodeBlock renderVariable(@Nullable ObjectDef objectDef, @Nullable MethodDef methodDef, Map<String, String> remappedLocals, VariableDef variableDef) {
        if (variableDef instanceof VariableDef.ExceptionVar) {
            return CodeBlock.of(Objects.requireNonNull(remappedLocals.get(EXCEPTION_NAME)), new Object[0]);
        }
        if (variableDef instanceof VariableDef.Local) {
            VariableDef.Local localVariableDef = (VariableDef.Local)variableDef;
            return CodeBlock.of(localVariableDef.name(), new Object[0]);
        }
        if (variableDef instanceof VariableDef.MethodParameter) {
            VariableDef.MethodParameter parameterVariableDef = (VariableDef.MethodParameter)variableDef;
            if (methodDef == null) {
                throw new IllegalStateException("Accessing method parameters is not available");
            }
            methodDef.getParameter(parameterVariableDef.name());
            return CodeBlock.of(parameterVariableDef.name(), new Object[0]);
        }
        if (variableDef instanceof VariableDef.StaticField) {
            VariableDef.StaticField staticField = (VariableDef.StaticField)variableDef;
            return CodeBlock.of("$T.$L", this.asType((TypeDef)staticField.ownerType(), objectDef), staticField.name());
        }
        if (variableDef instanceof VariableDef.Field) {
            VariableDef.Field field = (VariableDef.Field)variableDef;
            if (objectDef == null) {
                throw new IllegalStateException("Accessing 'this' is not available");
            }
            if (objectDef instanceof ClassDef) {
                ClassDef classDef = (ClassDef)objectDef;
                if (!classDef.hasField(field.name())) {
                    throw new IllegalStateException("Field '" + field.name() + "' is not available in [" + String.valueOf(classDef) + "]:" + String.valueOf(classDef.getFields()));
                }
            } else if (objectDef instanceof EnumDef) {
                EnumDef enumDef = (EnumDef)objectDef;
                if (!enumDef.hasField(field.name())) {
                    throw new IllegalStateException("Field '" + field.name() + "' is not available in [" + String.valueOf(enumDef) + "]:" + String.valueOf(enumDef.getProperties()));
                }
            } else {
                throw new IllegalStateException("Field access not supported on the object definition: " + String.valueOf(objectDef));
            }
            return CodeBlock.of(String.valueOf(this.renderExpression(objectDef, methodDef, remappedLocals, field.instance())) + "." + field.name(), new Object[0]);
        }
        if (variableDef instanceof VariableDef.This) {
            if (objectDef == null) {
                throw new IllegalStateException("Accessing 'this' is not available");
            }
            return CodeBlock.of("this", new Object[0]);
        }
        if (variableDef instanceof VariableDef.Super) {
            VariableDef.Super aSuper = (VariableDef.Super)variableDef;
            if (objectDef == null) {
                throw new IllegalStateException("Accessing 'super' is not available");
            }
            if (aSuper.type() != TypeDef.SUPER) {
                return CodeBlock.of("$T.super", this.asType((TypeDef)aSuper.type(), objectDef));
            }
            return CodeBlock.of("super", new Object[0]);
        }
        throw new IllegalStateException("Unrecognized variable: " + String.valueOf(variableDef));
    }
}

