/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.generator.visitors;

import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.processing.ProcessingException;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.sourcegen.annotations.Builder;
import io.micronaut.sourcegen.annotations.Singular;
import io.micronaut.sourcegen.generator.SourceGenerator;
import io.micronaut.sourcegen.generator.SourceGenerators;
import io.micronaut.sourcegen.generator.visitors.Singulars;
import io.micronaut.sourcegen.model.ClassDef;
import io.micronaut.sourcegen.model.ClassTypeDef;
import io.micronaut.sourcegen.model.ExpressionDef;
import io.micronaut.sourcegen.model.FieldDef;
import io.micronaut.sourcegen.model.MethodDef;
import io.micronaut.sourcegen.model.ObjectDef;
import io.micronaut.sourcegen.model.ParameterDef;
import io.micronaut.sourcegen.model.StatementDef;
import io.micronaut.sourcegen.model.TypeDef;
import io.micronaut.sourcegen.model.VariableDef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import javax.lang.model.element.Modifier;

@Internal
public final class BuilderAnnotationVisitor
implements TypeElementVisitor<Builder, Object> {
    private static final String BUILDER_ANNOTATED_WITH_MEMBER = "annotatedWith";
    private final Set<String> processed = new HashSet<String>();

    @NonNull
    public TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    public void start(VisitorContext visitorContext) {
        this.processed.clear();
    }

    public Set<String> getSupportedAnnotationNames() {
        return Set.of(Builder.class.getName());
    }

    public void visitClass(ClassElement element, VisitorContext context) {
        if (this.processed.contains(element.getName())) {
            return;
        }
        try {
            String simpleName = element.getSimpleName() + "Builder";
            String builderClassName = element.getPackageName() + "." + simpleName;
            ClassTypeDef builderType = ClassTypeDef.of((String)builderClassName);
            ClassDef.ClassDefBuilder builder = (ClassDef.ClassDefBuilder)ClassDef.builder((String)builderClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            BuilderAnnotationVisitor.addAnnotations(builder, element.getAnnotation(Builder.class));
            List properties = element.getBeanProperties();
            for (PropertyElement beanProperty : properties) {
                BuilderAnnotationVisitor.createModifyPropertyMethod(builder, beanProperty, ExpressionDef::returning);
            }
            builder.addMethod(MethodDef.constructor().build());
            if (!properties.isEmpty()) {
                builder.addMethod(BuilderAnnotationVisitor.createAllPropertiesConstructor(properties));
            }
            builder.addMethod(this.createBuilderMethod(builderType));
            builder.addMethod(BuilderAnnotationVisitor.createBuildMethod(element));
            SourceGenerator sourceGenerator = SourceGenerators.findByLanguage(context.getLanguage()).orElse(null);
            if (sourceGenerator == null) {
                return;
            }
            ClassDef builderDef = builder.build();
            this.processed.add(element.getName());
            sourceGenerator.write((ObjectDef)builderDef, context, new Element[]{element});
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            SourceGenerators.handleFatalException((Element)element, Builder.class, e, exception -> {
                this.processed.remove(element.getName());
                throw exception;
            });
        }
    }

    static void addAnnotations(ClassDef.ClassDefBuilder builder, AnnotationValue<?> annotation) {
        Optional annotatedWith = annotation.getConvertibleValues().get((CharSequence)BUILDER_ANNOTATED_WITH_MEMBER, AnnotationClassValue[].class);
        if (annotatedWith.isEmpty()) {
            builder.addAnnotation(Introspected.class);
        } else {
            for (AnnotationClassValue value : (AnnotationClassValue[])annotatedWith.get()) {
                builder.addAnnotation(value.getName());
            }
        }
    }

    static MethodDef createAllPropertiesConstructor(List<PropertyElement> properties) {
        MethodDef.MethodDefBuilder builder = (MethodDef.MethodDefBuilder)MethodDef.constructor().addAnnotation(Creator.class);
        int index = 0;
        for (PropertyElement parameter : properties) {
            int parameterIndex = index++;
            builder.addParameter(ParameterDef.of((String)parameter.getName(), (TypeDef)TypeDef.of((TypedElement)parameter.getType())));
            builder.addStatement((aThis, methodParameters) -> {
                VariableDef.MethodParameter methodParameter = (VariableDef.MethodParameter)methodParameters.get(parameterIndex);
                VariableDef.Field propertyField = aThis.field(methodParameter.name(), methodParameter.type());
                if (parameter.hasAnnotation(Singular.class)) {
                    if (parameter.getType().getName().equals(Iterable.class.getName())) {
                        return BuilderAnnotationVisitor.iterableToArrayListStatement(propertyField, methodParameter);
                    }
                    if (parameter.getType().isAssignable(Map.class)) {
                        return BuilderAnnotationVisitor.mapToArrayListStatement(propertyField, methodParameter);
                    }
                    return propertyField.put((ExpressionDef)ClassTypeDef.of(ArrayList.class).instantiate(new ExpressionDef[]{methodParameter}));
                }
                return propertyField.put((ExpressionDef)methodParameter);
            });
        }
        return builder.build();
    }

    private static StatementDef iterableToArrayListStatement(VariableDef.Field propertyField, VariableDef.MethodParameter parameter) {
        return ClassTypeDef.of(ArrayList.class).instantiate(new ExpressionDef[0]).newLocal(parameter.name() + "ArrayList", arrayListVar -> parameter.invoke("iterator", (TypeDef)ClassTypeDef.of(Iterator.class), new ExpressionDef[0]).newLocal(parameter.name() + "Iterator", iteratorVar -> parameter.ifNonNull((StatementDef)iteratorVar.invoke("hasNext", (TypeDef)TypeDef.primitive(Boolean.TYPE), new ExpressionDef[0]).whileLoop((StatementDef)arrayListVar.invoke("add", TypeDef.of(Boolean.TYPE), new ExpressionDef[]{iteratorVar.invoke("next", (TypeDef)ClassTypeDef.OBJECT, new ExpressionDef[0])}))).after((StatementDef)propertyField.assign((ExpressionDef)arrayListVar))));
    }

    private static StatementDef mapToArrayListStatement(VariableDef.Field propertyField, VariableDef.MethodParameter parameter) {
        return propertyField.put((ExpressionDef)ClassTypeDef.of(ArrayList.class).instantiate(new ExpressionDef[]{parameter.invoke("entrySet", (TypeDef)ClassTypeDef.of(Map.Entry.class), new ExpressionDef[0])}));
    }

    private MethodDef createBuilderMethod(ClassTypeDef builderType) {
        return ((MethodDef.MethodDefBuilder)MethodDef.builder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC})).returns((TypeDef)builderType).addStatement(builderType.instantiate(new ExpressionDef[0]).returning()).build();
    }

    static void createModifyPropertyMethod(ClassDef.ClassDefBuilder classDefBuilder, PropertyElement beanProperty, Function<VariableDef.This, StatementDef> returningExpressionProvider) {
        if (beanProperty.hasAnnotation(Singular.class)) {
            BuilderAnnotationVisitor.createSingularPropertyMethods(classDefBuilder, beanProperty, returningExpressionProvider);
        } else {
            BuilderAnnotationVisitor.createDefaultModifyPropertyMethod(classDefBuilder, beanProperty, returningExpressionProvider);
        }
    }

    private static void createDefaultModifyPropertyMethod(ClassDef.ClassDefBuilder classDefBuilder, PropertyElement beanProperty, Function<VariableDef.This, StatementDef> returningExpressionProvider) {
        TypeDef propertyTypeDef = TypeDef.of((TypedElement)beanProperty.getType());
        FieldDef field = BuilderAnnotationVisitor.createField(beanProperty, propertyTypeDef);
        classDefBuilder.addField(field);
        String propertyName = beanProperty.getSimpleName();
        classDefBuilder.addMethod(((MethodDef.MethodDefBuilder)MethodDef.builder((String)propertyName).addModifiers(new Modifier[]{Modifier.PUBLIC})).addParameter(propertyName, propertyTypeDef).build((self, parameterDefs) -> StatementDef.multi((StatementDef[])new StatementDef[]{self.field(field).assign((ExpressionDef)parameterDefs.get(0)), (StatementDef)returningExpressionProvider.apply((VariableDef.This)self)})));
    }

    private static FieldDef createField(PropertyElement beanProperty, TypeDef type) {
        TypeDef fieldType = type.makeNullable();
        if (!fieldType.isNullable()) {
            throw new IllegalStateException("Could not make the field nullable");
        }
        FieldDef.FieldDefBuilder fieldDef = (FieldDef.FieldDefBuilder)FieldDef.builder((String)beanProperty.getSimpleName()).ofType(fieldType).addModifiers(new Modifier[]{Modifier.PROTECTED});
        try {
            beanProperty.stringValue(Bindable.class, "defaultValue").ifPresent(defaultValue -> fieldDef.initializer(ExpressionDef.constant((ClassElement)beanProperty.getType(), (TypeDef)fieldType, (Object)defaultValue)));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Invalid or unsupported default value specified: " + (String)beanProperty.stringValue(Bindable.class, "defaultValue").orElse(null));
        }
        return fieldDef.build();
    }

    private static void createSingularPropertyMethods(ClassDef.ClassDefBuilder classBuilder, PropertyElement beanProperty, Function<VariableDef.This, StatementDef> returningExpressionProvider) {
        String propertyName = beanProperty.getSimpleName();
        String singularName = beanProperty.stringValue(Singular.class).orElse(null);
        if (singularName == null && (singularName = Singulars.singularize(propertyName)) == null) {
            throw new IllegalStateException("Cannot determine singular name for property: " + beanProperty.getName() + ". Please specify a singular name: @Singular(\"singularName\")");
        }
        if (beanProperty.getType().isAssignable(Iterable.class)) {
            TypeDef singularTypeDef = beanProperty.getType().getFirstTypeArgument().map(ClassTypeDef::of).orElse((TypeDef)TypeDef.OBJECT);
            ClassTypeDef fieldType = TypeDef.parameterized(ArrayList.class, (TypeDef[])new TypeDef[]{singularTypeDef});
            FieldDef field = BuilderAnnotationVisitor.createField(beanProperty, (TypeDef)fieldType);
            classBuilder.addField(field);
            classBuilder.addMethod(((MethodDef.MethodDefBuilder)MethodDef.builder((String)propertyName).addModifiers(new Modifier[]{Modifier.PUBLIC})).addParameter(propertyName, (TypeDef)TypeDef.parameterized(Collection.class, (TypeDef[])new TypeDef[]{singularTypeDef})).build((self, parameterDefs) -> StatementDef.multi((StatementDef[])new StatementDef[]{((VariableDef.MethodParameter)parameterDefs.get(0)).isNull().doIf((StatementDef)ClassTypeDef.of(NullPointerException.class).instantiate(new ExpressionDef[]{ExpressionDef.constant((Object)(propertyName + " cannot be null"))}).doThrow()), self.field(field).isNull().doIf((StatementDef)self.field(field).assign((ExpressionDef)ClassTypeDef.of(ArrayList.class).instantiate(new ExpressionDef[0]))), self.field(field).invoke("addAll", (TypeDef)TypeDef.primitive(Boolean.TYPE), new ExpressionDef[]{(ExpressionDef)parameterDefs.get(0)}), (StatementDef)returningExpressionProvider.apply((VariableDef.This)self)})));
            classBuilder.addMethod(((MethodDef.MethodDefBuilder)MethodDef.builder((String)singularName).addModifiers(new Modifier[]{Modifier.PUBLIC})).addParameter(singularName, singularTypeDef).build((self, parameterDefs) -> StatementDef.multi((StatementDef[])new StatementDef[]{self.field(field).isNull().doIf((StatementDef)self.field(field).assign((ExpressionDef)ClassTypeDef.of(ArrayList.class).instantiate(new ExpressionDef[0]))), self.field(field).invoke("add", TypeDef.of(Boolean.TYPE), new ExpressionDef[]{(ExpressionDef)parameterDefs.get(0)}), (StatementDef)returningExpressionProvider.apply((VariableDef.This)self)})));
            classBuilder.addMethod(((MethodDef.MethodDefBuilder)MethodDef.builder((String)("clear" + StringUtils.capitalize((String)propertyName))).addModifiers(new Modifier[]{Modifier.PUBLIC})).build((self, parameterDefs) -> StatementDef.multi((StatementDef[])new StatementDef[]{self.field(field).isNonNull().doIf((StatementDef)self.field(field).invoke("clear", (TypeDef)TypeDef.VOID, new ExpressionDef[0])), (StatementDef)returningExpressionProvider.apply((VariableDef.This)self)})));
        } else if (beanProperty.getType().isAssignable(Map.class)) {
            TypeDef keyType = beanProperty.getType().getFirstTypeArgument().map(ClassTypeDef::of).orElse((TypeDef)TypeDef.OBJECT);
            TypeDef valueType = beanProperty.getType().getTypeArguments().values().stream().skip(1L).findFirst().map(ClassTypeDef::of).orElse((TypeDef)TypeDef.OBJECT);
            ClassTypeDef mapEntryType = TypeDef.parameterized(Map.Entry.class, (TypeDef[])new TypeDef[]{keyType, valueType});
            ClassTypeDef fieldType = TypeDef.parameterized(ArrayList.class, (TypeDef[])new TypeDef[]{mapEntryType});
            FieldDef field = BuilderAnnotationVisitor.createField(beanProperty, (TypeDef)fieldType);
            classBuilder.addField(field);
            classBuilder.addMethod(((MethodDef.MethodDefBuilder)MethodDef.builder((String)propertyName).addModifiers(new Modifier[]{Modifier.PUBLIC})).addParameter(propertyName, (TypeDef)TypeDef.parameterized(Map.class, (TypeDef[])new TypeDef[]{keyType, valueType})).build((self, parameterDefs) -> StatementDef.multi((StatementDef[])new StatementDef[]{((VariableDef.MethodParameter)parameterDefs.get(0)).isNull().doIf((StatementDef)ClassTypeDef.of(NullPointerException.class).instantiate(new ExpressionDef[]{ExpressionDef.constant((Object)(propertyName + " cannot be null"))}).doThrow()), self.field(field).isNull().doIf((StatementDef)self.field(field).assign((ExpressionDef)fieldType.instantiate(new ExpressionDef[0]))), self.field(field).invoke("addAll", (TypeDef)TypeDef.primitive(Boolean.TYPE), new ExpressionDef[]{((VariableDef.MethodParameter)parameterDefs.get(0)).invoke("entrySet", (TypeDef)ClassTypeDef.of(Set.class), new ExpressionDef[0])}), (StatementDef)returningExpressionProvider.apply((VariableDef.This)self)})));
            classBuilder.addMethod(((MethodDef.MethodDefBuilder)MethodDef.builder((String)singularName).addModifiers(new Modifier[]{Modifier.PUBLIC})).addParameter("key", keyType).addParameter("value", valueType).build((self, parameterDefs) -> StatementDef.multi((StatementDef[])new StatementDef[]{self.field(field).isNull().doIf((StatementDef)self.field(field).assign((ExpressionDef)TypeDef.parameterized(ArrayList.class, (TypeDef[])new TypeDef[]{TypeDef.parameterized(Map.Entry.class, (TypeDef[])new TypeDef[]{keyType, valueType})}).instantiate(new ExpressionDef[0]))), self.field(field).invoke("add", TypeDef.of(Boolean.TYPE), new ExpressionDef[]{ClassTypeDef.of(Map.class).invokeStatic("entry", (TypeDef)ClassTypeDef.of(Map.Entry.class), new ExpressionDef[]{(ExpressionDef)parameterDefs.get(0), (ExpressionDef)parameterDefs.get(1)})}), (StatementDef)returningExpressionProvider.apply((VariableDef.This)self)})));
            classBuilder.addMethod(((MethodDef.MethodDefBuilder)MethodDef.builder((String)("clear" + StringUtils.capitalize((String)propertyName))).addModifiers(new Modifier[]{Modifier.PUBLIC})).build((self, parameterDefs) -> StatementDef.multi((StatementDef[])new StatementDef[]{self.field(field).isNonNull().doIf((StatementDef)self.field(field).invoke("clear", (TypeDef)TypeDef.VOID, new ExpressionDef[0])), (StatementDef)returningExpressionProvider.apply((VariableDef.This)self)})));
        } else {
            throw new IllegalStateException("Unsupported singular collection type [" + beanProperty.getType().getName() + "] for property: " + beanProperty.getName());
        }
    }

    static MethodDef createBuildMethod(ClassElement producedType) {
        return ((MethodDef.MethodDefBuilder)MethodDef.builder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC})).build((self, parameterDefs) -> {
            MethodElement constructorElement = producedType.getPrimaryConstructor().filter(c -> !c.isPrivate()).or(() -> ((ClassElement)producedType).getDefaultConstructor()).orElse(null);
            ArrayList beanProperties = new ArrayList(producedType.getBeanProperties());
            ArrayList<ExpressionDef.Cast> values = new ArrayList<ExpressionDef.Cast>();
            if (constructorElement != null) {
                for (ParameterElement parameter : constructorElement.getParameters()) {
                    PropertyElement propertyElement = beanProperties.stream().filter(p -> p.getName().equals(parameter.getName())).findFirst().orElse(null);
                    if (propertyElement != null) {
                        beanProperties.remove(propertyElement);
                    }
                    TypeDef fieldType = TypeDef.of((TypedElement)parameter.getType()).makeNullable();
                    VariableDef.Field field = self.field(parameter.getName(), fieldType);
                    values.add(BuilderAnnotationVisitor.valueExpression(propertyElement, field).cast(TypeDef.of((TypedElement)parameter.getType())));
                }
            }
            ClassTypeDef buildType = ClassTypeDef.of((ClassElement)producedType);
            if (beanProperties.isEmpty()) {
                return buildType.instantiate(values).returning();
            }
            return buildType.instantiate(values).newLocal("instance", instanceVar -> {
                ArrayList<Object> statements = new ArrayList<Object>();
                for (PropertyElement beanProperty : beanProperties) {
                    Optional writeMethod = beanProperty.getWriteMethod();
                    if (!writeMethod.isPresent()) continue;
                    String propertyName = beanProperty.getSimpleName();
                    TypeDef propertyType = TypeDef.of((TypedElement)beanProperty.getType());
                    TypeDef fieldType = propertyType.makeNullable();
                    if (fieldType.isNullable()) {
                        statements.add(self.field(propertyName, fieldType).isNonNull().doIf((StatementDef)instanceVar.invoke((MethodElement)writeMethod.get(), new ExpressionDef[]{BuilderAnnotationVisitor.valueExpression(beanProperty, self.field(propertyName, fieldType)).cast(propertyType)})));
                        continue;
                    }
                    statements.add(instanceVar.invoke((MethodElement)writeMethod.get(), new ExpressionDef[]{BuilderAnnotationVisitor.valueExpression(beanProperty, self.field(propertyName, fieldType)).cast(propertyType)}));
                }
                statements.add(instanceVar.returning());
                return StatementDef.multi(statements);
            });
        });
    }

    private static ExpressionDef valueExpression(@Nullable PropertyElement propertyElement, VariableDef.Field field) {
        if (propertyElement != null && propertyElement.hasAnnotation(Singular.class)) {
            return BuilderAnnotationVisitor.singularValueExpression(propertyElement, field);
        }
        return field;
    }

    private static ExpressionDef singularValueExpression(PropertyElement propertyElement, VariableDef.Field field) {
        String collectionType = propertyElement.getType().getName();
        ClassTypeDef elementType = propertyElement.getType().getFirstTypeArgument().map(ClassTypeDef::of).orElse(ClassTypeDef.OBJECT);
        TypeDef propertyType = TypeDef.of((TypedElement)propertyElement.getType());
        ExpressionDef collectionSize = field.ifNull((ExpressionDef)ExpressionDef.primitiveConstant((Object)0), (ExpressionDef)field.invoke("size", (TypeDef)TypeDef.primitive(Integer.TYPE), new ExpressionDef[0]));
        if (collectionType.equals(List.class.getName()) || collectionType.equals(Collection.class.getName()) || collectionType.equals(Iterable.class.getName())) {
            ClassTypeDef javaListType = ClassTypeDef.of(List.class);
            return collectionSize.asExpressionSwitch(propertyType, Map.of(ExpressionDef.constant((int)0), javaListType.invokeStatic("of", (TypeDef)javaListType, new ExpressionDef[0]), ExpressionDef.constant((int)1), javaListType.invokeStatic("of", (TypeDef)javaListType, new ExpressionDef[]{field.invoke("get", (TypeDef)elementType, new ExpressionDef[]{ExpressionDef.constant((int)0)})})), (ExpressionDef)javaListType.invokeStatic("copyOf", (TypeDef)javaListType, new ExpressionDef[]{field}));
        }
        if (collectionType.equals(Set.class.getName())) {
            ClassTypeDef setListType = ClassTypeDef.of(Set.class);
            return collectionSize.asExpressionSwitch(propertyType, Map.of(ExpressionDef.constant((int)0), setListType.invokeStatic("of", (TypeDef)setListType, new ExpressionDef[0]), ExpressionDef.constant((int)1), setListType.invokeStatic("of", (TypeDef)setListType, new ExpressionDef[]{field.invoke("get", (TypeDef)elementType, new ExpressionDef[]{ExpressionDef.constant((int)0)})})), (ExpressionDef)ClassTypeDef.of(Collections.class).invokeStatic("unmodifiableSet", propertyType, new ExpressionDef[]{ClassTypeDef.of(LinkedHashSet.class).instantiate(new ExpressionDef[]{field})}));
        }
        if (collectionType.equals(SortedSet.class.getName())) {
            return collectionSize.asExpressionSwitch(propertyType, Map.of(ExpressionDef.constant((int)0), ClassTypeDef.of(Collections.class).invokeStatic("emptySortedSet", propertyType, new ExpressionDef[0])), (ExpressionDef)ClassTypeDef.of(Collections.class).invokeStatic("unmodifiableSortedSet", propertyType, new ExpressionDef[]{TypeDef.parameterized(TreeSet.class, (TypeDef[])new TypeDef[]{elementType}).instantiate(new ExpressionDef[]{field})}));
        }
        if (collectionType.equals(Map.class.getName())) {
            return collectionSize.asExpressionSwitch(propertyType, Map.of(ExpressionDef.constant((int)0), ClassTypeDef.of(Map.class).invokeStatic("of", propertyType, new ExpressionDef[0])), (ExpressionDef)new ExpressionDef.SwitchYieldCase(propertyType, BuilderAnnotationVisitor.createMapStatement(propertyElement, field, LinkedHashMap.class, "unmodifiableMap")));
        }
        if (collectionType.equals(SortedMap.class.getName())) {
            return collectionSize.asExpressionSwitch(propertyType, Map.of(ExpressionDef.constant((int)0), ClassTypeDef.of(Collections.class).invokeStatic("emptySortedMap", propertyType, new ExpressionDef[0])), (ExpressionDef)new ExpressionDef.SwitchYieldCase(propertyType, BuilderAnnotationVisitor.createMapStatement(propertyElement, field, TreeMap.class, "unmodifiableSortedMap")));
        }
        throw new IllegalStateException("Unsupported singular collection type [" + collectionType + "] for property: " + propertyElement.getName());
    }

    private static StatementDef createMapStatement(PropertyElement propertyElement, VariableDef.Field field, Class<?> mapClass, String unmodifiableMethodName) {
        ClassElement propertyType = propertyElement.getType();
        TypeDef keyType = propertyType.getFirstTypeArgument().map(ClassTypeDef::of).orElse((TypeDef)TypeDef.OBJECT);
        TypeDef valueType = propertyType.getTypeArguments().values().stream().skip(1L).findFirst().map(ClassTypeDef::of).orElse((TypeDef)TypeDef.OBJECT);
        ClassTypeDef entryType = TypeDef.parameterized(Map.Entry.class, (TypeDef[])new TypeDef[]{keyType, valueType});
        return TypeDef.parameterized(mapClass, (TypeDef[])new TypeDef[]{keyType, valueType}).instantiate(new ExpressionDef[0]).newLocal(field.name() + "Map", mapVar -> field.invoke("iterator", (TypeDef)TypeDef.parameterized(Iterator.class, (TypeDef[])new TypeDef[]{entryType}), new ExpressionDef[0]).newLocal(field.name() + "Iterator", iteratorVar -> iteratorVar.invoke("hasNext", (TypeDef)TypeDef.primitive(Boolean.TYPE), new ExpressionDef[0]).whileLoop(iteratorVar.invoke("next", (TypeDef)TypeDef.OBJECT, new ExpressionDef[0]).cast(Map.Entry.class).newLocal(field.name() + "Entry", entryVar -> mapVar.invoke("put", TypeDef.of(Boolean.TYPE), new ExpressionDef[]{entryVar.invoke("getKey", (TypeDef)TypeDef.OBJECT, new ExpressionDef[0]).cast(keyType), entryVar.invoke("getValue", (TypeDef)TypeDef.OBJECT, new ExpressionDef[0]).cast(valueType)}))).after(ClassTypeDef.of(Collections.class).invokeStatic(unmodifiableMethodName, (TypeDef)ClassTypeDef.of((ClassElement)propertyType), new ExpressionDef[]{mapVar}).returning())));
    }
}

