/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.generator.visitors;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.processing.ProcessingException;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.sourcegen.annotations.Delegate;
import io.micronaut.sourcegen.generator.SourceGenerator;
import io.micronaut.sourcegen.generator.SourceGenerators;
import io.micronaut.sourcegen.model.ClassDef;
import io.micronaut.sourcegen.model.ClassTypeDef;
import io.micronaut.sourcegen.model.ExpressionDef;
import io.micronaut.sourcegen.model.FieldDef;
import io.micronaut.sourcegen.model.MethodDef;
import io.micronaut.sourcegen.model.ObjectDef;
import io.micronaut.sourcegen.model.TypeDef;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Modifier;

@Internal
public final class DelegateAnnotationVisitor
implements TypeElementVisitor<Delegate, Object> {
    private static final String DELEGATE_TYPE_MEMBER = "type";
    private static final String DELEGATEE_MEMBER = "delegatee";
    private static final String NAME_SUFFIX = "Delegate";
    private final Set<String> processed = new HashSet<String>();

    @NonNull
    public TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    public void start(VisitorContext visitorContext) {
        this.processed.clear();
    }

    public Set<String> getSupportedAnnotationNames() {
        return Set.of(Delegate.class.getName());
    }

    public void visitClass(ClassElement element, VisitorContext context) {
        AnnotationValue annotation = element.getAnnotation(Delegate.class);
        Optional type = annotation.classValue(DELEGATE_TYPE_MEMBER);
        if (type.isPresent() && !((Class)type.get()).equals(Void.class)) {
            ClassElement typeElement = (ClassElement)context.getClassElement((Class)type.get()).orElseThrow(() -> new ProcessingException((Element)element, "Could not find required type " + ((Class)type.get()).getName()));
            this.createDelegate(typeElement, context);
        } else {
            this.createDelegate(element, context);
        }
    }

    private void createDelegate(ClassElement element, VisitorContext context) {
        if (this.processed.contains(element.getName())) {
            return;
        }
        if (!element.isInterface()) {
            throw new ProcessingException((Element)element, "Only interfaces are supported for delegate creation. But '" + element.getName() + "' is annotated with @Delegate");
        }
        try {
            String simpleName = element.getSimpleName() + NAME_SUFFIX;
            String delegateClassName = element.getPackageName() + "." + simpleName;
            ClassTypeDef typeDef = ClassTypeDef.of((ClassElement)element);
            ClassDef.ClassDefBuilder delegate = (ClassDef.ClassDefBuilder)ClassDef.builder((String)delegateClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
            if (!element.getTypeArguments().isEmpty()) {
                element.getTypeArguments().forEach((k, v) -> delegate.addTypeVariable(TypeDef.TypeVariable.of((String)k, (ClassElement)v)));
                typeDef = TypeDef.parameterized((ClassTypeDef)typeDef, element.getTypeArguments().keySet().stream().map(TypeDef.TypeVariable::new).toList());
            }
            FieldDef delegateField = FieldDef.builder((String)DELEGATEE_MEMBER).ofType((TypeDef)typeDef).build();
            ((ClassDef.ClassDefBuilder)delegate.addSuperinterface((TypeDef)typeDef)).addField(delegateField).addAllFieldsConstructor(new Modifier[0]);
            this.addDelegateMethods(element, delegate, delegateField);
            SourceGenerator sourceGenerator = SourceGenerators.findByLanguage(context.getLanguage()).orElse(null);
            if (sourceGenerator == null) {
                return;
            }
            ClassDef builderDef = delegate.build();
            this.processed.add(element.getName());
            sourceGenerator.write((ObjectDef)builderDef, context, new Element[]{element});
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            SourceGenerators.handleFatalException((Element)element, Delegate.class, e, exception -> {
                this.processed.remove(element.getName());
                throw exception;
            });
        }
    }

    private void addDelegateMethods(ClassElement element, ClassDef.ClassDefBuilder builder, FieldDef delegateField) {
        for (MethodElement method : element.getMethods()) {
            if (method.isPrivate()) continue;
            MethodDef.MethodDefBuilder methodBuilder = MethodDef.builder((String)method.getName()).overrides().returns(TypeDef.of((TypedElement)method.getGenericReturnType()));
            if (method.isPublic()) {
                methodBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
            } else if (method.isProtected()) {
                methodBuilder.addModifiers(new Modifier[]{Modifier.PROTECTED});
            }
            for (ParameterElement parameter : method.getParameters()) {
                methodBuilder.addParameter(parameter.getName(), TypeDef.of((TypedElement)parameter.getGenericType()));
            }
            builder.addMethod(methodBuilder.build((aThis, methodParameters) -> {
                ExpressionDef.InvokeInstanceMethod delegateInvocation = aThis.field(delegateField).invoke(method.getName(), TypeDef.of((TypedElement)method.getGenericReturnType()), methodParameters);
                if (method.getReturnType().isVoid()) {
                    return delegateInvocation;
                }
                return delegateInvocation.returning();
            }));
        }
    }
}

