/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.generator.visitors;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.processing.ProcessingException;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.sourcegen.annotations.EqualsAndHashCode;
import io.micronaut.sourcegen.annotations.ToString;
import io.micronaut.sourcegen.generator.SourceGenerator;
import io.micronaut.sourcegen.generator.SourceGenerators;
import io.micronaut.sourcegen.model.ClassDef;
import io.micronaut.sourcegen.model.ClassTypeDef;
import io.micronaut.sourcegen.model.ExpressionDef;
import io.micronaut.sourcegen.model.JavaIdioms;
import io.micronaut.sourcegen.model.MethodDef;
import io.micronaut.sourcegen.model.ObjectDef;
import io.micronaut.sourcegen.model.StatementDef;
import io.micronaut.sourcegen.model.TypeDef;
import io.micronaut.sourcegen.model.VariableDef;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.Modifier;

@Internal
public final class ObjectAnnotationVisitor
implements TypeElementVisitor<Object, Object> {
    private static final ExpressionDef HASH_MULTIPLIER = ExpressionDef.primitiveConstant((Object)31);
    private final Set<String> processed = new HashSet<String>();

    @NonNull
    public TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    public void start(VisitorContext visitorContext) {
        this.processed.clear();
    }

    public Set<String> getSupportedAnnotationNames() {
        return Set.of(ToString.class.getName(), EqualsAndHashCode.class.getName());
    }

    public void visitClass(ClassElement element, VisitorContext context) {
        if (!element.hasStereotype(ToString.class) && !element.hasStereotype(EqualsAndHashCode.class)) {
            return;
        }
        if (this.processed.contains(element.getName())) {
            return;
        }
        try {
            SourceGenerator sourceGenerator;
            String simpleName = element.getSimpleName() + "Object";
            String objectClassName = element.getPackageName() + "." + simpleName;
            ClassDef.ClassDefBuilder objectBuilder = (ClassDef.ClassDefBuilder)ClassDef.builder((String)objectClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            if (element.hasStereotype(ToString.class)) {
                context.warn("@ToString annotation will only print out bean properties.", (Element)element);
                List<PropertyElement> filteredProperties = element.getBeanProperties().stream().filter(property -> !property.hasAnnotation(ToString.Exclude.class)).toList();
                ObjectAnnotationVisitor.createToStringMethod(objectBuilder, ClassTypeDef.of((ClassElement)element), filteredProperties);
            }
            if (element.hasStereotype(EqualsAndHashCode.class)) {
                List properties = element.getBeanProperties();
                ObjectAnnotationVisitor.createEqualsMethod(objectBuilder, ClassTypeDef.of((ClassElement)element), properties);
                ObjectAnnotationVisitor.createHashCodeMethod(objectBuilder, ClassTypeDef.of((ClassElement)element), properties);
            }
            if ((sourceGenerator = (SourceGenerator)SourceGenerators.findByLanguage(context.getLanguage()).orElse(null)) == null) {
                return;
            }
            ClassDef objectDef = objectBuilder.build();
            this.processed.add(element.getName());
            sourceGenerator.write((ObjectDef)objectDef, context, new Element[]{element});
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            SourceGenerators.handleFatalException((Element)element, ToString.class, e, exception -> {
                this.processed.remove(element.getName());
                throw exception;
            });
        }
    }

    private static void createToStringMethod(ClassDef.ClassDefBuilder classDefBuilder, ClassTypeDef selfType, List<PropertyElement> properties) {
        MethodDef method = ((MethodDef.MethodDefBuilder)MethodDef.builder((String)"toString").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC})).returns((TypeDef)TypeDef.STRING).addParameter("instance", (TypeDef)selfType).build((self, parameterDef) -> {
            ArrayList<Object> expressions = new ArrayList<Object>();
            expressions.add(ExpressionDef.constant((Object)(selfType.getSimpleName() + "[")));
            for (int i = 0; i < properties.size(); ++i) {
                PropertyElement beanProperty = (PropertyElement)properties.get(i);
                if (beanProperty.isWriteOnly()) continue;
                ExpressionDef.GetPropertyValue propertyValue = ((VariableDef.MethodParameter)parameterDef.get(0)).getPropertyValue(beanProperty);
                expressions.add(ExpressionDef.constant((Object)(beanProperty.getName() + "=")));
                expressions.add(propertyValue);
                expressions.add(ExpressionDef.constant((Object)(i == properties.size() - 1 ? "]" : ", ")));
            }
            return JavaIdioms.concatStrings(expressions).returning();
        });
        classDefBuilder.addMethod(method);
    }

    private static void createEqualsMethod(ClassDef.ClassDefBuilder classDefBuilder, ClassTypeDef selfType, List<PropertyElement> properties) {
        MethodDef method = ((MethodDef.MethodDefBuilder)MethodDef.builder((String)"equals").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC})).returns((TypeDef)TypeDef.Primitive.BOOLEAN).addParameter("instance", (TypeDef)selfType).addParameter("o", (TypeDef)TypeDef.OBJECT.makeNullable()).build((self, parameterDef) -> {
            VariableDef instance = (VariableDef)parameterDef.get(0);
            VariableDef o = (VariableDef)parameterDef.get(1);
            return StatementDef.multi((StatementDef[])new StatementDef[]{instance.equalsReferentially((ExpressionDef)o).ifTrue(ExpressionDef.trueValue().returning()), o.isNull().or((ExpressionDef.ConditionExpressionDef)instance.invokeGetClass().notEqualsReferentially((ExpressionDef)o.invokeGetClass())).doIf(ExpressionDef.falseValue().returning()), o.cast((TypeDef)selfType).newLocal("other", variableDef -> {
                ExpressionDef.EqualsReferentially exp = null;
                for (PropertyElement beanProperty : properties) {
                    if (beanProperty.hasAnnotation(EqualsAndHashCode.Exclude.class) || beanProperty.isWriteOnly()) continue;
                    ExpressionDef.GetPropertyValue firstProperty = instance.getPropertyValue(beanProperty);
                    ExpressionDef.GetPropertyValue secondProperty = variableDef.getPropertyValue(beanProperty);
                    ExpressionDef.EqualsReferentially newEqualsExpression = firstProperty.equalsReferentially((ExpressionDef)secondProperty);
                    if (!beanProperty.isPrimitive() || beanProperty.isArray()) {
                        ExpressionDef.EqualsStructurally equalsMethod = firstProperty.equalsStructurally((ExpressionDef)secondProperty);
                        newEqualsExpression = newEqualsExpression.or(firstProperty.isNonNull().and((ExpressionDef.ConditionExpressionDef)equalsMethod));
                    }
                    if (exp == null) {
                        exp = newEqualsExpression;
                        continue;
                    }
                    exp = exp.and((ExpressionDef.ConditionExpressionDef)newEqualsExpression);
                }
                return Objects.requireNonNullElseGet(exp, ExpressionDef::trueValue).returning();
            })});
        });
        classDefBuilder.addMethod(method);
    }

    private static void createHashCodeMethod(ClassDef.ClassDefBuilder classDefBuilder, ClassTypeDef selfType, List<PropertyElement> properties) {
        List<PropertyElement> props = properties.stream().filter(beanProperty -> !beanProperty.hasAnnotation(EqualsAndHashCode.Exclude.class) && !beanProperty.isWriteOnly()).toList();
        Iterator<PropertyElement> iterator = props.iterator();
        MethodDef method = ((MethodDef.MethodDefBuilder)MethodDef.builder((String)"hashCode").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC})).addParameter("instance", (TypeDef)selfType.makeNullable()).returns((TypeDef)TypeDef.Primitive.INT).build((self, parameterDef) -> {
            if (!iterator.hasNext()) {
                return ExpressionDef.primitiveConstant((Object)0).returning();
            }
            VariableDef.MethodParameter instance = (VariableDef.MethodParameter)parameterDef.get(0);
            PropertyElement propertyElement1 = (PropertyElement)iterator.next();
            return StatementDef.multi((StatementDef[])new StatementDef[]{instance.ifNull(ExpressionDef.primitiveConstant((Object)0).returning()), instance.getPropertyValue(propertyElement1).invokeHashCode().newLocal("hashValue", hashValue -> {
                ArrayList<StatementDef> hashUpdates = new ArrayList<StatementDef>();
                while (iterator.hasNext()) {
                    PropertyElement propertyElement = (PropertyElement)iterator.next();
                    ExpressionDef condition = hashValue.math(ExpressionDef.MathBinaryOperation.OpType.MULTIPLICATION, HASH_MULTIPLIER).math(ExpressionDef.MathBinaryOperation.OpType.ADDITION, (ExpressionDef)instance.getPropertyValue(propertyElement).invokeHashCode());
                    hashUpdates.add(hashValue.assign(condition));
                }
                hashUpdates.add(hashValue.returning());
                return StatementDef.multi(hashUpdates);
            })});
        });
        classDefBuilder.addMethod(method);
    }
}

