/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.generator.visitors;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.processing.ProcessingException;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.sourcegen.annotations.Builder;
import io.micronaut.sourcegen.annotations.Wither;
import io.micronaut.sourcegen.generator.SourceGenerator;
import io.micronaut.sourcegen.generator.SourceGenerators;
import io.micronaut.sourcegen.model.ClassTypeDef;
import io.micronaut.sourcegen.model.ExpressionDef;
import io.micronaut.sourcegen.model.InterfaceDef;
import io.micronaut.sourcegen.model.MethodDef;
import io.micronaut.sourcegen.model.ObjectDef;
import io.micronaut.sourcegen.model.StatementDef;
import io.micronaut.sourcegen.model.TypeDef;
import io.micronaut.sourcegen.model.VariableDef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.lang.model.element.Modifier;

@Internal
public final class WitherAnnotationVisitor
implements TypeElementVisitor<Wither, Object> {
    private final Set<String> processed = new HashSet<String>();

    @NonNull
    public TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    public void start(VisitorContext visitorContext) {
        this.processed.clear();
    }

    public void visitClass(ClassElement recordElement, VisitorContext context) {
        if (this.processed.contains(recordElement.getName())) {
            return;
        }
        try {
            SourceGenerator sourceGenerator;
            if (!recordElement.isRecord()) {
                throw new ProcessingException((Element)recordElement, "Only records can be annotated with @Wither");
            }
            String simpleName = recordElement.getSimpleName() + "Wither";
            String witherClassName = recordElement.getPackageName() + "." + simpleName;
            ClassTypeDef recordType = ClassTypeDef.of((ClassElement)recordElement);
            InterfaceDef.InterfaceDefBuilder wither = (InterfaceDef.InterfaceDefBuilder)InterfaceDef.builder((String)witherClassName).addModifiers(new Modifier[]{Modifier.PUBLIC});
            List properties = recordElement.getBeanProperties();
            HashMap propertyAccessMethods = CollectionUtils.newHashMap((int)properties.size());
            for (PropertyElement beanProperty : properties) {
                MethodDef methodDef = ((MethodDef.MethodDefBuilder)MethodDef.builder((String)beanProperty.getSimpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT})).returns(TypeDef.of((TypedElement)beanProperty.getType())).build();
                wither.addMethod(methodDef);
                propertyAccessMethods.put(beanProperty.getName(), methodDef);
            }
            for (PropertyElement beanProperty : properties) {
                wither.addMethod(this.withMethod(recordElement, beanProperty, recordType, propertyAccessMethods));
            }
            if (recordElement.hasStereotype(Builder.class)) {
                String builderSimpleName = recordElement.getSimpleName() + "Builder";
                String builderClassName = recordElement.getPackageName() + "." + builderSimpleName;
                ClassTypeDef builderType = ClassTypeDef.of((String)builderClassName);
                MethodDef withMethod = this.createWithMethod(recordElement, builderType, propertyAccessMethods);
                wither.addMethod(withMethod);
                wither.addMethod(this.createWithConsumerMethod(recordType, builderType, withMethod));
            }
            if ((sourceGenerator = (SourceGenerator)SourceGenerators.findByLanguage(context.getLanguage()).orElse(null)) == null) {
                return;
            }
            InterfaceDef witherDef = wither.build();
            this.processed.add(recordElement.getName());
            sourceGenerator.write((ObjectDef)witherDef, context, new Element[]{recordElement});
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            SourceGenerators.handleFatalException((Element)recordElement, Wither.class, e, exception -> {
                this.processed.remove(recordElement.getName());
                throw exception;
            });
        }
    }

    private MethodDef createWithConsumerMethod(ClassTypeDef recordType, ClassTypeDef builderType, MethodDef withMethod) {
        return ((MethodDef.MethodDefBuilder)MethodDef.builder((String)"with").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT})).addParameter("consumer", (TypeDef)TypeDef.parameterized((ClassTypeDef)ClassTypeDef.of(Consumer.class), (TypeDef[])new TypeDef[]{builderType})).returns((TypeDef)recordType).build((self, parameterDefs) -> self.invoke(withMethod, new ExpressionDef[0]).newLocal("builder", builderVar -> ((VariableDef.MethodParameter)parameterDefs.get(0)).invoke("accept", (TypeDef)TypeDef.VOID, new ExpressionDef[]{builderVar}).after(builderVar.invoke("build", (TypeDef)recordType, new ExpressionDef[0]).returning())));
    }

    private MethodDef createWithMethod(ClassElement recordElement, ClassTypeDef builderType, Map<String, MethodDef> propertyAccessMethods) {
        return ((MethodDef.MethodDefBuilder)MethodDef.builder((String)"with").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT})).returns((TypeDef)builderType).build((self, parameterDefs) -> builderType.instantiate(Arrays.stream(((MethodElement)recordElement.getPrimaryConstructor().orElseThrow()).getParameters()).map(parameter -> self.invoke((MethodDef)propertyAccessMethods.get(parameter.getName()), new ExpressionDef[0])).toList()).returning());
    }

    private MethodDef withMethod(ClassElement recordElement, PropertyElement beanProperty, ClassTypeDef recordType, Map<String, MethodDef> propertyAccessMethods) {
        return ((MethodDef.MethodDefBuilder)MethodDef.builder((String)("with" + NameUtils.capitalize((String)beanProperty.getSimpleName()))).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT})).returns((TypeDef)recordType).addParameter(beanProperty.getSimpleName(), TypeDef.of((TypedElement)beanProperty.getType())).build((self, parameterDefs) -> {
            ArrayList<ExpressionDef> values = new ArrayList<ExpressionDef>();
            for (ParameterElement parameter : ((MethodElement)recordElement.getPrimaryConstructor().orElseThrow()).getParameters()) {
                Object exp = parameter.getName().equals(beanProperty.getName()) ? (ExpressionDef)parameterDefs.get(0) : self.invoke((MethodDef)propertyAccessMethods.get(parameter.getName()), new ExpressionDef[0]);
                values.add((ExpressionDef)exp);
            }
            if (beanProperty.isNonNull()) {
                return StatementDef.multi((StatementDef[])new StatementDef[]{ClassTypeDef.of(Objects.class).invokeStatic("requireNonNull", (TypeDef)ClassTypeDef.OBJECT, new ExpressionDef[]{(ExpressionDef)parameterDefs.get(0)}), recordType.instantiate(values).returning()});
            }
            return recordType.instantiate(values).returning();
        });
    }
}

