/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.generator.visitors;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.processing.ProcessingException;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.sourcegen.annotations.Builder;
import io.micronaut.sourcegen.annotations.Wither;
import io.micronaut.sourcegen.generator.SourceGenerator;
import io.micronaut.sourcegen.generator.SourceGenerators;
import io.micronaut.sourcegen.model.ClassTypeDef;
import io.micronaut.sourcegen.model.ExpressionDef;
import io.micronaut.sourcegen.model.InterfaceDef;
import io.micronaut.sourcegen.model.MethodDef;
import io.micronaut.sourcegen.model.ObjectDef;
import io.micronaut.sourcegen.model.ObjectDefBuilder;
import io.micronaut.sourcegen.model.StatementDef;
import io.micronaut.sourcegen.model.TypeDef;
import io.micronaut.sourcegen.model.VariableDef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.lang.model.element.Modifier;

@Internal
public final class WitherAnnotationVisitor
implements TypeElementVisitor<Wither, Object> {
    private final Set<String> processed = new HashSet<String>();

    @NonNull
    public TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    public void start(VisitorContext visitorContext) {
        this.processed.clear();
    }

    public void visitClass(ClassElement recordElement, VisitorContext context) {
        if (this.processed.contains(recordElement.getName())) {
            return;
        }
        try {
            if (!recordElement.isRecord()) {
                throw new ProcessingException((Element)recordElement, "Only records can be annotated with @Wither");
            }
            List properties = recordElement.getBeanProperties();
            List<ParameterElement> parameters = Arrays.asList(((MethodElement)recordElement.getPrimaryConstructor().orElseThrow()).getParameters());
            boolean hasBuilder = recordElement.hasStereotype(Builder.class);
            ClassTypeDef recordType = ClassTypeDef.of((ClassElement)recordElement);
            InterfaceDef.InterfaceDefBuilder wither = WitherAnnotationVisitor.createWither(recordElement.getPackageName(), recordType, properties, parameters, hasBuilder);
            SourceGenerator sourceGenerator = SourceGenerators.findByLanguage(context.getLanguage()).orElse(null);
            if (sourceGenerator == null) {
                return;
            }
            InterfaceDef witherDef = wither.build();
            this.processed.add(recordElement.getName());
            sourceGenerator.write((ObjectDef)witherDef, context, new Element[]{recordElement});
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            SourceGenerators.handleFatalException((Element)recordElement, Wither.class, e, exception -> {
                this.processed.remove(recordElement.getName());
                throw exception;
            });
        }
    }

    static InterfaceDef.InterfaceDefBuilder createWither(String packageName, ClassTypeDef recordType, List<PropertyElement> properties, List<ParameterElement> parameters, boolean hasBuilder) {
        String simpleName = recordType.getSimpleName() + "Wither";
        String witherClassName = packageName + "." + simpleName;
        InterfaceDef.InterfaceDefBuilder wither = (InterfaceDef.InterfaceDefBuilder)InterfaceDef.builder((String)witherClassName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (recordType instanceof ClassTypeDef.Parameterized) {
            ClassTypeDef.Parameterized parameterized = (ClassTypeDef.Parameterized)recordType;
            List typeDefs = parameterized.typeArguments();
            for (TypeDef typeDef : typeDefs) {
                if (!(typeDef instanceof TypeDef.TypeVariable)) continue;
                TypeDef.TypeVariable variable = (TypeDef.TypeVariable)typeDef;
                wither.addTypeVariable(variable);
            }
        }
        WitherAnnotationVisitor.weaveWithMethodsInternal(recordType, properties, parameters, hasBuilder, wither);
        return wither;
    }

    static void weaveWithMethodsInternal(ClassTypeDef recordType, List<PropertyElement> properties, List<ParameterElement> parameters, boolean hasBuilder, ObjectDefBuilder<?> wither) {
        HashMap propertyAccessMethods = CollectionUtils.newHashMap((int)properties.size());
        for (PropertyElement beanProperty : properties) {
            MethodDef methodDef;
            if (wither instanceof InterfaceDef.InterfaceDefBuilder) {
                methodDef = ((MethodDef.MethodDefBuilder)MethodDef.builder((String)beanProperty.getSimpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT})).returns(TypeDef.of((TypedElement)beanProperty.getType())).build();
                wither.addMethod(methodDef);
            } else {
                methodDef = ((MethodDef.MethodDefBuilder)MethodDef.builder((String)beanProperty.getSimpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC})).returns(TypeDef.of((TypedElement)beanProperty.getType())).build();
            }
            propertyAccessMethods.put(beanProperty.getName(), methodDef);
        }
        for (PropertyElement beanProperty : properties) {
            wither.addMethod(WitherAnnotationVisitor.withMethod(wither, parameters, beanProperty, recordType, propertyAccessMethods));
        }
        if (hasBuilder) {
            ClassTypeDef builderType;
            String builderSimpleName = recordType.getSimpleName() + "Builder";
            String builderClassName = recordType.getPackageName() + "." + builderSimpleName;
            if (recordType instanceof ClassTypeDef.Parameterized) {
                ClassTypeDef.Parameterized parameterized = (ClassTypeDef.Parameterized)recordType;
                builderType = TypeDef.parameterized((ClassTypeDef)ClassTypeDef.of((String)builderClassName), (List)parameterized.typeArguments());
            } else {
                builderType = ClassTypeDef.of((String)builderClassName);
            }
            MethodDef withMethod = WitherAnnotationVisitor.createWithMethod(wither, parameters, builderType, propertyAccessMethods);
            wither.addMethod(withMethod);
            MethodDef withConsumer = WitherAnnotationVisitor.createWithConsumerMethod(wither, recordType, builderType, withMethod);
            wither.addMethod(withConsumer);
        }
    }

    private static MethodDef createWithConsumerMethod(ObjectDefBuilder<?> wither, ClassTypeDef recordType, ClassTypeDef builderType, MethodDef withMethod) {
        MethodDef.MethodDefBuilder methodDefBuilder = MethodDef.builder((String)"with");
        if (wither instanceof InterfaceDef.InterfaceDefBuilder) {
            methodDefBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT});
        } else {
            methodDefBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        }
        return methodDefBuilder.addParameter("consumer", (TypeDef)TypeDef.parameterized((ClassTypeDef)ClassTypeDef.of(Consumer.class), (TypeDef[])new TypeDef[]{builderType})).returns((TypeDef)recordType).build((self, parameterDefs) -> self.invoke(withMethod, new ExpressionDef[0]).newLocal("builder", builderVar -> ((VariableDef.MethodParameter)parameterDefs.get(0)).invoke("accept", (TypeDef)TypeDef.VOID, new ExpressionDef[]{builderVar}).after(builderVar.invoke("build", (TypeDef)recordType, new ExpressionDef[0]).returning())));
    }

    private static MethodDef createWithMethod(ObjectDefBuilder<?> wither, List<ParameterElement> parameters, ClassTypeDef builderType, Map<String, MethodDef> propertyAccessMethods) {
        MethodDef.MethodDefBuilder methodDefBuilder = MethodDef.builder((String)"with");
        if (wither instanceof InterfaceDef.InterfaceDefBuilder) {
            methodDefBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT});
        } else {
            methodDefBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        }
        return methodDefBuilder.returns((TypeDef)builderType).build((self, parameterDefs) -> builderType.instantiate(parameters.stream().map(parameter -> self.invoke((MethodDef)propertyAccessMethods.get(parameter.getName()), new ExpressionDef[0])).toList()).returning());
    }

    private static MethodDef withMethod(ObjectDefBuilder<?> wither, List<ParameterElement> parameters, PropertyElement beanProperty, ClassTypeDef recordType, Map<String, MethodDef> propertyAccessMethods) {
        MethodDef.MethodDefBuilder methodBuilder = MethodDef.builder((String)("with" + NameUtils.capitalize((String)beanProperty.getSimpleName())));
        if (wither instanceof InterfaceDef.InterfaceDefBuilder) {
            methodBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT});
        } else {
            methodBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        }
        return methodBuilder.returns((TypeDef)recordType).addParameter(beanProperty.getSimpleName(), TypeDef.of((TypedElement)beanProperty.getType())).build((self, parameterDefs) -> {
            ArrayList<ExpressionDef> values = new ArrayList<ExpressionDef>();
            for (ParameterElement parameter : parameters) {
                Object exp = parameter.getName().equals(beanProperty.getName()) ? (ExpressionDef)parameterDefs.get(0) : self.invoke((MethodDef)propertyAccessMethods.get(parameter.getName()), new ExpressionDef[0]);
                values.add((ExpressionDef)exp);
            }
            if (beanProperty.isNonNull()) {
                return StatementDef.multi((StatementDef[])new StatementDef[]{ClassTypeDef.of(Objects.class).invokeStatic("requireNonNull", (TypeDef)ClassTypeDef.OBJECT, new ExpressionDef[]{(ExpressionDef)parameterDefs.get(0)}), recordType.instantiate(values).returning()});
            }
            return recordType.instantiate(values).returning();
        });
    }
}

