/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.model;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.sourcegen.model.ClassTypeDef;
import io.micronaut.sourcegen.model.FieldDef;
import io.micronaut.sourcegen.model.MethodDef;
import io.micronaut.sourcegen.model.ParameterDef;
import io.micronaut.sourcegen.model.StatementDef;
import io.micronaut.sourcegen.model.TypeDef;
import io.micronaut.sourcegen.model.VariableDef;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ExpressionDef {
    default public ArrayElement arrayElement(int index) {
        return new ArrayElement(this, index);
    }

    default public ArrayElement arrayElement(ExpressionDef index) {
        if (!index.type().equals(TypeDef.Primitive.INT)) {
            throw new IllegalStateException("Illegal array index type: " + index.type());
        }
        return new ArrayElement(this, index);
    }

    default public InstanceOf instanceOf(ClassTypeDef instanceType) {
        return new InstanceOf(this, instanceType);
    }

    default public StatementDef.Throw doThrow() {
        return new StatementDef.Throw(this);
    }

    default public ConditionExpressionDef compare(ComparisonOperation.OpType op, ExpressionDef expression) {
        return new ComparisonOperation(op, this, expression);
    }

    default public ExpressionDef math(MathBinaryOperation.OpType op, ExpressionDef expression) {
        return new MathBinaryOperation(op, this, expression);
    }

    default public ExpressionDef math(MathUnaryOperation.OpType op) {
        return new MathUnaryOperation(op, this);
    }

    default public ConditionExpressionDef isNonNull() {
        return new IsNotNull(this);
    }

    default public ExpressionDef ifNonNull(ExpressionDef ifExpression, ExpressionDef elseExpression) {
        return this.isNonNull().doIfElse(ifExpression, elseExpression);
    }

    default public StatementDef ifNonNull(StatementDef ifStatement) {
        return this.isNonNull().doIf(ifStatement);
    }

    default public StatementDef ifNonNull(StatementDef ifStatement, StatementDef elseStatement) {
        return this.isNonNull().doIfElse(ifStatement, elseStatement);
    }

    default public ConditionExpressionDef isNull() {
        return new IsNull(this);
    }

    default public ExpressionDef ifNull(ExpressionDef ifExpression, ExpressionDef elseExpression) {
        return this.isNull().doIfElse(ifExpression, elseExpression);
    }

    default public StatementDef ifNull(StatementDef ifStatement) {
        return this.isNull().doIf(ifStatement);
    }

    default public StatementDef ifNull(StatementDef ifStatement, StatementDef elseStatement) {
        return this.isNull().doIfElse(ifStatement, elseStatement);
    }

    default public ConditionExpressionDef isTrue() {
        return new IsTrue(this.cast(TypeDef.Primitive.BOOLEAN));
    }

    default public ExpressionDef ifTrue(ExpressionDef ifExpression, ExpressionDef elseExpression) {
        return this.isTrue().doIfElse(ifExpression, elseExpression);
    }

    default public StatementDef ifTrue(StatementDef ifStatement) {
        return this.isTrue().doIf(ifStatement);
    }

    default public StatementDef ifTrue(StatementDef ifStatement, StatementDef elseStatement) {
        return this.isTrue().doIfElse(ifStatement, elseStatement);
    }

    default public ConditionExpressionDef isFalse() {
        return new IsFalse(this.cast(TypeDef.Primitive.BOOLEAN));
    }

    default public ExpressionDef ifFalse(ExpressionDef ifExpression, ExpressionDef elseExpression) {
        return this.isFalse().doIfElse(ifExpression, elseExpression);
    }

    default public StatementDef ifFalse(StatementDef ifStatement) {
        return this.isFalse().doIf(ifStatement);
    }

    default public StatementDef ifFalse(StatementDef ifStatement, StatementDef elseStatement) {
        return this.isFalse().doIfElse(ifStatement, elseStatement);
    }

    @NonNull
    public static Constant nullValue() {
        return new Constant(TypeDef.OBJECT, null);
    }

    @NonNull
    public static Constant trueValue() {
        return TypeDef.Primitive.TRUE;
    }

    @NonNull
    public static Constant falseValue() {
        return TypeDef.Primitive.FALSE;
    }

    default public StatementDef returning() {
        return new StatementDef.Return(this);
    }

    @NonNull
    default public Cast cast(TypeDef type) {
        return new Cast(type, this);
    }

    @NonNull
    default public Cast cast(Class<?> type) {
        return new Cast(TypeDef.of(type), this);
    }

    default public StatementDef.DefineAndAssign newLocal(String name) {
        return new VariableDef.Local(name, this.type()).defineAndAssign(this);
    }

    default public StatementDef newLocal(String name, Function<VariableDef, StatementDef> fn) {
        VariableDef.Local local = new VariableDef.Local(name, this.type());
        return StatementDef.multi(new StatementDef.DefineAndAssign(local, this), fn.apply(local));
    }

    default public StatementDef asStatementSwitch(TypeDef type, Map<Constant, StatementDef> cases) {
        return this.asStatementSwitch(type, cases, null);
    }

    default public Switch asExpressionSwitch(TypeDef type, Map<Constant, ? extends ExpressionDef> cases, ExpressionDef defaultCase) {
        if (defaultCase == null && (defaultCase = (cases = new HashMap<Constant, ExpressionDef>(cases)).remove(ExpressionDef.nullValue())) == null && (defaultCase = cases.remove(null)) == null) {
            throw new IllegalStateException("The expression switch requires a default expression");
        }
        return new Switch(this, type, cases, defaultCase);
    }

    default public StatementDef.Switch asStatementSwitch(TypeDef type, Map<Constant, StatementDef> cases, StatementDef defaultCase) {
        if (defaultCase == null && (defaultCase = (cases = new HashMap<Constant, StatementDef>(cases)).remove(ExpressionDef.nullValue())) == null) {
            defaultCase = cases.remove(null);
        }
        return new StatementDef.Switch(this, type, cases, defaultCase);
    }

    default public StatementDef.While whileLoop(StatementDef statement) {
        return new StatementDef.While(this, statement);
    }

    default public VariableDef.Field field(String fieldName, TypeDef typeDef) {
        return new VariableDef.Field(this, fieldName, typeDef);
    }

    default public VariableDef.Field field(FieldDef fieldDef) {
        return new VariableDef.Field(this, fieldDef.getName(), fieldDef.getType());
    }

    default public VariableDef.Field field(FieldElement fieldElement) {
        return new VariableDef.Field(this, fieldElement.getName(), TypeDef.of((TypedElement)fieldElement.getType()));
    }

    default public InvokeInstanceMethod invokeConstructor(ExpressionDef ... values) {
        return this.invokeConstructor(Arrays.asList(values));
    }

    default public InvokeInstanceMethod invokeConstructor(List<? extends ExpressionDef> values) {
        return this.invokeConstructor(values.stream().map(ExpressionDef::type).toList(), values);
    }

    default public InvokeInstanceMethod invokeConstructor(List<TypeDef> parameterTypes, ExpressionDef ... values) {
        return this.invokeConstructor(parameterTypes, Arrays.asList(values));
    }

    default public InvokeInstanceMethod invokeConstructor(List<TypeDef> parameterTypes, List<? extends ExpressionDef> values) {
        return new InvokeInstanceMethod(this, MethodDef.constructor().addParameters(parameterTypes).build(), values);
    }

    default public InvokeInstanceMethod invokeConstructor(Constructor<?> constructor, ExpressionDef ... values) {
        return this.invokeConstructor(constructor, List.of(values));
    }

    default public InvokeInstanceMethod invokeConstructor(Constructor<?> constructor, List<? extends ExpressionDef> values) {
        return this.invokeConstructor(Arrays.stream(constructor.getParameterTypes()).map(TypeDef::of).toList(), values);
    }

    default public InvokeInstanceMethod invokeConstructor(MethodDef constructor, ExpressionDef ... values) {
        return this.invokeConstructor(constructor, List.of(values));
    }

    default public InvokeInstanceMethod invokeConstructor(MethodDef constructor, List<? extends ExpressionDef> values) {
        return this.invokeConstructor(constructor.getParameters().stream().map(ParameterDef::getType).toList(), values);
    }

    default public InvokeInstanceMethod invoke(MethodDef method, ExpressionDef ... values) {
        return this.invoke(method, List.of(values));
    }

    default public InvokeInstanceMethod invoke(MethodDef methodDef, List<? extends ExpressionDef> values) {
        return new InvokeInstanceMethod(this, methodDef, values);
    }

    default public InvokeInstanceMethod invoke(Method method, ExpressionDef ... values) {
        return this.invoke(method, Arrays.asList(values));
    }

    default public InvokeInstanceMethod invoke(Method method, List<? extends ExpressionDef> values) {
        return new InvokeInstanceMethod(this, MethodDef.of(method), method.isDefault(), values);
    }

    default public InvokeInstanceMethod invoke(String name, TypeDef returning, ExpressionDef ... values) {
        return this.invoke(name, returning, List.of(values));
    }

    default public InvokeInstanceMethod invoke(String name, TypeDef returning, List<? extends ExpressionDef> values) {
        return this.invoke(name, values.stream().map(ExpressionDef::type).toList(), returning, values);
    }

    default public InvokeInstanceMethod invoke(String name, List<TypeDef> parameterTypes, TypeDef returning, List<? extends ExpressionDef> values) {
        return new InvokeInstanceMethod(this, MethodDef.builder(name).addParameters(parameterTypes).returns(returning).build(), values);
    }

    default public InvokeInstanceMethod invoke(MethodElement methodElement, ExpressionDef ... values) {
        return this.invoke(methodElement, List.of(values));
    }

    default public InvokeInstanceMethod invoke(MethodElement methodElement, List<? extends ExpressionDef> values) {
        return new InvokeInstanceMethod(this, MethodDef.of(methodElement), methodElement.isDefault(), values);
    }

    default public InvokeHashCodeMethod invokeHashCode() {
        return new InvokeHashCodeMethod(this);
    }

    default public InvokeGetClassMethod invokeGetClass() {
        return new InvokeGetClassMethod(this);
    }

    default public EqualsStructurally equalsStructurally(ExpressionDef other) {
        return new EqualsStructurally(this, other);
    }

    default public NotEqualsStructurally notEqualsStructurally(ExpressionDef other) {
        return new NotEqualsStructurally(this, other);
    }

    default public EqualsReferentially equalsReferentially(ExpressionDef other) {
        return new EqualsReferentially(this, other);
    }

    default public NotEqualsReferentially notEqualsReferentially(ExpressionDef other) {
        return new NotEqualsReferentially(this, other);
    }

    default public GetPropertyValue getPropertyValue(PropertyElement propertyElement) {
        return new GetPropertyValue(this, propertyElement);
    }

    @Nullable
    public static ExpressionDef constant(ClassElement type, TypeDef typeDef, @Nullable Object value) {
        Objects.requireNonNull(type, "Type cannot be null");
        if (type.isPrimitive()) {
            return ClassUtils.getPrimitiveType((String)type.getName()).flatMap(t -> ConversionService.SHARED.convert(value, t)).map(o -> new Constant(typeDef, o)).orElse(null);
        }
        if (ClassUtils.isJavaLangType((String)type.getName())) {
            return ClassUtils.forName((String)type.getName(), (ClassLoader)ExpressionDef.class.getClassLoader()).flatMap(t -> ConversionService.SHARED.convert(value, t)).map(o -> new Constant(typeDef, o)).orElse(null);
        }
        if (type.isEnum()) {
            String name;
            if (value instanceof Enum) {
                Enum anEnum = (Enum)value;
                name = anEnum.name();
            } else {
                name = value.toString();
            }
            return ((ClassTypeDef)typeDef).getStaticField(name, typeDef);
        }
        return ExpressionDef.nullValue();
    }

    @Nullable
    public static Constant constant(@Nullable Object value) {
        if (value == null) {
            return ExpressionDef.nullValue();
        }
        TypeDef type = value instanceof TypeDef ? TypeDef.CLASS : TypeDef.of(value.getClass());
        return new Constant(type, value);
    }

    public static Constant constant(boolean value) {
        return new Constant(TypeDef.Primitive.BOOLEAN, value);
    }

    public static Constant constant(int value) {
        return new Constant(TypeDef.Primitive.INT, value);
    }

    public static Constant constant(long value) {
        return new Constant(TypeDef.Primitive.LONG, value);
    }

    public static Constant constant(double value) {
        return new Constant(TypeDef.Primitive.DOUBLE, value);
    }

    public static Constant constant(float value) {
        return new Constant(TypeDef.Primitive.FLOAT, Float.valueOf(value));
    }

    public static Constant constant(char value) {
        return new Constant(TypeDef.Primitive.CHAR, Character.valueOf(value));
    }

    @Nullable
    public static Constant primitiveConstant(Object value) {
        Class primitiveType = ReflectionUtils.getPrimitiveType(value.getClass());
        return new Constant(TypeDef.primitive(primitiveType), value);
    }

    public TypeDef type();

    public record ArrayElement(ExpressionDef expression, TypeDef type, ExpressionDef indexExpression) implements ExpressionDef
    {
        public ArrayElement(ExpressionDef expression, TypeDef type, int index) {
            this(expression, type, ExpressionDef.constant(index));
        }

        public ArrayElement(ExpressionDef expression, int index) {
            this(expression, ArrayElement.findComponentType(expression.type()), index);
        }

        public ArrayElement(ExpressionDef expression, ExpressionDef indexExpression) {
            this(expression, ArrayElement.findComponentType(expression.type()), indexExpression);
        }

        private static TypeDef findComponentType(TypeDef arrayType) {
            if (arrayType instanceof TypeDef.Array) {
                TypeDef.Array array = (TypeDef.Array)arrayType;
                return array.componentType();
            }
            throw new IllegalArgumentException(arrayType + " is not an array");
        }
    }

    public record InstanceOf(ExpressionDef expression, ClassTypeDef instanceType) implements ConditionExpressionDef,
    ExpressionDef
    {
        public InstanceOf(ExpressionDef expression, ClassTypeDef instanceType) {
            this.expression = expression.type().isPrimitive() ? expression.cast(TypeDef.OBJECT) : expression;
            this.instanceType = instanceType;
        }
    }

    public record ComparisonOperation(OpType opType, ExpressionDef left, ExpressionDef right) implements ConditionExpressionDef
    {
        public ComparisonOperation(OpType opType, ExpressionDef left, ExpressionDef right) {
            if (opType != OpType.EQUAL_TO && opType != OpType.NOT_EQUAL_TO) {
                TypeDef.Primitive rightPrimitive;
                TypeDef.Primitive leftPrimitive;
                if (this.isNull(left)) {
                    throw new IllegalStateException("Comparison left type cannot be null for operation " + opType);
                }
                TypeDef leftType = TypeDef.Primitive.unboxIfPossible(left.type());
                if (!(leftType instanceof TypeDef.Primitive) || !(leftPrimitive = (TypeDef.Primitive)leftType).isNumber()) {
                    throw new IllegalStateException("Comparison left type should be a primitive number: " + leftType);
                }
                if (leftType != left.type()) {
                    left = left.cast(leftType);
                }
                if (this.isNull(right)) {
                    throw new IllegalStateException("Comparison right type cannot be null for operation " + opType);
                }
                TypeDef rightType = TypeDef.Primitive.unboxIfPossible(right.type());
                if (!(rightType instanceof TypeDef.Primitive) || !(rightPrimitive = (TypeDef.Primitive)rightType).isNumber()) {
                    throw new IllegalStateException("Comparison right type should be a primitive number: " + rightType);
                }
                if (rightType != right.type()) {
                    right = right.cast(rightType);
                }
            }
            this.opType = opType;
            this.right = right.cast(left.type());
            this.left = left;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isNull(ExpressionDef v) {
            if (!(v instanceof Constant)) return false;
            Constant constant = (Constant)v;
            if (constant.value != null) return false;
            return true;
        }

        public static enum OpType {
            EQUAL_TO,
            NOT_EQUAL_TO,
            GREATER_THAN,
            LESS_THAN,
            GREATER_THAN_OR_EQUAL,
            LESS_THAN_OR_EQUAL;

        }
    }

    public record MathBinaryOperation(OpType opType, ExpressionDef left, ExpressionDef right) implements ExpressionDef
    {
        public MathBinaryOperation(OpType opType, ExpressionDef left, ExpressionDef right) {
            TypeDef.Primitive rightPrimitive;
            TypeDef.Primitive leftPrimitive;
            TypeDef typeDef = left.type();
            if (!(typeDef instanceof TypeDef.Primitive) || !(leftPrimitive = (TypeDef.Primitive)typeDef).isNumber()) {
                throw new IllegalStateException("Math left type should be a primitive number");
            }
            TypeDef typeDef2 = right.type();
            if (!(typeDef2 instanceof TypeDef.Primitive) || !(rightPrimitive = (TypeDef.Primitive)typeDef2).isNumber()) {
                throw new IllegalStateException("Math right type should be a primitive number");
            }
            this.opType = opType;
            this.left = left;
            this.right = right.cast(left.type());
        }

        @Override
        public TypeDef type() {
            return this.left.type();
        }

        public static enum OpType {
            ADDITION,
            SUBTRACTION,
            MULTIPLICATION,
            DIVISION,
            MODULUS,
            BITWISE_AND,
            BITWISE_OR,
            BITWISE_XOR,
            BITWISE_LEFT_SHIFT,
            BITWISE_RIGHT_SHIFT,
            BITWISE_UNSIGNED_RIGHT_SHIFT;

        }
    }

    public record MathUnaryOperation(OpType opType, ExpressionDef expression) implements ExpressionDef
    {
        @Override
        public TypeDef type() {
            return this.expression.type();
        }

        public static enum OpType {
            NEGATE;

        }
    }

    public record IsNotNull(ExpressionDef expression) implements ConditionExpressionDef
    {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ConditionExpressionDef
    extends ExpressionDef {
        @Override
        default public TypeDef type() {
            return TypeDef.Primitive.BOOLEAN;
        }

        default public StatementDef doIf(StatementDef statement) {
            return new StatementDef.If(this, statement);
        }

        default public StatementDef doIfElse(StatementDef statement, StatementDef elseStatement) {
            return new StatementDef.IfElse(this, statement, elseStatement);
        }

        default public ExpressionDef doIfElse(ExpressionDef expression, ExpressionDef elseExpression) {
            return new IfElse(this, expression, elseExpression);
        }

        default public ConditionExpressionDef and(ConditionExpressionDef expression) {
            return new And(this, expression);
        }

        default public ConditionExpressionDef or(ConditionExpressionDef expression) {
            return new Or(this, expression);
        }
    }

    public record IsNull(ExpressionDef expression) implements ConditionExpressionDef
    {
    }

    public record IsTrue(ExpressionDef expression) implements ConditionExpressionDef
    {
    }

    public record Cast(TypeDef type, ExpressionDef expressionDef) implements ExpressionDef
    {
    }

    public record IsFalse(ExpressionDef expression) implements ConditionExpressionDef
    {
    }

    public record Constant(TypeDef type, @Nullable Object value) implements ExpressionDef
    {
    }

    public record Switch(ExpressionDef expression, TypeDef type, Map<Constant, ? extends ExpressionDef> cases, ExpressionDef defaultCase) implements ExpressionDef
    {
    }

    public record InvokeInstanceMethod(ExpressionDef instance, MethodDef method, boolean isDefault, List<? extends ExpressionDef> values) implements ExpressionDef,
    StatementDef
    {
        public InvokeInstanceMethod(ExpressionDef instance, MethodDef method, List<? extends ExpressionDef> values) {
            this(instance, method, false, values);
        }

        public InvokeInstanceMethod {
            if (method.getParameters().size() != values.size()) {
                throw new IllegalStateException("Method " + method.getName() + " parameters: " + method.getParameters().size() + " doesn't match values provided: " + values.size());
            }
        }

        @Override
        public TypeDef type() {
            return this.method.getReturnType();
        }
    }

    public record InvokeHashCodeMethod(ExpressionDef instance) implements ExpressionDef
    {
        @Override
        public TypeDef type() {
            return TypeDef.of(Integer.TYPE);
        }
    }

    public record InvokeGetClassMethod(ExpressionDef instance) implements ExpressionDef
    {
        @Override
        public TypeDef type() {
            return TypeDef.of(Class.class);
        }
    }

    public record EqualsStructurally(ExpressionDef instance, ExpressionDef other) implements ConditionExpressionDef
    {
    }

    public record NotEqualsStructurally(ExpressionDef instance, ExpressionDef other) implements ConditionExpressionDef
    {
    }

    public record EqualsReferentially(ExpressionDef instance, ExpressionDef other) implements ConditionExpressionDef
    {
    }

    public record NotEqualsReferentially(ExpressionDef instance, ExpressionDef other) implements ConditionExpressionDef
    {
    }

    public record GetPropertyValue(ExpressionDef instance, PropertyElement propertyElement) implements ExpressionDef
    {
        @Override
        public TypeDef type() {
            return TypeDef.of((TypedElement)this.propertyElement.getType());
        }
    }

    public static final class NewArrayInitialized
    extends Record
    implements ExpressionDef {
        private final TypeDef.Array type;
        private final List<? extends ExpressionDef> expressions;

        public NewArrayInitialized(TypeDef.Array type, List<? extends ExpressionDef> expressions) {
            this.type = type;
            this.expressions = expressions;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{NewArrayInitialized.class, "type;expressions", "type", "expressions"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NewArrayInitialized.class, "type;expressions", "type", "expressions"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NewArrayInitialized.class, "type;expressions", "type", "expressions"}, this, o);
        }

        @Override
        public TypeDef.Array type() {
            return this.type;
        }

        public List<? extends ExpressionDef> expressions() {
            return this.expressions;
        }
    }

    public static final class NewArrayOfSize
    extends Record
    implements ExpressionDef {
        private final TypeDef.Array type;
        private final int size;

        public NewArrayOfSize(TypeDef.Array type, int size) {
            this.type = type;
            this.size = size;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{NewArrayOfSize.class, "type;size", "type", "size"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NewArrayOfSize.class, "type;size", "type", "size"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NewArrayOfSize.class, "type;size", "type", "size"}, this, o);
        }

        @Override
        public TypeDef.Array type() {
            return this.type;
        }

        public int size() {
            return this.size;
        }
    }

    public record SwitchYieldCase(TypeDef type, StatementDef statement) implements ExpressionDef
    {
    }

    public record IfElse(ExpressionDef condition, ExpressionDef ifExpression, ExpressionDef elseExpression, TypeDef type) implements ExpressionDef
    {
        public IfElse(ExpressionDef condition, ExpressionDef ifExpression, ExpressionDef elseExpression) {
            this(condition, ifExpression, elseExpression, ifExpression.type().equals(elseExpression.type()) ? ifExpression.type() : TypeDef.OBJECT);
        }
    }

    public record Or(ConditionExpressionDef left, ConditionExpressionDef right) implements ConditionExpressionDef
    {
    }

    public record And(ConditionExpressionDef left, ConditionExpressionDef right) implements ConditionExpressionDef
    {
    }

    public record InvokeStaticMethod(ClassTypeDef classDef, MethodDef method, List<? extends ExpressionDef> values) implements ExpressionDef,
    StatementDef
    {
        public InvokeStaticMethod {
            if (method.getParameters().size() != values.size()) {
                throw new IllegalStateException("Method " + classDef.getName() + "#" + method.getName() + " parameters: " + method.getParameters().size() + " doesn't match values provided: " + values.size());
            }
        }

        @Override
        public TypeDef type() {
            return this.method.getReturnType();
        }
    }

    public static final class NewInstance
    extends Record
    implements ExpressionDef {
        private final ClassTypeDef type;
        private final List<TypeDef> parameterTypes;
        private final List<? extends ExpressionDef> values;

        public NewInstance(ClassTypeDef type, List<TypeDef> parameterTypes, List<? extends ExpressionDef> values) {
            if (parameterTypes.size() != values.size()) {
                throw new IllegalStateException("Cannot create a new instance of " + type.getName() + " parameters: " + parameterTypes.size() + " doesn't match values provided: " + values.size());
            }
            this.type = type;
            this.parameterTypes = parameterTypes;
            this.values = values;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{NewInstance.class, "type;parameterTypes;values", "type", "parameterTypes", "values"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NewInstance.class, "type;parameterTypes;values", "type", "parameterTypes", "values"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NewInstance.class, "type;parameterTypes;values", "type", "parameterTypes", "values"}, this, o);
        }

        @Override
        public ClassTypeDef type() {
            return this.type;
        }

        public List<TypeDef> parameterTypes() {
            return this.parameterTypes;
        }

        public List<? extends ExpressionDef> values() {
            return this.values;
        }
    }
}

