/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.model;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.sourcegen.model.AnnotationDef;
import io.micronaut.sourcegen.model.ClassTypeDef;
import io.micronaut.sourcegen.model.EnumDef;
import io.micronaut.sourcegen.model.FieldDef;
import io.micronaut.sourcegen.model.MethodDef;
import io.micronaut.sourcegen.model.ObjectDef;
import io.micronaut.sourcegen.model.ObjectDefBuilder;
import io.micronaut.sourcegen.model.ParameterDef;
import io.micronaut.sourcegen.model.PropertyDef;
import io.micronaut.sourcegen.model.StatementDef;
import io.micronaut.sourcegen.model.TypeDef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.lang.model.element.Modifier;

public final class ClassDef
extends ObjectDef {
    private final List<FieldDef> fields;
    private final List<TypeDef.TypeVariable> typeVariables;
    private final ClassTypeDef superclass;
    private final StatementDef staticInitializer;

    private ClassDef(ClassTypeDef.ClassName className, EnumSet<Modifier> modifiers, List<FieldDef> fields, List<MethodDef> methods, List<PropertyDef> properties, List<AnnotationDef> annotations, List<String> javadoc, List<TypeDef.TypeVariable> typeVariables, List<TypeDef> superinterfaces, ClassTypeDef superclass, List<ObjectDef> innerTypes, StatementDef staticInitializer, boolean synthetic) {
        super(className, modifiers, annotations, javadoc, methods, properties, superinterfaces, innerTypes, synthetic);
        ClassTypeDef.of(this);
        this.fields = fields;
        this.typeVariables = typeVariables;
        this.superclass = superclass;
        this.staticInitializer = staticInitializer;
    }

    @Override
    public ClassDef withClassName(ClassTypeDef.ClassName className) {
        return new ClassDef(className, this.modifiers, this.fields, this.methods, this.properties, this.annotations, this.javadoc, this.typeVariables, this.superinterfaces, this.superclass, this.innerTypes, this.staticInitializer, this.synthetic);
    }

    @Override
    public ClassTypeDef asTypeDef() {
        if (this.typeVariables.isEmpty()) {
            return super.asTypeDef();
        }
        return TypeDef.parameterized(super.asTypeDef(), (TypeDef[])this.typeVariables.toArray(new TypeDef.TypeVariable[0]));
    }

    public static ClassDefBuilder builder(String name) {
        return new ClassDefBuilder(name);
    }

    public List<FieldDef> getFields() {
        return this.fields;
    }

    public List<TypeDef.TypeVariable> getTypeVariables() {
        return this.typeVariables;
    }

    @Nullable
    public ClassTypeDef getSuperclass() {
        return this.superclass;
    }

    @Nullable
    public FieldDef findField(String name) {
        for (FieldDef field : this.fields) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        for (PropertyDef property : this.getProperties()) {
            if (!property.getName().equals(name)) continue;
            return FieldDef.builder(property.getName()).ofType(property.getType()).build();
        }
        return null;
    }

    @NonNull
    public FieldDef getField(String name) {
        FieldDef field = this.findField(name);
        if (field == null) {
            throw new IllegalStateException("Class: " + String.valueOf(this.className) + " doesn't have a field: " + name);
        }
        return null;
    }

    public boolean hasField(String name) {
        FieldDef field = this.findField(name);
        if (field != null) {
            return true;
        }
        if (this.superclass != null) {
            Object enumDef;
            ClassTypeDef.ClassDefType classDefType;
            ClassTypeDef classTypeDef = this.superclass;
            if (classTypeDef instanceof ClassTypeDef.ClassElementType) {
                ClassTypeDef.ClassElementType classElementType = (ClassTypeDef.ClassElementType)classTypeDef;
                return classElementType.classElement().findField(name).isPresent();
            }
            Object object = this.superclass;
            if (object instanceof ClassTypeDef.ClassDefType && (object = (classDefType = (ClassTypeDef.ClassDefType)object).objectDef()) instanceof ClassDef) {
                ClassDef classDef = (ClassDef)object;
                return classDef.hasField(name);
            }
            object = this.superclass;
            if (object instanceof ClassTypeDef.ClassDefType && (object = (classDefType = (ClassTypeDef.ClassDefType)object).objectDef()) instanceof EnumDef) {
                enumDef = (EnumDef)object;
                return ((EnumDef)enumDef).hasField(name);
            }
            enumDef = this.superclass;
            if (enumDef instanceof ClassTypeDef.JavaClass) {
                ClassTypeDef.JavaClass javaClass = (ClassTypeDef.JavaClass)enumDef;
                try {
                    javaClass.type().getField(name);
                    return true;
                }
                catch (NoSuchFieldException e) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    public StatementDef getStaticInitializer() {
        return this.staticInitializer;
    }

    public String toString() {
        return "ClassDef{name='" + String.valueOf(this.className) + "'}";
    }

    public static final class ClassDefBuilder
    extends ObjectDefBuilder<ClassDefBuilder> {
        private final List<FieldDef> fields = new ArrayList<FieldDef>();
        private final List<TypeDef.TypeVariable> typeVariables = new ArrayList<TypeDef.TypeVariable>();
        private ClassTypeDef superclass;
        private StatementDef staticInitializer;

        private ClassDefBuilder(String name) {
            super(name);
        }

        public ClassDefBuilder superclass(ClassTypeDef superclass) {
            this.superclass = superclass;
            return this;
        }

        public ClassDefBuilder addField(FieldDef field) {
            this.fields.add(field);
            return this;
        }

        public ClassDefBuilder addFields(Collection<FieldDef> fields) {
            fields.forEach(this::addField);
            return this;
        }

        public ClassDefBuilder addTypeVariable(TypeDef.TypeVariable typeVariable) {
            this.typeVariables.add(typeVariable);
            return this;
        }

        public ClassDefBuilder addStaticInitializer(StatementDef staticInitializer) {
            this.staticInitializer = staticInitializer;
            return this;
        }

        public ClassDef build() {
            return new ClassDef(new ClassTypeDef.ClassName(this.name), this.modifiers, this.fields, this.methods, this.properties, this.annotations, this.javadoc, this.typeVariables, this.superinterfaces, this.superclass, this.innerTypes, this.staticInitializer, this.synthetic);
        }

        public ClassDefBuilder addConstructor(Collection<ParameterDef> parameterDefs, Modifier ... modifiers) {
            return (ClassDefBuilder)this.addMethod(MethodDef.constructor(parameterDefs, modifiers));
        }

        public ClassDefBuilder addAllFieldsConstructor(Modifier ... modifiers) {
            ArrayList<ParameterDef> constructorParameters = new ArrayList<ParameterDef>();
            for (PropertyDef property : this.properties) {
                constructorParameters.add(ParameterDef.of(property.getName(), property.getType()));
            }
            for (FieldDef field : this.fields) {
                constructorParameters.add(ParameterDef.of(field.getName(), field.getType()));
            }
            return (ClassDefBuilder)this.addMethod(MethodDef.constructor(constructorParameters, modifiers));
        }

        public ClassDefBuilder addNoFieldsConstructor(Modifier ... modifiers) {
            return (ClassDefBuilder)this.addMethod(MethodDef.constructor(Collections.emptyList(), modifiers));
        }
    }
}

