/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.model;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MemberElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.sourcegen.model.ClassTypeDef;
import io.micronaut.sourcegen.model.ExpressionDef;
import io.micronaut.sourcegen.model.MethodDef;
import io.micronaut.sourcegen.model.TypeDef;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@Internal
public final class JavaIdioms {
    private static final MethodDef ARRAYS_DEEP_EQUALS = MethodDef.builder("deepEquals").returns(Boolean.TYPE).addParameters(TypeDef.OBJECT.array(), TypeDef.OBJECT.array()).build();
    private static final MethodDef ARRAYS_DEEP_HASHCODE = MethodDef.builder("deepHashCode").returns(Integer.TYPE).addParameter(TypeDef.OBJECT.array()).build();
    private static final MethodDef OBJECT_EQUALS = MethodDef.builder("equals").returns(Boolean.TYPE).addParameter(Object.class).build();
    private static final MethodDef OBJECT_HASHCODE = MethodDef.builder("hashCode").returns(Integer.TYPE).build();
    private static final ClassTypeDef ARRAYS_TYPE = ClassTypeDef.of(Arrays.class);
    private static final Method STRING_BUILDER_APPEND_STRING = ReflectionUtils.getRequiredMethod(StringBuilder.class, (String)"append", (Class[])new Class[]{String.class});
    private static final Method STRING_BUILDER_APPEND_OBJECT = ReflectionUtils.getRequiredMethod(StringBuilder.class, (String)"append", (Class[])new Class[]{Object.class});
    private static final Method STRING_BUILDER_TO_STRING = ReflectionUtils.getRequiredMethod(StringBuilder.class, (String)"toString", (Class[])new Class[0]);

    public static ExpressionDef concatStrings(ExpressionDef ... stringExpressions) {
        return JavaIdioms.concatStrings(Arrays.asList(stringExpressions));
    }

    public static ExpressionDef concatStrings(List<? extends ExpressionDef> stringExpressions) {
        if (stringExpressions.isEmpty()) {
            return ExpressionDef.constant("");
        }
        if (stringExpressions.size() == 1) {
            return JavaIdioms.convertToStringIfNeeded(stringExpressions.get(0));
        }
        ExpressionDef stringBuilderExp = null;
        for (ExpressionDef expressionDef : stringExpressions) {
            if (stringBuilderExp == null) {
                stringBuilderExp = ClassTypeDef.of(StringBuilder.class).instantiate(JavaIdioms.convertToStringIfNeeded(expressionDef));
                continue;
            }
            if (expressionDef.type().equals(TypeDef.STRING)) {
                stringBuilderExp = stringBuilderExp.invoke(STRING_BUILDER_APPEND_STRING, expressionDef);
                continue;
            }
            if (expressionDef.type().isArray()) {
                stringBuilderExp = stringBuilderExp.invoke(STRING_BUILDER_APPEND_STRING, JavaIdioms.convertToStringIfNeeded(expressionDef));
                continue;
            }
            stringBuilderExp = stringBuilderExp.invoke(STRING_BUILDER_APPEND_OBJECT, expressionDef);
        }
        return stringBuilderExp.invoke(STRING_BUILDER_TO_STRING, new ExpressionDef[0]);
    }

    public static ExpressionDef convertToStringIfNeeded(ExpressionDef expression) {
        ClassTypeDef classTypeDef;
        TypeDef type = expression.type();
        if (type instanceof ClassTypeDef && (classTypeDef = (ClassTypeDef)type).getName().equals(String.class.getName())) {
            return expression;
        }
        if (type.isArray()) {
            return ClassTypeDef.of(Arrays.class).invokeStatic("toString", (TypeDef)TypeDef.STRING, expression);
        }
        return ClassTypeDef.of(String.class).invokeStatic("valueOf", List.of(TypeDef.OBJECT), (TypeDef)TypeDef.STRING, expression);
    }

    public static ExpressionDef equalsStructurally(ExpressionDef.EqualsStructurally equalsStructurally) {
        ExpressionDef left = equalsStructurally.instance();
        ExpressionDef right = equalsStructurally.other();
        return JavaIdioms.equalsStructurally(left, right);
    }

    public static ExpressionDef equalsStructurally(ExpressionDef left, ExpressionDef right) {
        TypeDef type = left.type();
        if (type instanceof TypeDef.Array) {
            TypeDef.Array array = (TypeDef.Array)type;
            if (array.dimensions() > 1) {
                return ARRAYS_TYPE.invokeStatic(ARRAYS_DEEP_EQUALS, left, right);
            }
            return ARRAYS_TYPE.invokeStatic("equals", (TypeDef)TypeDef.Primitive.BOOLEAN, left, right);
        }
        return left.invoke(OBJECT_EQUALS, right);
    }

    public static ExpressionDef hashCode(ExpressionDef.InvokeHashCodeMethod invokeHashCodeMethod) {
        ExpressionDef instance = invokeHashCodeMethod.instance();
        TypeDef type = instance.type();
        TypeDef.Primitive primitiveIntType = TypeDef.Primitive.INT;
        if (type instanceof TypeDef.Array) {
            TypeDef.Array array = (TypeDef.Array)type;
            if (array.dimensions() > 1) {
                return ARRAYS_TYPE.invokeStatic(ARRAYS_DEEP_HASHCODE, instance);
            }
            return ARRAYS_TYPE.invokeStatic("hashCode", (TypeDef)primitiveIntType, instance);
        }
        if (type instanceof TypeDef.Primitive) {
            TypeDef.Primitive primitive = (TypeDef.Primitive)type;
            return primitive.wrapperType().invokeStatic("hashCode", (TypeDef)primitiveIntType, instance);
        }
        return instance.ifNull(primitiveIntType.constant(0), instance.invoke(OBJECT_HASHCODE, new ExpressionDef[0]));
    }

    public static ExpressionDef getClass(ExpressionDef.InvokeGetClassMethod invokeGetClassMethod) {
        return invokeGetClassMethod.instance().invoke("getClass", (TypeDef)TypeDef.CLASS, new ExpressionDef[0]);
    }

    public static ExpressionDef getPropertyValue(ExpressionDef.GetPropertyValue getPropertyValue) {
        PropertyElement propertyElement = getPropertyValue.propertyElement();
        Optional readPropertyMember = propertyElement.getReadMember();
        if (readPropertyMember.isEmpty()) {
            throw new IllegalStateException("Read member not found for property: " + String.valueOf(propertyElement));
        }
        MemberElement memberElement = (MemberElement)readPropertyMember.get();
        if (memberElement instanceof MethodElement) {
            MethodElement methodElement = (MethodElement)memberElement;
            return getPropertyValue.instance().invoke(methodElement, new ExpressionDef[0]);
        }
        if (memberElement instanceof FieldElement) {
            FieldElement fieldElement = (FieldElement)memberElement;
            return getPropertyValue.instance().field(fieldElement);
        }
        throw new IllegalStateException("Unrecognized property read element: " + String.valueOf(propertyElement));
    }
}

