/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.model;

import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.inject.ast.ArrayableClassElement;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.GenericPlaceholderElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.ast.WildcardElement;
import io.micronaut.sourcegen.model.AnnotationDef;
import io.micronaut.sourcegen.model.ClassTypeDef;
import io.micronaut.sourcegen.model.ExpressionDef;
import io.micronaut.sourcegen.model.SuperType;
import io.micronaut.sourcegen.model.ThisType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface TypeDef {
    public static final Primitive VOID = TypeDef.primitive(Void.TYPE);
    public static final ClassTypeDef OBJECT = ClassTypeDef.of(Object.class);
    public static final ClassTypeDef CLASS = ClassTypeDef.of(Class.class);
    public static final ClassTypeDef STRING = ClassTypeDef.of(String.class);
    public static final ClassTypeDef THIS = ClassTypeDef.of(ThisType.class);
    public static final ClassTypeDef SUPER = ClassTypeDef.of(SuperType.class);

    default public Annotated annotated(AnnotationDef ... annotations) {
        return this.annotated(List.of(annotations));
    }

    default public Annotated annotated(List<AnnotationDef> annotations) {
        return new AnnotatedTypeDef(this, annotations);
    }

    default public Array array() {
        return new Array(this, 1, false);
    }

    default public Array array(int dimension) {
        return new Array(this, dimension, false);
    }

    public static TypeDef of(String name) {
        int dimension = 0;
        while (name.endsWith("[]")) {
            ++dimension;
            name = name.substring(0, name.length() - 2);
        }
        if (dimension > 0) {
            return new Array(TypeDef.of(name), dimension, false);
        }
        return switch (name) {
            case "void", "V" -> VOID;
            case "byte", "B" -> Primitive.BYTE;
            case "int", "I" -> Primitive.INT;
            case "boolean", "Z" -> Primitive.BOOLEAN;
            case "long", "J" -> Primitive.LONG;
            case "char", "C" -> Primitive.CHAR;
            case "short", "S" -> Primitive.SHORT;
            case "double", "D" -> Primitive.DOUBLE;
            case "float", "F" -> Primitive.FLOAT;
            default -> ClassTypeDef.of(name);
        };
    }

    public static Primitive primitive(String type) {
        return switch (type) {
            case "void", "V" -> Primitive.VOID;
            case "byte", "B" -> Primitive.BYTE;
            case "int", "I" -> Primitive.INT;
            case "boolean", "Z" -> Primitive.BOOLEAN;
            case "long", "J" -> Primitive.LONG;
            case "char", "C" -> Primitive.CHAR;
            case "short", "S" -> Primitive.SHORT;
            case "double", "D" -> Primitive.DOUBLE;
            case "float", "F" -> Primitive.FLOAT;
            default -> throw new IllegalStateException("Expected a primitive type got: " + type);
        };
    }

    public static Primitive primitive(Class<?> type) {
        if (!type.isPrimitive()) {
            throw new IllegalStateException("Expected a primitive type got: " + type);
        }
        return new Primitive(type);
    }

    public static Wildcard wildcard() {
        return new Wildcard(Collections.singletonList(TypeDef.of(Object.class)), Collections.emptyList());
    }

    public static Wildcard wildcardSubtypeOf(TypeDef upperBound) {
        return new Wildcard(Collections.singletonList(upperBound), Collections.emptyList());
    }

    public static Wildcard wildcardSupertypeOf(TypeDef lowerBound) {
        return new Wildcard(Collections.singletonList(TypeDef.of(Object.class)), Collections.singletonList(lowerBound));
    }

    public static Array array(TypeDef componentType) {
        return new Array(componentType, 1, false);
    }

    public static Array array(TypeDef componentType, int dimensions) {
        return new Array(componentType, dimensions, false);
    }

    public static TypeDef of(Class<?> type) {
        if (type.isPrimitive()) {
            return TypeDef.primitive(type);
        }
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            int dimensions = 1;
            while (componentType.isArray()) {
                componentType = componentType.getComponentType();
                ++dimensions;
            }
            return new Array(TypeDef.of(componentType), dimensions, false);
        }
        return ClassTypeDef.of(type);
    }

    public static ClassTypeDef parameterized(Class<?> type, Class<?> ... genericParameters) {
        return TypeDef.parameterized(ClassTypeDef.of(type), Stream.of(genericParameters).map(TypeDef::of).toList());
    }

    public static ClassTypeDef parameterized(Class<?> type, TypeDef ... genericParameters) {
        return TypeDef.parameterized(ClassTypeDef.of(type), genericParameters);
    }

    public static ClassTypeDef parameterized(ClassTypeDef type, TypeDef ... genericParameters) {
        return TypeDef.parameterized(type, List.of(genericParameters));
    }

    public static ClassTypeDef parameterized(ClassTypeDef type, Class<?> ... genericParameters) {
        return TypeDef.parameterized(type, Stream.of(genericParameters).map(TypeDef::of).toList());
    }

    public static ClassTypeDef parameterized(ClassTypeDef type, List<TypeDef> genericParameters) {
        return new ClassTypeDef.Parameterized(type, genericParameters);
    }

    public static TypeVariable variable(String name, List<TypeDef> bounds) {
        return new TypeVariable(name, bounds);
    }

    public static TypeVariable variable(String name, TypeDef ... bounds) {
        return new TypeVariable(name, List.of(bounds));
    }

    public static TypeDef of(TypedElement typedElement) {
        return TypeDef.of(typedElement, false);
    }

    public static TypeDef erasure(TypedElement typedElement) {
        return TypeDef.of(typedElement, true);
    }

    private static TypeDef of(TypedElement typedElement, boolean erasure) {
        ClassElement classElement;
        int dimensions = 0;
        while (typedElement.isArray()) {
            ArrayableClassElement arrayableClassElement = (ArrayableClassElement)typedElement;
            typedElement = arrayableClassElement.fromArray();
            ++dimensions;
        }
        if (dimensions > 0) {
            return TypeDef.array(TypeDef.of(typedElement), dimensions);
        }
        if (typedElement.isPrimitive()) {
            return TypeDef.primitive(typedElement.getName());
        }
        if (erasure && typedElement instanceof ClassElement) {
            classElement = (ClassElement)typedElement;
            return ClassTypeDef.of(classElement);
        }
        if (typedElement instanceof GenericPlaceholderElement) {
            GenericPlaceholderElement placeholderElement = (GenericPlaceholderElement)typedElement;
            return TypeDef.variable(placeholderElement.getVariableName(), placeholderElement.getBounds().stream().map(TypeDef::of).toList());
        }
        if (typedElement instanceof WildcardElement) {
            WildcardElement wildcardElement = (WildcardElement)typedElement;
            return new Wildcard(wildcardElement.getUpperBounds().stream().map(TypeDef::of).toList(), wildcardElement.getLowerBounds().stream().map(TypeDef::of).toList());
        }
        if (typedElement instanceof ClassElement) {
            classElement = (ClassElement)typedElement;
            if (classElement.getFirstTypeArgument().isPresent()) {
                return TypeDef.parameterized(ClassTypeDef.of(classElement), classElement.getBoundGenericTypes().stream().map(TypeDef::of).toList());
            }
            return ClassTypeDef.of(classElement);
        }
        throw new IllegalStateException("Unknown typed element: " + typedElement);
    }

    default public boolean isNullable() {
        return false;
    }

    default public boolean isPrimitive() {
        return this instanceof Primitive;
    }

    default public boolean isArray() {
        return this instanceof Array;
    }

    default public TypeDef makeNullable() {
        return this;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Annotated
    extends TypeDef {
    }

    public record AnnotatedTypeDef(TypeDef typeDef, List<AnnotationDef> annotations) implements Annotated
    {
    }

    public record Array(TypeDef componentType, int dimensions, boolean nullable) implements TypeDef
    {
        public Array {
            if (componentType instanceof Array) {
                throw new IllegalArgumentException("Arrays can't have arrays");
            }
        }

        @Override
        public Array array() {
            return new Array(this.componentType, this.dimensions + 1, this.nullable);
        }

        @Override
        public Array array(int dimension) {
            return new Array(this.componentType, this.dimensions + dimension, this.nullable);
        }

        public ExpressionDef.NewArrayOfSize instantiate(int size) {
            return new ExpressionDef.NewArrayOfSize(this, size);
        }

        public ExpressionDef.NewArrayInitialized instantiate(List<? extends ExpressionDef> expressions) {
            return new ExpressionDef.NewArrayInitialized(this, expressions);
        }

        public ExpressionDef instantiate(ExpressionDef ... expressions) {
            return this.instantiate(List.of(expressions));
        }

        @Override
        public boolean isNullable() {
            return this.nullable;
        }

        @Override
        public TypeDef makeNullable() {
            return new Array(this.componentType, this.dimensions, true);
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public boolean isArray() {
            return true;
        }
    }

    public record Primitive(Class<?> clazz) implements TypeDef
    {
        public static final Primitive INT = TypeDef.primitive(Integer.TYPE);
        public static final Primitive BOOLEAN = TypeDef.primitive(Boolean.TYPE);
        public static final Primitive LONG = TypeDef.primitive(Long.TYPE);
        public static final Primitive CHAR = TypeDef.primitive(Character.TYPE);
        public static final Primitive BYTE = TypeDef.primitive(Byte.TYPE);
        public static final Primitive SHORT = TypeDef.primitive(Short.TYPE);
        public static final Primitive DOUBLE = TypeDef.primitive(Double.TYPE);
        public static final Primitive FLOAT = TypeDef.primitive(Float.TYPE);
        public static final ExpressionDef.Constant TRUE = BOOLEAN.constant(true);
        public static final ExpressionDef.Constant FALSE = BOOLEAN.constant(false);
        public static final ClassTypeDef BOOLEAN_WRAPPER = BOOLEAN.wrapperType();
        public static final ClassTypeDef INT_WRAPPER = INT.wrapperType();
        public static final ClassTypeDef LONG_WRAPPER = LONG.wrapperType();
        public static final ClassTypeDef DOUBLE_WRAPPER = DOUBLE.wrapperType();
        public static final ClassTypeDef FLOAT_WRAPPER = FLOAT.wrapperType();
        public static final ClassTypeDef SHORT_WRAPPER = SHORT.wrapperType();
        public static final ClassTypeDef BYTE_WRAPPER = BYTE.wrapperType();
        public static final ClassTypeDef CHAR_WRAPPER = CHAR.wrapperType();
        private static final Map<TypeDef, ClassTypeDef> PRIMITIVE_TO_WRAPPER = Map.of(BOOLEAN, BOOLEAN_WRAPPER, INT, INT_WRAPPER, DOUBLE, DOUBLE_WRAPPER, LONG, LONG_WRAPPER, FLOAT, FLOAT_WRAPPER, SHORT, SHORT_WRAPPER, CHAR, CHAR_WRAPPER, BYTE, BYTE_WRAPPER);
        private static final Map<String, TypeDef> WRAPPER_TO_PRIMITIVE = PRIMITIVE_TO_WRAPPER.entrySet().stream().collect(Collectors.toMap(e -> ((ClassTypeDef)e.getValue()).getName(), Map.Entry::getKey));

        public static TypeDef unboxIfPossible(TypeDef typeDef) {
            if (typeDef instanceof ClassTypeDef) {
                ClassTypeDef classTypeDef = (ClassTypeDef)typeDef;
                return WRAPPER_TO_PRIMITIVE.getOrDefault(classTypeDef.getName(), typeDef);
            }
            return typeDef;
        }

        public String name() {
            return this.clazz.getName();
        }

        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        public boolean isArray() {
            return false;
        }

        @Override
        public TypeDef makeNullable() {
            return this.wrapperType().makeNullable();
        }

        public ClassTypeDef wrapperType() {
            Class primitiveType = (Class)ClassUtils.getPrimitiveType((String)this.name()).orElseThrow(() -> new IllegalStateException("Unrecognized primitive type: " + this.name()));
            return ClassTypeDef.of(ReflectionUtils.getWrapperType((Class)primitiveType));
        }

        public ExpressionDef.Constant constant(Object value) {
            return new ExpressionDef.Constant(this, value);
        }

        public boolean isWholeNumber() {
            return this.equals(BYTE) || this.equals(SHORT) || this.equals(INT) || this.equals(LONG);
        }

        public boolean isFloatNumber() {
            return this.equals(DOUBLE) || this.equals(FLOAT);
        }

        public boolean isNumber() {
            return this.isWholeNumber() || this.isFloatNumber();
        }
    }

    public record Wildcard(List<TypeDef> upperBounds, List<TypeDef> lowerBounds) implements TypeDef
    {
        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public boolean isArray() {
            return false;
        }

        @Override
        public TypeDef makeNullable() {
            return this;
        }
    }

    public record TypeVariable(String name, List<TypeDef> bounds, boolean nullable) implements TypeDef
    {
        public TypeVariable(String name) {
            this(name, List.of());
        }

        public TypeVariable(String name, List<TypeDef> bounds) {
            this(name, bounds, false);
        }

        public static TypeVariable of(String name, ClassElement classElement) {
            if (classElement instanceof GenericPlaceholderElement) {
                GenericPlaceholderElement placeholderElement = (GenericPlaceholderElement)classElement;
                return new TypeVariable(name, placeholderElement.getBounds().stream().map(TypeDef::of).toList());
            }
            return new TypeVariable(name);
        }

        @Override
        public TypeDef makeNullable() {
            return new TypeVariable(this.name, this.bounds, true);
        }
    }
}

