/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.model;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.sourcegen.model.AnnotationDef;
import io.micronaut.sourcegen.model.ClassTypeDef;
import io.micronaut.sourcegen.model.ExpressionDef;
import io.micronaut.sourcegen.model.FieldDef;
import io.micronaut.sourcegen.model.MethodDef;
import io.micronaut.sourcegen.model.ObjectDef;
import io.micronaut.sourcegen.model.ObjectDefBuilder;
import io.micronaut.sourcegen.model.ParameterDef;
import io.micronaut.sourcegen.model.PropertyDef;
import io.micronaut.sourcegen.model.TypeDef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.lang.model.element.Modifier;

public final class EnumDef
extends ObjectDef {
    private final List<FieldDef> fields;
    private final List<EnumConstantDef> enumConstants;

    private EnumDef(ClassTypeDef.ClassName className, EnumSet<Modifier> modifiers, List<FieldDef> fields, List<MethodDef> methods, List<PropertyDef> properties, List<AnnotationDef> annotations, List<String> javadoc, List<EnumConstantDef> enumConstants, List<TypeDef> superinterfaces, List<ObjectDef> innerTypes, boolean synthetic) {
        super(className, modifiers, annotations, javadoc, methods, properties, superinterfaces, innerTypes, synthetic);
        this.fields = fields;
        this.enumConstants = enumConstants;
    }

    @Override
    public EnumDef withClassName(ClassTypeDef.ClassName className) {
        return new EnumDef(className, this.modifiers, this.fields, this.methods, this.properties, this.annotations, this.javadoc, this.enumConstants, this.superinterfaces, this.innerTypes, this.synthetic);
    }

    public static EnumDefBuilder builder(String name) {
        return new EnumDefBuilder(name);
    }

    public List<FieldDef> getFields() {
        return this.fields;
    }

    public List<EnumConstantDef> getEnumConstants() {
        return this.enumConstants;
    }

    @Nullable
    public FieldDef findField(String name) {
        for (FieldDef field : this.fields) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        for (PropertyDef property : this.getProperties()) {
            if (!property.getName().equals(name)) continue;
            return FieldDef.builder(property.getName()).ofType(property.getType()).build();
        }
        return null;
    }

    @NonNull
    public FieldDef getField(String name) {
        for (EnumConstantDef constant : this.enumConstants) {
            if (!constant.name().equals(name)) continue;
            return FieldDef.builder(name, this.asTypeDef()).build();
        }
        FieldDef field = this.findField(name);
        if (field == null) {
            throw new IllegalStateException("Enum: " + String.valueOf(this.className) + " doesn't have a field: " + name);
        }
        return null;
    }

    public boolean hasField(String name) {
        FieldDef property = this.findField(name);
        return property != null;
    }

    public static final class EnumDefBuilder
    extends ObjectDefBuilder<EnumDefBuilder> {
        private final List<FieldDef> fields = new ArrayList<FieldDef>();
        private final List<EnumConstantDef> enumConstants = new ArrayList<EnumConstantDef>();

        private EnumDefBuilder(String name) {
            super(name);
        }

        public EnumDefBuilder addField(FieldDef field) {
            this.fields.add(field);
            return this;
        }

        public EnumDefBuilder addEnumConstant(EnumConstantDef constant) {
            this.enumConstants.add(constant);
            return this;
        }

        public EnumDefBuilder addEnumConstant(String name) {
            String constName = EnumDefBuilder.getConstantName(name);
            this.enumConstants.add(new EnumConstantDef(constName, Collections.emptyList(), Collections.emptyList()));
            return this;
        }

        public EnumDefBuilder addEnumConstant(String name, ExpressionDef ... values) {
            Objects.requireNonNull(values, "Values cannot be null");
            String constName = EnumDefBuilder.getConstantName(name);
            this.enumConstants.add(new EnumConstantDef(constName, List.of(values), Collections.emptyList()));
            return this;
        }

        public EnumDef build() {
            if (!this.enumConstants.isEmpty()) {
                HashSet<Integer> valueCount = new HashSet<Integer>();
                for (EnumConstantDef constantDef : this.enumConstants) {
                    int constCount;
                    if (constantDef.constructorArgs == null || constantDef.constructorArgs.isEmpty() || valueCount.contains(constCount = constantDef.constructorArgs.size())) continue;
                    valueCount.add(constCount);
                    boolean hasConstructor = false;
                    for (MethodDef methodDef : this.methods) {
                        if (methodDef.isConstructor() && methodDef.getParameters().size() == constCount) {
                            hasConstructor = true;
                        }
                        if (!methodDef.isConstructor() || methodDef.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
                        throw new IllegalStateException("The constructor of enum: " + this.name + " has to be private.");
                    }
                    if (hasConstructor) continue;
                    throw new IllegalStateException("Enum: " + this.name + " doesn't have a matching constructor for constant " + constantDef.name);
                }
            }
            return new EnumDef(new ClassTypeDef.ClassName(this.name), this.modifiers, this.fields, this.methods, this.properties, this.annotations, this.javadoc, this.enumConstants, this.superinterfaces, this.innerTypes, this.synthetic);
        }

        public EnumDefBuilder addConstructor(Collection<ParameterDef> parameterDefs, Modifier ... modifiers) {
            return (EnumDefBuilder)this.addMethod(MethodDef.constructor(parameterDefs, modifiers));
        }

        public EnumDefBuilder addAllFieldsConstructor(Modifier ... modifiers) {
            ArrayList<ParameterDef> constructorParameters = new ArrayList<ParameterDef>();
            for (PropertyDef property : this.properties) {
                constructorParameters.add(ParameterDef.of(property.getName(), property.getType()));
            }
            for (FieldDef field : this.fields) {
                constructorParameters.add(ParameterDef.of(field.getName(), field.getType()));
            }
            return (EnumDefBuilder)this.addMethod(MethodDef.constructor(constructorParameters, modifiers));
        }

        public EnumDefBuilder addNoFieldsConstructor(Modifier ... modifiers) {
            return (EnumDefBuilder)this.addMethod(MethodDef.constructor(Collections.emptyList(), modifiers));
        }

        private static String getConstantName(String input) {
            if (input.equals(input.toUpperCase())) {
                return input;
            }
            String cleanedInput = input.replaceAll("[-_]", " ").replaceAll("(?<!^)(?=[A-Z])", " ").replaceAll("[^a-zA-Z0-9 ]", "").trim();
            while (!Character.isJavaIdentifierStart(cleanedInput.charAt(0))) {
                cleanedInput = cleanedInput.substring(1);
            }
            CharSequence[] words = cleanedInput.split("\\s+");
            if (words.length == 0 || words[0].isEmpty()) {
                throw new IllegalArgumentException("The enum constant name is not an acceptable identifier name.");
            }
            for (int i = 0; i < words.length; ++i) {
                words[i] = ((String)words[i]).toUpperCase();
            }
            String constantName = String.join((CharSequence)"_", words);
            if (!constantName.equals(input)) {
                throw new IllegalArgumentException("The enum constant name does not follow the conventions for constants, it should be changed accordingly.");
            }
            return constantName;
        }
    }

    public record EnumConstantDef(String name, List<ExpressionDef> constructorArgs, List<String> javadoc) {
        public static EnumConstantDefBuilder builder(String name) {
            return new EnumConstantDefBuilder(name);
        }
    }

    public static final class EnumConstantDefBuilder {
        private final String name;
        private List<ExpressionDef> constructorArgs;
        private List<String> javadoc = new ArrayList<String>();

        public EnumConstantDefBuilder(String name) {
            this.name = name;
        }

        public EnumConstantDefBuilder withConstructorArgs(List<ExpressionDef> constructorArgs) {
            this.constructorArgs = constructorArgs;
            return this;
        }

        public EnumConstantDefBuilder addJavadoc(String javadoc) {
            this.javadoc.add(javadoc);
            return this;
        }

        public EnumConstantDef build() {
            return new EnumConstantDef(this.name, this.constructorArgs, this.javadoc);
        }
    }
}

