/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.model;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.annotation.MutableAnnotationMetadata;
import io.micronaut.inject.ast.ArrayableClassElement;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.PrimitiveElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.sourcegen.model.AnnotationDef;
import io.micronaut.sourcegen.model.ClassTypeDef;
import io.micronaut.sourcegen.model.MethodDef;
import io.micronaut.sourcegen.model.ObjectDef;
import io.micronaut.sourcegen.model.ObjectDefBuilder;
import io.micronaut.sourcegen.model.PropertyDef;
import io.micronaut.sourcegen.model.TypeDef;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import javax.lang.model.element.Modifier;

public final class RecordDef
extends ObjectDef {
    private final List<TypeDef.TypeVariable> typeVariables;

    private RecordDef(ClassTypeDef.ClassName className, EnumSet<Modifier> modifiers, List<MethodDef> methods, List<PropertyDef> properties, List<AnnotationDef> annotations, List<String> javadoc, List<TypeDef.TypeVariable> typeVariables, List<TypeDef> superinterfaces, List<ObjectDef> innerTypes, boolean synthetic) {
        super(className, modifiers, annotations, javadoc, methods, properties, superinterfaces, innerTypes, synthetic);
        this.typeVariables = typeVariables;
    }

    @Override
    public RecordDef withClassName(ClassTypeDef.ClassName className) {
        return new RecordDef(className, this.modifiers, this.methods, this.properties, this.annotations, this.javadoc, this.typeVariables, this.superinterfaces, this.innerTypes, this.synthetic);
    }

    public static RecordDefBuilder builder(String name) {
        return new RecordDefBuilder(name);
    }

    public List<TypeDef.TypeVariable> getTypeVariables() {
        return this.typeVariables;
    }

    public List<PropertyElement> getBeanProperties(final VisitorContext visitorContext) {
        ArrayList<1> propertyElements = new ArrayList<1>(this.properties.size());
        final MutableAnnotationMetadata annotationMetadata = new MutableAnnotationMetadata();
        for (AnnotationDef annotation : this.annotations) {
            annotationMetadata.addDeclaredAnnotation(annotation.getType().getName(), new LinkedHashMap<String, Object>(annotation.getValues()));
        }
        for (final PropertyDef property : this.properties) {
            propertyElements.add(new PropertyElement(){

                @NonNull
                public ClassElement getType() {
                    TypeDef type = property.getType();
                    return RecordDef.toClassElement(type, visitorContext);
                }

                public ClassElement getDeclaringType() {
                    return ClassElement.of((String)RecordDef.this.className.getCanonicalName());
                }

                @NonNull
                public String getName() {
                    return property.getName();
                }

                public boolean isProtected() {
                    return false;
                }

                public boolean isPublic() {
                    return true;
                }

                @NonNull
                public Object getNativeType() {
                    return property;
                }

                @NonNull
                public AnnotationMetadata getAnnotationMetadata() {
                    return annotationMetadata;
                }

                public PropertyElement.AccessKind getReadAccessKind() {
                    return PropertyElement.AccessKind.METHOD;
                }
            });
        }
        return Collections.unmodifiableList(propertyElements);
    }

    public List<ParameterElement> getConstructorParameters(final VisitorContext visitorContext) {
        ArrayList<2> propertyElements = new ArrayList<2>(this.properties.size());
        final MutableAnnotationMetadata annotationMetadata = new MutableAnnotationMetadata();
        for (AnnotationDef annotation : this.annotations) {
            annotationMetadata.addDeclaredAnnotation(annotation.getType().getName(), new LinkedHashMap<String, Object>(annotation.getValues()));
        }
        for (final PropertyDef property : this.properties) {
            propertyElements.add(new ParameterElement(){

                @NonNull
                public ClassElement getType() {
                    TypeDef type = property.getType();
                    return RecordDef.toClassElement(type, visitorContext);
                }

                @NonNull
                public String getName() {
                    return property.getName();
                }

                public boolean isProtected() {
                    return false;
                }

                public boolean isPublic() {
                    return true;
                }

                @NonNull
                public Object getNativeType() {
                    return property;
                }

                @NonNull
                public AnnotationMetadata getAnnotationMetadata() {
                    return annotationMetadata;
                }
            });
        }
        return Collections.unmodifiableList(propertyElements);
    }

    private static ClassElement toClassElement(TypeDef type, VisitorContext visitorContext) {
        TypeDef.Array array;
        TypeDef typeDef;
        ClassElement componentType;
        if (type instanceof TypeDef.Primitive) {
            TypeDef.Primitive primitive = (TypeDef.Primitive)type;
            return PrimitiveElement.valueOf((String)primitive.name());
        }
        if (type instanceof ClassTypeDef.ClassElementType) {
            ClassTypeDef.ClassElementType cet = (ClassTypeDef.ClassElementType)type;
            return cet.classElement();
        }
        if (type instanceof ClassTypeDef.JavaClass) {
            ClassTypeDef.JavaClass javaClass = (ClassTypeDef.JavaClass)type;
            return (ClassElement)visitorContext.getClassElement(javaClass.getName()).orElseThrow(() -> new IllegalStateException("Class missing from compilation path: " + javaClass.getName()));
        }
        if (type instanceof ClassTypeDef.ClassName) {
            ClassTypeDef.ClassName javaClass = (ClassTypeDef.ClassName)type;
            return (ClassElement)visitorContext.getClassElement(javaClass.getName()).orElseThrow(() -> new IllegalStateException("Class missing from compilation path: " + javaClass.getName()));
        }
        if (type instanceof ClassTypeDef.ClassDefType) {
            ClassTypeDef.ClassDefType classDefType = (ClassTypeDef.ClassDefType)type;
            return (ClassElement)visitorContext.getClassElement(classDefType.getName()).orElseThrow(() -> new IllegalStateException("Class missing from compilation path: " + classDefType.getName()));
        }
        if (type instanceof ClassTypeDef.Parameterized) {
            ClassTypeDef.Parameterized parameterized = (ClassTypeDef.Parameterized)type;
            ClassTypeDef rawType = parameterized.rawType();
            if (rawType instanceof ClassTypeDef.ClassElementType) {
                ClassTypeDef.ClassElementType cet = (ClassTypeDef.ClassElementType)rawType;
                return cet.classElement();
            }
            ClassElement classElement = RecordDef.toClassElement(rawType, visitorContext);
            return classElement.withTypeArguments(parameterized.typeArguments().stream().map(tf -> RecordDef.toClassElement(tf, visitorContext)).toList());
        }
        if (type instanceof TypeDef.Array && (componentType = RecordDef.toClassElement(typeDef = (array = (TypeDef.Array)type).componentType(), visitorContext)) instanceof ArrayableClassElement) {
            ArrayableClassElement arrayableClassElement = (ArrayableClassElement)componentType;
            return arrayableClassElement.withArrayDimensions(array.dimensions());
        }
        throw new IllegalStateException("Only properties constructed from source elements are supported");
    }

    public static final class RecordDefBuilder
    extends ObjectDefBuilder<RecordDefBuilder> {
        private final List<TypeDef.TypeVariable> typeVariables = new ArrayList<TypeDef.TypeVariable>();

        private RecordDefBuilder(String name) {
            super(name);
        }

        public RecordDefBuilder addTypeVariable(TypeDef.TypeVariable typeVariable) {
            this.typeVariables.add(typeVariable);
            return this;
        }

        public RecordDef build() {
            return new RecordDef(new ClassTypeDef.ClassName(this.name), this.modifiers, this.methods, this.properties, this.annotations, this.javadoc, this.typeVariables, this.superinterfaces, this.innerTypes, this.synthetic);
        }
    }
}

