/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.model;

import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.sourcegen.model.AnnotationDef;
import io.micronaut.sourcegen.model.ExpressionDef;
import io.micronaut.sourcegen.model.FieldDef;
import io.micronaut.sourcegen.model.InterfaceDef;
import io.micronaut.sourcegen.model.LambdaDef;
import io.micronaut.sourcegen.model.MethodDef;
import io.micronaut.sourcegen.model.ObjectDef;
import io.micronaut.sourcegen.model.TypeDef;
import io.micronaut.sourcegen.model.VariableDef;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ClassTypeDef
extends TypeDef {
    public static final ClassTypeDef OBJECT = ClassTypeDef.of(Object.class);

    private static int hashCode(ClassTypeDef classTypeDef) {
        return classTypeDef.getName().hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean equals(ClassTypeDef classTypeDef, Object o) {
        if (classTypeDef == o) {
            return true;
        }
        if (classTypeDef == null) return false;
        if (o == null) {
            return false;
        }
        if (classTypeDef instanceof Parameterized) {
            Parameterized parameterized1 = (Parameterized)classTypeDef;
            if (!(o instanceof Parameterized)) return false;
            Parameterized parameterized2 = (Parameterized)o;
            if (!parameterized1.getName().equals(parameterized2.getName())) return false;
            if (!parameterized1.typeArguments.equals(parameterized2.typeArguments)) return false;
            if (parameterized1.isNullable() != parameterized2.isNullable()) return false;
            return true;
        }
        if (o instanceof Parameterized) {
            return false;
        }
        if (!(o instanceof ClassTypeDef)) return false;
        ClassTypeDef other = (ClassTypeDef)o;
        if (!classTypeDef.getName().equals(other.getName())) return false;
        if (classTypeDef.isNullable() != other.isNullable()) return false;
        return true;
    }

    public String getName();

    @Override
    default public ClassTypeDef resolveTypeVariables(Map<String, TypeDef> resolvedTypeVariables) {
        return this;
    }

    default public String getCanonicalName() {
        if (this.isInner()) {
            return this.getName().replace("$", ".");
        }
        return this.getName();
    }

    default public String getSimpleName() {
        String name = this.getCanonicalName();
        int i = name.lastIndexOf(46);
        if (i == -1) {
            return name;
        }
        return name.substring(i + 1);
    }

    default public String getPackageName() {
        String name = this.getCanonicalName();
        int i = name.lastIndexOf(46);
        if (i == -1) {
            return "";
        }
        return name.substring(0, i);
    }

    @Override
    public ClassTypeDef makeNullable();

    default public boolean isEnum() {
        return false;
    }

    default public boolean isInterface() {
        return false;
    }

    default public boolean isInner() {
        return false;
    }

    default public LambdaDef getLambda(Map<String, TypeDef> resolvedTypeVariables) {
        throw new UnsupportedOperationException("ClassTypeDef: " + this.getName() + " doesn't support lambdas");
    }

    default public LambdaDef getLambda() {
        return this.getLambda(Map.of());
    }

    default public ExpressionDef.NewInstance instantiate(ExpressionDef ... values) {
        return this.instantiate(List.of(values));
    }

    default public ExpressionDef.NewInstance instantiate(List<? extends ExpressionDef> values) {
        return this.instantiate(values.stream().map(ExpressionDef::type).toList(), values);
    }

    default public ExpressionDef.NewInstance instantiate(List<TypeDef> parameterTypes, ExpressionDef ... values) {
        return this.instantiate(parameterTypes, List.of(values));
    }

    default public ExpressionDef.NewInstance instantiate(List<TypeDef> parameterTypes, List<? extends ExpressionDef> values) {
        return new ExpressionDef.NewInstance(this, parameterTypes, values);
    }

    default public ExpressionDef.NewInstance instantiate(Constructor<?> constructor, ExpressionDef ... values) {
        return this.instantiate(constructor, List.of(values));
    }

    default public ExpressionDef.NewInstance instantiate(Constructor<?> constructor, List<? extends ExpressionDef> values) {
        return this.instantiate(Arrays.stream(constructor.getParameterTypes()).map(TypeDef::of).toList(), values);
    }

    default public ExpressionDef.NewInstance instantiate(MethodElement methodElement, List<? extends ExpressionDef> values) {
        return this.instantiate(Arrays.stream(methodElement.getSuspendParameters()).map(ParameterElement::getType).map(TypeDef::erasure).toList(), values);
    }

    default public VariableDef.StaticField getStaticField(String name, TypeDef type) {
        return new VariableDef.StaticField(this, name, type);
    }

    default public VariableDef.StaticField getStaticField(FieldDef field) {
        return this.getStaticField(field.getName(), field.getType());
    }

    default public VariableDef.StaticField getStaticField(Field field) {
        return this.getStaticField(field.getName(), TypeDef.of(field.getType()));
    }

    default public ExpressionDef.InvokeStaticMethod invokeStatic(String name, TypeDef returningType, List<? extends ExpressionDef> values) {
        return this.invokeStatic(name, values.stream().map(ExpressionDef::type).toList(), returningType, values);
    }

    default public ExpressionDef.InvokeStaticMethod invokeStatic(String name, List<TypeDef> parameterTypes, TypeDef returningType, List<? extends ExpressionDef> values) {
        return new ExpressionDef.InvokeStaticMethod(this, MethodDef.builder(name).addParameters(parameterTypes).returns(returningType).build(), values);
    }

    default public ExpressionDef.InvokeStaticMethod invokeStatic(String name, TypeDef returningType, ExpressionDef ... values) {
        return this.invokeStatic(name, returningType, List.of(values));
    }

    default public ExpressionDef.InvokeStaticMethod invokeStatic(String name, List<TypeDef> parameterTypes, TypeDef returningType, ExpressionDef ... values) {
        return this.invokeStatic(name, parameterTypes, returningType, List.of(values));
    }

    default public ExpressionDef.InvokeStaticMethod invokeStatic(MethodDef method, ExpressionDef ... values) {
        return this.invokeStatic(method, List.of(values));
    }

    default public ExpressionDef.InvokeStaticMethod invokeStatic(Method method, ExpressionDef ... values) {
        return this.invokeStatic(method, List.of(values));
    }

    default public ExpressionDef.InvokeStaticMethod invokeStatic(Method method, List<? extends ExpressionDef> values) {
        return this.invokeStatic(method.getName(), Arrays.stream(method.getParameters()).map(p -> TypeDef.of(p.getType())).toList(), TypeDef.of(method.getReturnType()), values);
    }

    default public ExpressionDef.InvokeStaticMethod invokeStatic(MethodElement methodElement, ExpressionDef ... values) {
        return this.invokeStatic(methodElement, List.of(values));
    }

    default public ExpressionDef.InvokeStaticMethod invokeStatic(MethodElement methodElement, List<? extends ExpressionDef> values) {
        return this.invokeStatic(methodElement.getName(), Arrays.stream(methodElement.getSuspendParameters()).map(p -> TypeDef.erasure((TypedElement)p.getType())).toList(), methodElement.isSuspend() ? TypeDef.OBJECT : TypeDef.of((TypedElement)methodElement.getReturnType()), values);
    }

    default public ExpressionDef.InvokeStaticMethod invokeStatic(MethodDef method, List<? extends ExpressionDef> values) {
        return new ExpressionDef.InvokeStaticMethod(this, method, values);
    }

    public static ClassTypeDef of(Class<?> type) {
        if (type.isPrimitive()) {
            throw new IllegalStateException("Primitive classes cannot be of type: " + ClassTypeDef.class.getName());
        }
        return new JavaClass(type, false);
    }

    public static ClassTypeDef of(String className) {
        return ClassTypeDef.of(className, false);
    }

    public static ClassTypeDef erasure(ClassElement classElement) {
        return ClassTypeDef.of(classElement, Map.of(), true);
    }

    public static ClassTypeDef of(String className, boolean isInner) {
        return new ClassName(className, isInner, false);
    }

    public static ClassTypeDef of(ClassElement classElement) {
        return ClassTypeDef.of(classElement, Map.of(), false);
    }

    public static ClassTypeDef of(ClassElement classElement, Map<String, TypeDef> resolvedTypeVariables, boolean erasure) {
        if (classElement.isPrimitive()) {
            throw new IllegalStateException("Primitive classes cannot be of type: " + ClassTypeDef.class.getName());
        }
        if (!classElement.getTypeArguments().isEmpty()) {
            return new Parameterized(new ClassElementType(classElement, classElement.isNullable()), classElement.getTypeArguments().values().stream().map(value -> TypeDef.of((TypedElement)value, resolvedTypeVariables, erasure)).toList());
        }
        return new ClassElementType(classElement, classElement.isNullable());
    }

    public static ClassTypeDef of(ObjectDef objectDef) {
        return new ClassDefType(objectDef, false);
    }

    @Override
    default public AnnotatedClassTypeDef annotated(AnnotationDef ... annotations) {
        return this.annotated((List)List.of(annotations));
    }

    @Override
    default public AnnotatedClassTypeDef annotated(List<AnnotationDef> annotations) {
        return new AnnotatedClassTypeDef(this, annotations);
    }

    public record Parameterized(ClassTypeDef rawType, List<TypeDef> typeArguments) implements ClassTypeDef
    {
        @Override
        public Parameterized resolveTypeVariables(Map<String, TypeDef> resolvedTypeVariables) {
            return new Parameterized(this.rawType, this.typeArguments.stream().map(t -> t.resolveTypeVariables(resolvedTypeVariables)).toList());
        }

        @Override
        public LambdaDef getLambda(Map<String, TypeDef> resolvedTypeVariables) {
            ClassTypeDef lambdaType = this.resolveTypeVariables((Map)resolvedTypeVariables);
            LambdaDef lambda = this.rawType.getLambda(resolvedTypeVariables);
            return new LambdaDef(lambdaType, lambda.getMethod(), lambda.getImplementation());
        }

        @Override
        public String getName() {
            return this.rawType.getName();
        }

        @Override
        public String getSimpleName() {
            return this.rawType.getSimpleName();
        }

        @Override
        public String getCanonicalName() {
            return this.rawType.getCanonicalName();
        }

        @Override
        public boolean isNullable() {
            return this.rawType.isNullable();
        }

        @Override
        public ClassTypeDef makeNullable() {
            return new Parameterized(this.rawType.makeNullable(), this.typeArguments);
        }

        @Override
        public boolean isInner() {
            return this.rawType.isInner();
        }

        @Override
        public boolean isInterface() {
            return this.rawType.isInterface();
        }

        @Override
        public int hashCode() {
            return ClassTypeDef.hashCode(this);
        }

        @Override
        public boolean equals(Object obj) {
            return ClassTypeDef.equals(this, obj);
        }
    }

    public record JavaClass(Class<?> type, boolean nullable) implements ClassTypeDef
    {
        @Override
        public String getName() {
            return this.type.getName();
        }

        @Override
        public String getSimpleName() {
            return this.type.getSimpleName();
        }

        @Override
        public String getCanonicalName() {
            return this.type.getCanonicalName();
        }

        @Override
        public boolean isNullable() {
            return this.nullable;
        }

        @Override
        public ClassTypeDef makeNullable() {
            return new JavaClass(this.type, true);
        }

        @Override
        public boolean isEnum() {
            return this.type.isEnum();
        }

        @Override
        public boolean isInterface() {
            return this.type.isInterface();
        }

        @Override
        public boolean isInner() {
            return this.type.isMemberClass();
        }

        @Override
        public int hashCode() {
            return ClassTypeDef.hashCode(this);
        }

        @Override
        public boolean equals(Object obj) {
            return ClassTypeDef.equals(this, obj);
        }
    }

    public record ClassName(String name, boolean isInner, boolean nullable) implements ClassTypeDef
    {
        public ClassName(String name) {
            this(name, false);
        }

        public ClassName(String name, boolean isInner) {
            this(name, isInner, false);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isNullable() {
            return this.nullable;
        }

        @Override
        public ClassTypeDef makeNullable() {
            return new ClassName(this.name, this.isInner, true);
        }

        @Override
        public int hashCode() {
            return ClassTypeDef.hashCode(this);
        }

        @Override
        public boolean equals(Object obj) {
            return ClassTypeDef.equals(this, obj);
        }
    }

    public record ClassElementType(ClassElement classElement, boolean nullable) implements ClassTypeDef
    {
        @Override
        public LambdaDef getLambda(Map<String, TypeDef> resolvedTypeVariables) {
            List abstractMethods = this.classElement.getEnclosedElements(ElementQuery.of(MethodElement.class).onlyAbstract());
            if (abstractMethods.size() != 1) {
                throw new IllegalArgumentException("Parent of a lambda should have exactly one abstract method but has " + abstractMethods.size());
            }
            MethodElement methodElement = (MethodElement)abstractMethods.get(0);
            return new LambdaDef((ClassTypeDef)ClassTypeDef.of(this.classElement).resolveTypeVariables((Map)resolvedTypeVariables), MethodDef.of(methodElement), MethodDef.of(methodElement, resolvedTypeVariables));
        }

        @Override
        public String getName() {
            return this.classElement.getName();
        }

        @Override
        public String getSimpleName() {
            return this.classElement.getSimpleName();
        }

        @Override
        public String getCanonicalName() {
            return this.classElement.getCanonicalName();
        }

        @Override
        public boolean isNullable() {
            return this.nullable;
        }

        @Override
        public ClassTypeDef makeNullable() {
            return new ClassElementType(this.classElement, true);
        }

        @Override
        public boolean isEnum() {
            return this.classElement.isEnum();
        }

        @Override
        public boolean isInterface() {
            return this.classElement.isInterface();
        }

        @Override
        public boolean isInner() {
            return this.classElement.isInner();
        }

        @Override
        public int hashCode() {
            return ClassTypeDef.hashCode(this);
        }

        @Override
        public boolean equals(Object obj) {
            return ClassTypeDef.equals(this, obj);
        }
    }

    public record ClassDefType(ObjectDef objectDef, boolean nullable) implements ClassTypeDef
    {
        @Override
        public LambdaDef getLambda(Map<String, TypeDef> resolvedTypeVariables) {
            List<MethodDef> methods = this.objectDef.getMethods().stream().filter(v -> v.getModifiers().contains((Object)Modifier.ABSTRACT)).toList();
            if (methods.size() != 1) {
                throw new IllegalArgumentException("Parent of a lambda should have exactly one abstract method but has " + methods.size());
            }
            MethodDef methodDef = methods.get(0);
            return new LambdaDef((ClassTypeDef)ClassTypeDef.of(this.objectDef).resolveTypeVariables((Map)resolvedTypeVariables), methodDef, methodDef.resolveTypeVariables(resolvedTypeVariables));
        }

        @Override
        public String getName() {
            return this.objectDef.className.name;
        }

        @Override
        public boolean isInner() {
            return this.objectDef.className.isInner;
        }

        @Override
        public boolean isInterface() {
            return this.objectDef instanceof InterfaceDef;
        }

        @Override
        public boolean isNullable() {
            return this.nullable;
        }

        @Override
        public ClassTypeDef makeNullable() {
            return new ClassDefType(this.objectDef, true);
        }

        @Override
        public int hashCode() {
            return ClassTypeDef.hashCode(this);
        }

        @Override
        public boolean equals(Object obj) {
            return ClassTypeDef.equals(this, obj);
        }
    }

    public record AnnotatedClassTypeDef(ClassTypeDef typeDef, List<AnnotationDef> annotations) implements TypeDef.Annotated
    {
    }
}

